/*
 * Decompiled with CFR 0.152.
 */
package cn.lunadeer.dominion.uis.dominion.manage.group;

import cn.lunadeer.dominion.api.dtos.DominionDTO;
import cn.lunadeer.dominion.api.dtos.GroupDTO;
import cn.lunadeer.dominion.api.dtos.MemberDTO;
import cn.lunadeer.dominion.commands.GroupCommand;
import cn.lunadeer.dominion.configuration.uis.ChestUserInterface;
import cn.lunadeer.dominion.inputters.RenameGroupInputter;
import cn.lunadeer.dominion.misc.Asserts;
import cn.lunadeer.dominion.misc.Converts;
import cn.lunadeer.dominion.uis.AbstractUI;
import cn.lunadeer.dominion.uis.dominion.manage.group.GroupList;
import cn.lunadeer.dominion.uis.dominion.manage.group.GroupSetting;
import cn.lunadeer.dominion.uis.dominion.manage.group.SelectMember;
import cn.lunadeer.dominion.utils.Misc;
import cn.lunadeer.dominion.utils.configuration.ConfigurationPart;
import cn.lunadeer.dominion.utils.scui.ChestButton;
import cn.lunadeer.dominion.utils.scui.ChestListView;
import cn.lunadeer.dominion.utils.scui.ChestUserInterfaceManager;
import cn.lunadeer.dominion.utils.scui.configuration.ButtonConfiguration;
import cn.lunadeer.dominion.utils.scui.configuration.ListViewConfiguration;
import java.util.List;
import org.bukkit.Material;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.ClickType;

public class GroupManage
extends AbstractUI {
    public static void show(CommandSender sender, String dominionName, String groupName, String pageStr) {
        new GroupManage().displayByPreference(sender, dominionName, groupName, pageStr);
    }

    @Override
    protected void showTUI(Player player, String ... args) {
        throw new UnsupportedOperationException("GroupManage does not support TUI.");
    }

    @Override
    protected void showCUI(final Player player, final String ... args) throws Exception {
        final DominionDTO dominion = Converts.toDominionDTO(args[0]);
        Asserts.assertDominionAdmin(player, dominion);
        final GroupDTO group = Converts.toGroupDTO(dominion, args[1]);
        final ChestListView view = ChestUserInterfaceManager.getInstance().getListViewOf(player);
        view.setTitle(Misc.formatString(ChestUserInterface.groupManageCUI.title, group.getNameColoredBukkit()));
        view.applyListConfiguration(ChestUserInterface.groupManageCUI.listConfiguration, Converts.toIntegrity(args[2]));
        view.setButton(ChestUserInterface.groupManageCUI.backButton.getSymbol(), new ChestButton(ChestUserInterface.groupManageCUI.backButton){

            @Override
            public void onClick(ClickType type) {
                GroupList.show((CommandSender)player, args[0], "1");
            }
        });
        view.setButton(ChestUserInterface.groupManageCUI.groupFlagsButton.getSymbol(), new ChestButton(ChestUserInterface.groupManageCUI.groupFlagsButton){

            @Override
            public void onClick(ClickType type) {
                GroupSetting.show((CommandSender)player, args[0], args[1], "1");
            }
        });
        view.setButton(ChestUserInterface.groupManageCUI.renameGroupButton.getSymbol(), new ChestButton(ChestUserInterface.groupManageCUI.renameGroupButton){

            @Override
            public void onClick(ClickType type) {
                RenameGroupInputter.createOn((CommandSender)player, args[0], args[1]);
                view.close();
            }
        });
        view.setButton(ChestUserInterface.groupManageCUI.deleteGroupButton.getSymbol(), new ChestButton(ChestUserInterface.groupManageCUI.deleteGroupButton){

            @Override
            public void onClick(ClickType type) {
                GroupCommand.deleteGroup((CommandSender)player, args[0], args[1], "1");
            }
        });
        view.addItem(new ChestButton(ChestUserInterface.groupManageCUI.addMemberButton){

            @Override
            public void onClick(ClickType type) {
                SelectMember.show((CommandSender)player, dominion.getName(), group.getNamePlain(), "1", "1");
            }
        });
        for (int i = 0; i < group.getMembers().size(); ++i) {
            final MemberDTO m = group.getMembers().get(i);
            final Integer page = (int)Math.ceil((double)(i + 2) / (double)view.getPageSize());
            ButtonConfiguration item = ButtonConfiguration.createHeadByName(ChestUserInterface.groupManageCUI.listConfiguration.itemSymbol.charAt(0), m.getPlayer().getLastKnownName(), m.getPlayer().getLastKnownName(), ChestUserInterface.groupManageCUI.playerHeadItemLore);
            view.addItem(new ChestButton(item){

                @Override
                public void onClick(ClickType type) {
                    GroupCommand.removeMember((CommandSender)player, dominion.getName(), group.getNamePlain(), m.getPlayer().getLastKnownName(), page.toString());
                    GroupManage.show((CommandSender)player, dominion.getName(), group.getNamePlain(), page.toString());
                }
            });
        }
        view.open();
    }

    public static class GroupManageCUI
    extends ConfigurationPart {
        public String title = "\u00a76\u2726 \u00a7d\u00a7lManage Group {0} \u00a76\u2726";
        public ListViewConfiguration listConfiguration = new ListViewConfiguration('i', List.of("<##P#R#D#", "#iiiiiii#", "#iiiiiii#", "#iiiiiii#", "p#######n"));
        public ButtonConfiguration backButton = ButtonConfiguration.createMaterial('<', Material.RED_STAINED_GLASS_PANE, "\u00a7c\u00ab Back to Group List", List.of("\u00a77Return to the group list", "\u00a77to manage other groups.", "", "\u00a7e\u25b6 Click to go back"));
        public ButtonConfiguration groupFlagsButton = ButtonConfiguration.createMaterial('P', Material.BAMBOO_SIGN, "\u00a76\ud83d\udccb \u00a7e\u00a7lGroup Permissions", List.of("\u00a77Configure what this group", "\u00a77can and cannot do in the dominion.", "", "\u00a7e\u25b6 Click to edit permissions", "\u00a78  Set build, interact, etc...", "", "\u00a77Type: \u00a76Permission Settings"));
        public ButtonConfiguration renameGroupButton = ButtonConfiguration.createMaterial('R', Material.NAME_TAG, "\u00a7b\u270f \u00a73\u00a7lRename Group", List.of("\u00a77Change the display name", "\u00a77of this permission group.", "", "\u00a73\u25b6 Click to rename group", "\u00a78  Choose a new creative name!", "", "\u00a77Current: \u00a7f{0}"));
        public ButtonConfiguration deleteGroupButton = ButtonConfiguration.createMaterial('D', Material.TNT, "\u00a7c\ud83d\udca5 \u00a74\u00a7lDelete Group", List.of("\u00a7c\u26a0 \u00a77This action cannot be undone!", "\u00a77All members will be moved to", "\u00a77the default group automatically.", "", "\u00a74\u25b6 Click to delete group", "", "\u00a78Think twice before proceeding..."));
        public ButtonConfiguration addMemberButton = ButtonConfiguration.createMaterial('i', Material.LIME_DYE, "\u00a7a\u2795 \u00a72\u00a7lAdd Member", List.of("\u00a77Select a member from your", "\u00a77dominion to add to this group.", "", "\u00a72\u25b6 Click to select player", "\u00a78  Grant them group permissions!", "", "\u00a77Action: \u00a7aAdd to Group"));
        public List<String> playerHeadItemLore = List.of("\u00a77Member of this permission group", "", "\u00a7c\u25b6 Click to remove from group", "\u00a78  They'll return to default group");
    }
}

