/*
 * Decompiled with CFR 0.152.
 */
package cn.lunadeer.dominion.uis.template;

import cn.lunadeer.dominion.Dominion;
import cn.lunadeer.dominion.commands.TemplateCommand;
import cn.lunadeer.dominion.configuration.uis.ChestUserInterface;
import cn.lunadeer.dominion.configuration.uis.TextUserInterface;
import cn.lunadeer.dominion.doos.TemplateDOO;
import cn.lunadeer.dominion.inputters.CreateTemplateInputter;
import cn.lunadeer.dominion.misc.Converts;
import cn.lunadeer.dominion.uis.AbstractUI;
import cn.lunadeer.dominion.uis.MainMenu;
import cn.lunadeer.dominion.uis.template.TemplateSetting;
import cn.lunadeer.dominion.utils.configuration.ConfigurationPart;
import cn.lunadeer.dominion.utils.scui.ChestButton;
import cn.lunadeer.dominion.utils.scui.ChestListView;
import cn.lunadeer.dominion.utils.scui.ChestUserInterfaceManager;
import cn.lunadeer.dominion.utils.scui.configuration.ButtonConfiguration;
import cn.lunadeer.dominion.utils.scui.configuration.ListViewConfiguration;
import cn.lunadeer.dominion.utils.stui.ListView;
import cn.lunadeer.dominion.utils.stui.components.Line;
import cn.lunadeer.dominion.utils.stui.components.buttons.Button;
import cn.lunadeer.dominion.utils.stui.components.buttons.ListViewButton;
import java.util.List;
import org.bukkit.Material;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.ClickType;

public class TemplateList
extends AbstractUI {
    public static void show(CommandSender sender, String pageStr) {
        new TemplateList().displayByPreference(sender, pageStr);
    }

    public static ListViewButton button(final CommandSender sender) {
        return (ListViewButton)new ListViewButton(TextUserInterface.templateListTuiText.button){

            @Override
            public void function(String pageStr) {
                TemplateList.show(sender, pageStr);
            }
        }.needPermission(Dominion.defaultPermission);
    }

    @Override
    protected void showTUI(final Player player, String ... args) throws Exception {
        int page = Converts.toIntegrity(args[0], 1);
        List<TemplateDOO> templates = TemplateDOO.selectAll(player.getUniqueId());
        ListView view = ListView.create(10, TemplateList.button((CommandSender)player));
        view.title(TextUserInterface.templateListTuiText.title);
        view.navigator(Line.create().append(MainMenu.button((CommandSender)player).build()).append(TextUserInterface.templateListTuiText.button));
        view.add(Line.create().append(CreateTemplateInputter.createTuiButtonOn((CommandSender)player).needPermission(Dominion.defaultPermission).build()));
        for (final TemplateDOO template : templates) {
            Button setting = TemplateSetting.button((CommandSender)player, template.getName()).green();
            Button delete = new ListViewButton(TextUserInterface.templateListTuiText.deleteButton){

                @Override
                public void function(String pageStr) {
                    TemplateCommand.deleteTemplate((CommandSender)player, template.getName(), pageStr);
                }
            }.needPermission(Dominion.defaultPermission).red();
            Line line = Line.create().append(delete.build()).append(setting.build()).append(template.getName());
            view.add(line);
        }
        view.showOn(player, page);
    }

    @Override
    protected void showCUI(final Player player, String ... args) throws Exception {
        final ChestListView view = ChestUserInterfaceManager.getInstance().getListViewOf(player);
        view.setTitle(ChestUserInterface.templateListCui.title);
        view.applyListConfiguration(ChestUserInterface.templateListCui.listConfiguration, Converts.toIntegrity(args[0], 1));
        view.addItem(new ChestButton(ChestUserInterface.templateListCui.createTemplateButton){

            @Override
            public void onClick(ClickType type) {
                CreateTemplateInputter.createOn((CommandSender)player);
                view.close();
            }
        });
        List<TemplateDOO> templates = TemplateDOO.selectAll(player.getUniqueId());
        for (final TemplateDOO template : templates) {
            ChestButton btn = new ChestButton(ChestUserInterface.templateListCui.templateItemButton){

                @Override
                public void onClick(ClickType type) {
                    TemplateSetting.show((CommandSender)player, template.getName(), "1");
                }
            };
            btn = btn.setDisplayNameArgs(template.getName());
            view.addItem(btn);
        }
        view.setButton(ChestUserInterface.templateListCui.backButton.getSymbol(), new ChestButton(ChestUserInterface.templateListCui.backButton){

            @Override
            public void onClick(ClickType type) {
                MainMenu.show((CommandSender)player, "1");
            }
        });
        view.open();
    }

    public static class TemplateListTuiText
    extends ConfigurationPart {
        public String title = "Template List";
        public String button = "TEMPLATES";
        public String description = "Templates can be used to quickly setup privileges of member.";
        public String deleteButton = "DELETE";
    }

    public static class TemplateListCui
    extends ConfigurationPart {
        public String title = "\u00a76\u2726 \u00a7d\u00a7lTemplate Management \u00a76\u2726";
        public ListViewConfiguration listConfiguration = new ListViewConfiguration('i', List.of("<########", "#iiiiiii#", "#iiiiiii#", "#iiiiiii#", "p#######n"));
        public ButtonConfiguration templateItemButton = ButtonConfiguration.createMaterial('i', Material.PAPER, "\u00a76\u2726 \u00a7f{0} \u00a76\u2726", List.of("\u00a77Template for managing permissions", "\u00a78and access controls quickly.", "", "\u00a7e\u25b6 Click to edit template"));
        public ButtonConfiguration createTemplateButton = ButtonConfiguration.createMaterial('i', Material.LIME_DYE, "\u00a7a+ Create New Template", List.of("\u00a77Create a new permission template", "\u00a78to quickly setup member privileges.", "", "\u00a7e\u25b6 Click to create template", "", "\u00a77Action: \u00a7aCreate Template"));
        public ButtonConfiguration backButton = ButtonConfiguration.createMaterial('<', Material.RED_STAINED_GLASS_PANE, "\u00a7c\u00ab Back to Main Menu", List.of("\u00a77Return to the main menu", "\u00a78to access other features.", "", "\u00a7e\u25b6 Click to go back"));
    }
}

