/*
 * Decompiled with CFR 0.152.
 */
package cn.lunadeer.dominion.uis.template;

import cn.lunadeer.dominion.Dominion;
import cn.lunadeer.dominion.api.dtos.flag.Flags;
import cn.lunadeer.dominion.api.dtos.flag.PriFlag;
import cn.lunadeer.dominion.commands.TemplateCommand;
import cn.lunadeer.dominion.configuration.uis.ChestUserInterface;
import cn.lunadeer.dominion.configuration.uis.TextUserInterface;
import cn.lunadeer.dominion.doos.TemplateDOO;
import cn.lunadeer.dominion.inputters.RenameTemplateInputter;
import cn.lunadeer.dominion.misc.Converts;
import cn.lunadeer.dominion.uis.AbstractUI;
import cn.lunadeer.dominion.uis.MainMenu;
import cn.lunadeer.dominion.uis.template.TemplateList;
import cn.lunadeer.dominion.utils.Misc;
import cn.lunadeer.dominion.utils.Notification;
import cn.lunadeer.dominion.utils.configuration.ConfigurationPart;
import cn.lunadeer.dominion.utils.scui.ChestButton;
import cn.lunadeer.dominion.utils.scui.ChestListView;
import cn.lunadeer.dominion.utils.scui.ChestUserInterfaceManager;
import cn.lunadeer.dominion.utils.scui.configuration.ButtonConfiguration;
import cn.lunadeer.dominion.utils.scui.configuration.ListViewConfiguration;
import cn.lunadeer.dominion.utils.stui.ListView;
import cn.lunadeer.dominion.utils.stui.components.Line;
import cn.lunadeer.dominion.utils.stui.components.buttons.FunctionalButton;
import cn.lunadeer.dominion.utils.stui.components.buttons.ListViewButton;
import java.util.List;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.event.HoverEventSource;
import org.bukkit.Material;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.ClickType;

public class TemplateSetting
extends AbstractUI {
    public static void show(CommandSender sender, String templateName, String pageStr) {
        new TemplateSetting().displayByPreference(sender, templateName, pageStr);
    }

    public static ListViewButton button(final CommandSender sender, final String templateName) {
        return (ListViewButton)new ListViewButton(TextUserInterface.templateSettingTuiText.button){

            @Override
            public void function(String pageStr) {
                TemplateSetting.show(sender, templateName, pageStr);
            }
        }.needPermission(Dominion.defaultPermission);
    }

    @Override
    protected void showTUI(Player player, String ... args) throws Exception {
        String pageStr = args.length > 1 ? args[1] : "1";
        String templateName = args[0];
        TemplateDOO template = TemplateDOO.select(player.getUniqueId(), templateName);
        if (template == null) {
            Notification.error((CommandSender)player, TextUserInterface.templateSettingTuiText.notFound, templateName);
            return;
        }
        ListView view = ListView.create(10, TemplateSetting.button((CommandSender)player, templateName));
        view.title(TextUserInterface.templateSettingTuiText.title);
        view.navigator(Line.create().append(MainMenu.button((CommandSender)player).build()).append(TemplateList.button((CommandSender)player).build()).append(TextUserInterface.templateSettingTuiText.button));
        view.add(Line.create().append(RenameTemplateInputter.createTuiButtonOn((CommandSender)player, templateName, pageStr).build()));
        for (PriFlag flag : Flags.getAllPriFlagsEnable()) {
            view.add(TemplateSetting.createOption(player, flag, template.getFlagValue(flag), template.getName(), pageStr));
        }
        view.showOn(player, Converts.toIntegrity(pageStr));
    }

    private static Line createOption(final Player player, final PriFlag flag, boolean value, final String templateName, final String pageStr) {
        if (value) {
            return Line.create().append(new FunctionalButton("\u2611"){

                @Override
                public void function() {
                    TemplateCommand.setTemplateFlag((CommandSender)player, templateName, flag.getFlagName(), "false", pageStr);
                }
            }.needPermission(Dominion.defaultPermission).green().build()).append((TextComponent)Component.text((String)flag.getDisplayName()).hoverEvent((HoverEventSource)Component.text((String)flag.getDescription())));
        }
        return Line.create().append(new FunctionalButton("\u2610"){

            @Override
            public void function() {
                TemplateCommand.setTemplateFlag((CommandSender)player, templateName, flag.getFlagName(), "true", pageStr);
            }
        }.needPermission(Dominion.defaultPermission).red().build()).append((TextComponent)Component.text((String)flag.getDisplayName()).hoverEvent((HoverEventSource)Component.text((String)flag.getDescription())));
    }

    @Override
    protected void showCUI(final Player player, String ... args) throws Exception {
        final String templateName = args[0];
        String pageStr = args.length > 1 ? args[1] : "1";
        final TemplateDOO template = TemplateDOO.select(player.getUniqueId(), templateName);
        if (template == null) {
            Notification.error((CommandSender)player, TextUserInterface.templateSettingTuiText.notFound, templateName);
            return;
        }
        final ChestListView view = ChestUserInterfaceManager.getInstance().getListViewOf(player);
        view.setTitle(Misc.formatString(ChestUserInterface.templateSettingCui.title, templateName));
        view.applyListConfiguration(ChestUserInterface.templateSettingCui.listConfiguration, Converts.toIntegrity(pageStr));
        view.setButton(ChestUserInterface.templateSettingCui.backButton.getSymbol(), new ChestButton(ChestUserInterface.templateSettingCui.backButton){

            @Override
            public void onClick(ClickType type) {
                TemplateList.show((CommandSender)player, "1");
            }
        });
        view.setButton(ChestUserInterface.templateSettingCui.deleteButton.getSymbol(), new ChestButton(ChestUserInterface.templateSettingCui.deleteButton){

            @Override
            public void onClick(ClickType type) {
                TemplateCommand.deleteTemplate((CommandSender)player, templateName, "1");
            }
        });
        view.setButton(ChestUserInterface.templateSettingCui.renameButton.getSymbol(), new ChestButton(ChestUserInterface.templateSettingCui.renameButton){

            @Override
            public void onClick(ClickType type) {
                RenameTemplateInputter.createOn((CommandSender)player, templateName, "1");
                view.close();
            }
        });
        for (int i = 0; i < Flags.getAllPriFlags().size(); ++i) {
            final PriFlag flag = Flags.getAllPriFlags().get(i);
            final Integer page = (int)Math.ceil((double)(i + 1) / (double)view.getPageSize());
            String flagState = template.getFlagValue(flag) != false ? ChestUserInterface.templateSettingCui.flagItemStateTrue : ChestUserInterface.templateSettingCui.flagItemStateFalse;
            String flagName = Misc.formatString(ChestUserInterface.templateSettingCui.flagItemName, flag.getDisplayName());
            List<String> descriptions = Misc.foldLore2Line(flag.getDescription(), 30);
            List<String> flagLore = Misc.formatStringList(ChestUserInterface.templateSettingCui.flagItemLore, flagState, descriptions.get(0), descriptions.get(1));
            ButtonConfiguration btnConfig = ButtonConfiguration.createMaterial(ChestUserInterface.templateSettingCui.listConfiguration.itemSymbol.charAt(0), flag.getMaterial(), flagName, flagLore);
            view.addItem(new ChestButton(btnConfig){

                @Override
                public void onClick(ClickType type) {
                    TemplateCommand.setTemplateFlag((CommandSender)player, templateName, flag.getFlagName(), String.valueOf(template.getFlagValue(flag) == false), page.toString());
                }
            });
        }
        view.open();
    }

    public static class TemplateSettingTuiText
    extends ConfigurationPart {
        public String title = "Template Setting";
        public String button = "SETTING";
        public String notFound = "Template {0} not found.";
    }

    public static class TemplateSettingCui
    extends ConfigurationPart {
        public String title = "\u00a76\u2726 \u00a73\u00a7lTemplate: {0} \u00a76\u2726";
        public ListViewConfiguration listConfiguration = new ListViewConfiguration('i', List.of("<#####RD#", "#iiiiiii#", "#iiiiiii#", "#iiiiiii#", "p#######n"));
        public ButtonConfiguration backButton = ButtonConfiguration.createMaterial('<', Material.RED_STAINED_GLASS_PANE, "\u00a7c\u00ab Back to Template List", List.of("\u00a77Return to the template", "\u00a77list menu.", "", "\u00a7e\u25b6 Click to go back"));
        public ButtonConfiguration renameButton = ButtonConfiguration.createMaterial('R', Material.NAME_TAG, "\u00a7eRename Template", List.of("\u00a77Rename this template.", "", "\u00a7e\u25b6 Click to rename this template"));
        public ButtonConfiguration deleteButton = ButtonConfiguration.createMaterial('D', Material.RED_DYE, "\u00a7cDelete Template", List.of("\u00a77Delete this template.", "\u00a77This action cannot be undone.", "", "\u00a7e\u25b6 Click to delete this template"));
        public String flagItemName = "\u00a76\u2699\ufe0f \u00a7e{0}";
        public String flagItemStateTrue = "\u00a7a\u00a7l\u2713 ENABLED";
        public String flagItemStateFalse = "\u00a7c\u00a7l\u2717 DISABLED";
        public List<String> flagItemLore = List.of("\u00a77Status: {0}", "", "\u00a77Description:", "\u00a7f{1}", "\u00a7f{2}", "", "\u00a7e\u25b6 Click to toggle this setting", "\u00a78Will not take effect until the", "\u00a78next time the template is applied.");
    }
}

