#version 120

#define PIXEL_SIZE 4.0 // [1.0 2.0 3.0 4.0 5.0 6.0 7.0 8.0 9.0 10.0] Pixel size for low-res effect
#define DITHER // Enable dithering for color quantization
#define CREDIT1 // Dummy for credits
#define CREDIT2 // Dummy for version

uniform sampler2D colortex0;
uniform float viewWidth;
uniform float viewHeight;

varying vec2 texcoord;

float bayer4x4(vec2 p){
    float d[16]=float[16](0.,8.,2.,10.,12.,4.,14.,6.,3.,11.,1.,9.,15.,7.,13.,5.);
    int x=int(mod(p.x,4.)),y=int(mod(p.y,4.));
    return d[y*4+x]/16.;
}

void main(){
    vec2 res=vec2(viewWidth,viewHeight);
    vec2 coord=texcoord*res;
    vec2 snapped=floor(coord/PIXEL_SIZE)*PIXEL_SIZE;
    vec2 uv=snapped/res;
    vec4 color=texture2D(colortex0,uv);
    vec3 c=color.rgb;
    float d=0.5;
    #ifdef DITHER
        d=bayer4x4(gl_FragCoord.xy);
    #endif
    c.r=floor(c.r*7.+d)/7.;
    c.g=floor(c.g*7.+d)/7.;
    c.b=floor(c.b*3.+d)/3.;
    gl_FragColor=vec4(c,color.a);
    #ifdef CREDIT1
    #endif
    #ifdef CREDIT2
    #endif
}