/*
 * Decompiled with CFR 0.152.
 */
package com.github.pinmacaroon.tpmacaroon;

import com.github.pinmacaroon.tpmacaroon.command.TpacceptCommand;
import com.github.pinmacaroon.tpmacaroon.command.TpaskCommand;
import com.github.pinmacaroon.tpmacaroon.command.TpcancelCommand;
import com.github.pinmacaroon.tpmacaroon.command.TpdenyCommand;
import com.github.zafarkhaja.semver.Version;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.File;
import java.time.Instant;
import java.util.Random;
import java.util.logging.Logger;
import org.bukkit.command.CommandExecutor;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.plugin.java.JavaPlugin;

public final class PluginMain
extends JavaPlugin {
    public static final Random RANDOM = new Random(Instant.now().getEpochSecond());
    public static final Version VERSION = new Version.Builder().setMajorVersion(0L).setMinorVersion(0L).setPatchVersion(1L).build();
    public static Logger LOGGER;
    public static FileConfiguration CONFIG;
    public static final Gson GSON;

    private void createConfig() {
        try {
            File file;
            if (!this.getDataFolder().exists()) {
                this.getDataFolder().mkdirs();
            }
            if (!(file = new File(this.getDataFolder(), "config.yml")).exists()) {
                this.getLogger().info("Config.yml not found, creating!");
                this.getConfig().options().copyDefaults(true);
                this.saveDefaultConfig();
            } else {
                this.getLogger().info("Config.yml found, loading!");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void onEnable() {
        this.createConfig();
        LOGGER = this.getLogger();
        CONFIG = this.getConfig();
        this.getCommand("tpask").setExecutor((CommandExecutor)new TpaskCommand());
        this.getCommand("tpdeny").setExecutor((CommandExecutor)new TpdenyCommand());
        this.getCommand("tpaccept").setExecutor((CommandExecutor)new TpacceptCommand());
        this.getCommand("tpcancel").setExecutor((CommandExecutor)new TpcancelCommand());
        LOGGER.info(CONFIG.getString("config.key"));
    }

    public void onDisable() {
    }

    static {
        GSON = new GsonBuilder().setPrettyPrinting().create();
    }
}

