/*
 * Decompiled with CFR 0.152.
 */
package de.vexo5566.chatClear;

import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import org.bukkit.Bukkit;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.plugin.java.JavaPlugin;

public class ChatClear
extends JavaPlugin {
    public void onEnable() {
        this.saveDefaultConfig();
        this.getLogger().info("ChatClear Plugin has been enabled!");
    }

    public void onDisable() {
        this.getLogger().info("ChatClear Plugin has been disabled!");
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (command.getName().equalsIgnoreCase("chatclear")) {
            if (!sender.hasPermission("chatclear.use")) {
                sender.sendMessage(this.getMessage("messages.no-permission"));
                return true;
            }
            int lines = this.getConfig().getInt("clear-lines", 100);
            for (Player player : Bukkit.getOnlinePlayers()) {
                if (player.hasPermission("chatclear.bypass")) {
                    player.sendMessage(this.getMessage("messages.bypass-notification"));
                    continue;
                }
                for (int i = 0; i < lines; ++i) {
                    player.sendMessage((Component)Component.empty());
                }
                player.sendMessage(this.getMessage("messages.chat-cleared"));
            }
            String senderName = sender instanceof Player ? ((Player)sender).getName() : "Console";
            String broadcastMsg = this.getConfig().getString("messages.broadcast", "&7The chat has been cleared by &e%player%&7!").replace("%player%", senderName);
            Bukkit.broadcast((Component)LegacyComponentSerializer.legacyAmpersand().deserialize(broadcastMsg));
            return true;
        }
        return false;
    }

    private Component getMessage(String path) {
        String message = this.getConfig().getString(path, "&cMessage not found: " + path);
        return LegacyComponentSerializer.legacyAmpersand().deserialize(message);
    }
}

