/*
 * Decompiled with CFR 0.152.
 */
package codyhuh.unusualfishmod.common.entity;

import codyhuh.unusualfishmod.common.entity.util.base.BucketableSchoolingWaterAnimal;
import codyhuh.unusualfishmod.common.entity.util.goal.FollowSchoolLeaderGoal;
import codyhuh.unusualfishmod.common.entity.util.misc.UFAnimations;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.RandomSource;
import net.minecraft.util.TimeUtil;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.NeutralMob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.SmoothSwimmingLookControl;
import net.minecraft.world.entity.ai.control.SmoothSwimmingMoveControl;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.RandomSwimmingGoal;
import net.minecraft.world.entity.ai.goal.TryFindWaterGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.goal.target.ResetUniversalAngerTargetGoal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.ai.navigation.WaterBoundPathNavigation;
import net.minecraft.world.entity.animal.WaterAnimal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.phys.Vec3;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.util.GeckoLibUtil;

public class RhinoTetra
extends BucketableSchoolingWaterAnimal
implements GeoEntity,
NeutralMob {
    private static final EntityDataAccessor<Integer> REMAINING_ANGER_TIME = SynchedEntityData.m_135353_(RhinoTetra.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final UniformInt PERSISTENT_ANGER_TIME = TimeUtil.m_145020_((int)15, (int)29);
    @Nullable
    private UUID persistentAngerTarget;
    public int stunnedTick;
    private boolean isSchool = true;
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);

    public RhinoTetra(EntityType<? extends BucketableSchoolingWaterAnimal> entityType, Level level) {
        super(entityType, level);
        this.f_21342_ = new SmoothSwimmingMoveControl((Mob)this, 85, 10, 0.2f, 0.1f, true);
        this.f_21365_ = new SmoothSwimmingLookControl((Mob)this, 10);
    }

    @Override
    public ItemStack getBucketStack() {
        return ItemStack.f_41583_;
    }

    @Override
    protected InteractionResult m_6071_(Player p_27477_, InteractionHand p_27478_) {
        return InteractionResult.PASS;
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 10.0).m_22268_(Attributes.f_22281_, 2.0).m_22268_(Attributes.f_22282_, 3.0);
    }

    @Override
    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new TryFindWaterGoal((PathfinderMob)this));
        this.f_21345_.m_25352_(0, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.0, true));
        this.f_21345_.m_25352_(2, (Goal)new RandomSwimmingGoal((PathfinderMob)this, 5.0, 1){

            public boolean m_8036_() {
                return super.m_8036_() && RhinoTetra.this.m_20069_();
            }
        });
        this.f_21345_.m_25352_(2, (Goal)new RandomStrollGoal((PathfinderMob)this, 0.8, 15){

            public boolean m_8036_() {
                return !this.f_25725_.m_20069_() && super.m_8036_();
            }
        });
        this.f_21345_.m_25352_(4, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21345_.m_25352_(4, (Goal)new FollowSchoolLeaderGoal(this));
        this.f_21345_.m_25352_(5, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f));
        this.f_21346_.m_25352_(1, (Goal)new ResetUniversalAngerTargetGoal((Mob)this, false));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, LivingEntity.class, 10, true, false, arg_0 -> ((RhinoTetra)this).m_21674_(arg_0)));
    }

    public void m_8107_() {
        if (!this.m_20069_() && this.m_20096_() && this.f_19863_) {
            this.m_20256_(this.m_20184_().m_82520_((double)((this.f_19796_.m_188501_() * 2.0f - 1.0f) * 0.05f), 0.4, (double)((this.f_19796_.m_188501_() * 2.0f - 1.0f) * 0.05f)));
            this.m_6853_(false);
            this.f_19812_ = true;
            this.m_5496_(this.getFlopSound(), this.m_6121_(), this.m_6100_());
        }
        super.m_8107_();
        if (this.m_6084_() && this.stunnedTick > 0) {
            --this.stunnedTick;
            this.stunEffect();
            if (this.stunnedTick == 0) {
                this.m_5496_(SoundEvents.f_11773_, 1.0f, 0.7f);
            }
        }
    }

    public boolean m_6469_(DamageSource source, float amount) {
        Entity entity;
        if (super.m_6469_(source, amount) && (entity = source.m_7639_()) instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)entity;
            this.m_21561_(true);
            this.m_6710_(living);
        }
        return super.m_6469_(source, amount);
    }

    protected void m_6731_(LivingEntity p_33361_) {
        if (this.f_19796_.m_188501_() > 0.25f) {
            this.stunnedTick = 80;
            this.m_5496_(SoundEvents.f_11761_, 1.0f, 0.5f);
            this.m_9236_().m_7605_((Entity)this, (byte)39);
            p_33361_.m_7334_((Entity)this);
            this.m_21561_(false);
            this.m_6710_(null);
        }
        p_33361_.f_19864_ = true;
    }

    private void stunEffect() {
        Vec3 pos = RhinoTetra.getYawVec(this.f_20883_, 0.0, 0.0, 0.85).m_82520_(0.0, 0.85, 0.0);
        this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123797_, pos.f_82479_ + this.m_20208_(0.5), pos.f_82480_ + this.m_20182_().f_82480_, pos.f_82481_ + this.m_20262_(0.5), 0.0, 0.0, 0.0);
    }

    @Override
    public void m_8119_() {
        Level level;
        super.m_8119_();
        if (this.m_20069_() && this.m_5448_() != null && this.m_5912_() && (level = this.m_9236_()) instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            if (this.stunnedTick <= 0) {
                Vec3 pos = RhinoTetra.getYawVec(this.f_20885_, 0.0, 0.0, 0.0).m_82549_(this.m_20182_());
                this.m_20256_(this.m_20171_(this.m_146909_(), this.m_146908_()).m_82490_(0.5));
                for (int i = 0; i < 5; ++i) {
                    serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123795_, pos.m_7096_(), pos.m_7098_() + (double)((float)i * 0.1f) + 0.25, pos.m_7094_(), 0, 0.0, 0.0, 0.0, 0.0);
                }
            }
        }
    }

    private static Vec3 getYawVec(float yaw, double xOffset, double yOffset, double zOffset) {
        return new Vec3(xOffset, yOffset, zOffset).m_82524_(-yaw * ((float)Math.PI / 180));
    }

    public void m_7822_(byte p_33335_) {
        if (p_33335_ == 39) {
            this.stunnedTick = 80;
        }
        super.m_7822_(p_33335_);
    }

    protected boolean m_6107_() {
        return super.m_6107_() || this.stunnedTick > 0;
    }

    protected PathNavigation m_6037_(Level p_27480_) {
        return new WaterBoundPathNavigation((Mob)this, p_27480_);
    }

    @Override
    public int m_5792_() {
        return 5;
    }

    public boolean m_7296_(int p_30035_) {
        return !this.isSchool;
    }

    @Override
    public int getMaxSchoolSize() {
        return 7;
    }

    protected SoundEvent m_5592_() {
        return SoundEvents.f_11759_;
    }

    protected SoundEvent m_7975_(DamageSource p_28281_) {
        return SoundEvents.f_11761_;
    }

    protected SoundEvent getFlopSound() {
        return SoundEvents.f_11760_;
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(REMAINING_ANGER_TIME, (Object)0);
    }

    @Override
    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        this.stunnedTick = compound.m_128451_("StunTick");
        this.m_147285_(this.m_9236_(), compound);
    }

    @Override
    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128405_("StunTick", this.stunnedTick);
        this.m_21678_(compound);
    }

    @Override
    public void m_6872_(ItemStack bucket) {
        CompoundTag compoundnbt = bucket.m_41784_();
        compoundnbt.m_128350_("Health", this.m_21223_());
        if (this.m_8077_()) {
            bucket.m_41714_(this.m_7770_());
        }
    }

    public static boolean canSpawn(EntityType<RhinoTetra> p_223364_0_, LevelAccessor p_223364_1_, MobSpawnType reason, BlockPos p_223364_3_, RandomSource random) {
        return WaterAnimal.m_218282_(p_223364_0_, (LevelAccessor)p_223364_1_, (MobSpawnType)reason, (BlockPos)p_223364_3_, (RandomSource)random);
    }

    public int m_6784_() {
        return (Integer)this.f_19804_.m_135370_(REMAINING_ANGER_TIME);
    }

    public void m_7870_(int p_21673_) {
        this.f_19804_.m_135381_(REMAINING_ANGER_TIME, (Object)p_21673_);
    }

    @Nullable
    public UUID m_6120_() {
        return this.persistentAngerTarget;
    }

    public void m_6925_(@Nullable UUID p_27791_) {
        this.persistentAngerTarget = p_27791_;
    }

    public void m_6825_() {
        this.m_7870_(PERSISTENT_ANGER_TIME.m_214085_(this.f_19796_));
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllerRegistrar) {
        controllerRegistrar.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "controller", 2, this::predicate)});
    }

    private <E extends GeoEntity> PlayState predicate(AnimationState<E> event) {
        if (this.m_20069_()) {
            if (event.isMoving()) {
                event.setAnimation(UFAnimations.SWIM);
            } else {
                event.setAnimation(UFAnimations.IDLE);
            }
        } else {
            event.setAnimation(UFAnimations.FLOP);
        }
        return PlayState.CONTINUE;
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }
}

