/*
 * Decompiled with CFR 0.152.
 */
package com.igteam.immersivegeology.client;

import com.igteam.immersivegeology.client.models.IGDynamicModel;
import com.igteam.immersivegeology.client.renderer.multiblocks.AlternatorRenderer;
import com.igteam.immersivegeology.client.renderer.multiblocks.BallmillRenderer;
import com.igteam.immersivegeology.client.renderer.multiblocks.CentrifugeRenderer;
import com.igteam.immersivegeology.client.renderer.multiblocks.ChemicalReactorRenderer;
import com.igteam.immersivegeology.client.renderer.multiblocks.CoreDrillRenderer;
import com.igteam.immersivegeology.client.renderer.multiblocks.PelletizerRenderer;
import com.igteam.immersivegeology.client.renderer.multiblocks.RotaryKilnRenderer;
import com.igteam.immersivegeology.client.renderer.multiblocks.SeparatorRenderer;
import com.igteam.immersivegeology.client.renderer.multiblocks.SteamTurbineRenderer;
import com.igteam.immersivegeology.common.particle.IGParticles;
import com.igteam.immersivegeology.common.particle.providers.FlowingWaterParticleProvider;
import com.igteam.immersivegeology.core.registration.IGMultiblockProvider;
import java.util.function.Supplier;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.EntityRenderersEvent;
import net.minecraftforge.client.event.ModelEvent;
import net.minecraftforge.client.event.RegisterParticleProvidersEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="immersivegeology", value={Dist.CLIENT}, bus=Mod.EventBusSubscriber.Bus.MOD)
public class ClientModBusEventHandlers {
    @SubscribeEvent
    public static void registerModelLoaders(ModelEvent.RegisterGeometryLoaders event) {
        CoreDrillRenderer.DRILL_BIT = new IGDynamicModel("coredrill_bit");
        CoreDrillRenderer.DRILL_ENGINE = new IGDynamicModel("coredrill_engine");
        CoreDrillRenderer.DRILL_ENGINE_SUPPORT = new IGDynamicModel("coredrill_vagons");
        CoreDrillRenderer.DRILL_GEARSET = new IGDynamicModel("coredrill_gears");
        BallmillRenderer.DRUM = new IGDynamicModel("drum");
        BallmillRenderer.AXLE = new IGDynamicModel("axle");
        PelletizerRenderer.DISH = new IGDynamicModel("pelletizer_dish");
        RotaryKilnRenderer.TUBE = new IGDynamicModel("rotarykiln_tube");
        SteamTurbineRenderer.ROTOR = new IGDynamicModel("steam_turbine_rotor");
        AlternatorRenderer.WHEEL = new IGDynamicModel("alternator_wheel");
        CentrifugeRenderer.DRUM = new IGDynamicModel("centrifuge_spinner");
    }

    @SubscribeEvent
    public static void registerRenderers(EntityRenderersEvent.RegisterRenderers event) {
        ClientModBusEventHandlers.registerBlockEntityRenderers(event);
    }

    @SubscribeEvent
    public static void registerParticleFactories(RegisterParticleProvidersEvent event) {
        event.registerSpriteSet((ParticleType)IGParticles.FLOWING_WATER.get(), FlowingWaterParticleProvider::new);
    }

    public static void registerBlockEntityRenderers(EntityRenderersEvent.RegisterRenderers event) {
        ClientModBusEventHandlers.registerBERenderNoContext(event, IGMultiblockProvider.COREDRILL.masterBE(), CoreDrillRenderer::new);
        ClientModBusEventHandlers.registerBERenderNoContext(event, IGMultiblockProvider.BALLMILL.masterBE(), BallmillRenderer::new);
        ClientModBusEventHandlers.registerBERenderNoContext(event, IGMultiblockProvider.PELLETIZER.masterBE(), PelletizerRenderer::new);
        ClientModBusEventHandlers.registerBERenderNoContext(event, IGMultiblockProvider.ROTARYKILN.masterBE(), RotaryKilnRenderer::new);
        ClientModBusEventHandlers.registerBERenderNoContext(event, IGMultiblockProvider.GRAVITY_SEPARATOR.masterBE(), SeparatorRenderer::new);
        ClientModBusEventHandlers.registerBERenderNoContext(event, IGMultiblockProvider.CHEMICAL_REACTOR.masterBE(), ChemicalReactorRenderer::new);
        ClientModBusEventHandlers.registerBERenderNoContext(event, IGMultiblockProvider.CENTRIFUGE.masterBE(), CentrifugeRenderer::new);
        ClientModBusEventHandlers.registerBERenderNoContext(event, IGMultiblockProvider.STEAM_TURBINE.masterBE(), SteamTurbineRenderer::new);
        ClientModBusEventHandlers.registerBERenderNoContext(event, IGMultiblockProvider.ALTERNATOR.masterBE(), AlternatorRenderer::new);
    }

    private static <T extends BlockEntity> void registerBERenderNoContext(EntityRenderersEvent.RegisterRenderers event, Supplier<BlockEntityType<? extends T>> type, Supplier<BlockEntityRenderer<T>> render) {
        ClientModBusEventHandlers.registerBERenderNoContext(event, type.get(), render);
    }

    private static <T extends BlockEntity> void registerBERenderNoContext(EntityRenderersEvent.RegisterRenderers event, BlockEntityType<? extends T> type, Supplier<BlockEntityRenderer<T>> render) {
        event.registerBlockEntityRenderer(type, $ -> (BlockEntityRenderer)render.get());
    }
}

