/*
 * Decompiled with CFR 0.152.
 */
package com.igteam.immersivegeology.client.helper;

import blusunrize.immersiveengineering.api.ApiUtils;
import blusunrize.immersiveengineering.api.crafting.FluidTagInput;
import blusunrize.immersiveengineering.api.crafting.IngredientWithSize;
import com.google.common.base.Preconditions;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.crafting.conditions.ICondition;
import net.minecraftforge.fluids.FluidStack;

public class IGRecipeBuilder<R extends IGRecipeBuilder<R>>
implements FinishedRecipe {
    private final RecipeSerializer<?> serializer;
    private final List<Consumer<JsonObject>> writerFunctions;
    private ResourceLocation id;
    protected JsonArray inputArray = null;
    protected int inputCount = 0;
    protected int maxInputCount = 1;
    protected JsonArray resultArray = null;
    protected int resultCount = 0;
    protected int maxResultCount = 1;
    protected JsonArray conditions = null;

    protected IGRecipeBuilder(RecipeSerializer<?> serializer) {
        this.serializer = serializer;
        this.writerFunctions = new ArrayList<Consumer<JsonObject>>();
    }

    protected boolean isComplete() {
        return true;
    }

    public void build(Consumer<FinishedRecipe> out, ResourceLocation id) {
        Preconditions.checkArgument((boolean)this.isComplete(), (Object)"This recipe is incomplete");
        this.id = id;
        out.accept(this);
    }

    public IGRecipeBuilder<R> addWriter(Consumer<JsonObject> writer) {
        Preconditions.checkArgument((this.id == null ? 1 : 0) != 0, (Object)"This recipe has already been finalized");
        this.writerFunctions.add(writer);
        return this;
    }

    public IGRecipeBuilder<R> addCondition(ICondition condition) {
        if (this.conditions == null) {
            this.conditions = new JsonArray();
            this.addWriter(jsonObject -> jsonObject.add("conditions", (JsonElement)this.conditions));
        }
        this.conditions.add((JsonElement)CraftingHelper.serialize((ICondition)condition));
        return this;
    }

    public IGRecipeBuilder<R> setTime(int time) {
        return this.addWriter(jsonObject -> jsonObject.addProperty("time", (Number)time));
    }

    public IGRecipeBuilder<R> setEnergy(int energy) {
        return this.addWriter(jsonObject -> jsonObject.addProperty("energy", (Number)energy));
    }

    public IGRecipeBuilder<R> setMultipleResults(int maxResultCount) {
        this.resultArray = new JsonArray();
        this.maxResultCount = maxResultCount;
        return this.addWriter(jsonObject -> jsonObject.add("results", (JsonElement)this.resultArray));
    }

    public IGRecipeBuilder<R> addMultiResult(JsonElement obj) {
        Preconditions.checkArgument((this.maxResultCount > 1 ? 1 : 0) != 0, (Object)"This recipe does not support multiple results");
        Preconditions.checkArgument((this.resultCount < this.maxResultCount ? 1 : 0) != 0, (Object)("Recipe can only have " + this.maxResultCount + " results"));
        this.resultArray.add(obj);
        ++this.resultCount;
        return this;
    }

    public IGRecipeBuilder<R> addResult(ItemLike itemProvider) {
        return this.addResult(new ItemStack(itemProvider));
    }

    public IGRecipeBuilder<R> addResult(ItemStack itemStack) {
        return this.resultArray != null ? this.addMultiResult((JsonElement)this.serializeItemStack(itemStack)) : this.addItem("result", itemStack);
    }

    public IGRecipeBuilder<R> addResult(Ingredient ingredient) {
        return this.resultArray != null ? this.addMultiResult(ingredient.m_43942_()) : this.addWriter(jsonObject -> jsonObject.add("result", ingredient.m_43942_()));
    }

    public IGRecipeBuilder<R> addResult(IngredientWithSize ingredientWithSize) {
        return this.resultArray != null ? this.addMultiResult(ingredientWithSize.serialize()) : this.addWriter(jsonObject -> jsonObject.add("result", ingredientWithSize.serialize()));
    }

    public IGRecipeBuilder<R> setUseInputArray(int maxInputCount, String key) {
        this.inputArray = new JsonArray();
        this.maxInputCount = maxInputCount;
        return this.addWriter(jsonObject -> jsonObject.add(key, (JsonElement)this.inputArray));
    }

    public IGRecipeBuilder<R> setUseInputArray(int maxInputCount) {
        return this.setUseInputArray(maxInputCount, "inputs");
    }

    public IGRecipeBuilder<R> addMultiInput(JsonElement obj) {
        Preconditions.checkArgument((this.maxInputCount > 1 ? 1 : 0) != 0, (Object)"This recipe does not support multiple inputs");
        Preconditions.checkArgument((this.inputCount < this.maxInputCount ? 1 : 0) != 0, (Object)("Recipe can only have " + this.maxInputCount + " inputs"));
        this.inputArray.add(obj);
        ++this.inputCount;
        return this;
    }

    public IGRecipeBuilder<R> addMultiInput(Ingredient ingredient) {
        return this.addMultiInput(ingredient.m_43942_());
    }

    public IGRecipeBuilder<R> addMultiInput(IngredientWithSize ingredient) {
        return this.addMultiInput(ingredient.serialize());
    }

    protected String generateSafeInputKey() {
        Preconditions.checkArgument((this.inputCount < this.maxInputCount ? 1 : 0) != 0, (Object)("Recipe can only have " + this.maxInputCount + " inputs"));
        String key = this.maxInputCount == 1 ? "input" : "input" + this.inputCount;
        ++this.inputCount;
        return key;
    }

    public IGRecipeBuilder<R> addInput(ItemLike ... itemProviders) {
        return this.inputArray != null ? this.addMultiInput(Ingredient.m_43929_((ItemLike[])itemProviders)) : this.addIngredient(this.generateSafeInputKey(), itemProviders);
    }

    public IGRecipeBuilder<R> addInput(ItemStack ... itemStacks) {
        return this.inputArray != null ? this.addMultiInput(Ingredient.m_43927_((ItemStack[])itemStacks)) : this.addIngredient(this.generateSafeInputKey(), itemStacks);
    }

    public IGRecipeBuilder<R> addInput(TagKey<Item> tag) {
        return this.inputArray != null ? this.addMultiInput(Ingredient.m_204132_(tag)) : this.addIngredient(this.generateSafeInputKey(), tag);
    }

    public IGRecipeBuilder<R> addInput(Ingredient input) {
        return this.inputArray != null ? this.addMultiInput(input) : this.addIngredient(this.generateSafeInputKey(), input);
    }

    public IGRecipeBuilder<R> addInput(IngredientWithSize input) {
        return this.inputArray != null ? this.addMultiInput(input) : this.addIngredient(this.generateSafeInputKey(), input);
    }

    public JsonObject serializeItemStack(ItemStack stack) {
        JsonObject obj = new JsonObject();
        obj.addProperty("item", BuiltInRegistries.f_257033_.m_7981_((Object)stack.m_41720_()).toString());
        if (stack.m_41613_() > 1) {
            obj.addProperty("count", (Number)stack.m_41613_());
        }
        if (stack.m_41782_()) {
            obj.addProperty("nbt", stack.m_41783_().toString());
        }
        return obj;
    }

    protected IGRecipeBuilder<R> addSimpleItem(String key, ItemLike item) {
        return this.addWriter(json -> json.addProperty(key, BuiltInRegistries.f_257033_.m_7981_((Object)item.m_5456_()).toString()));
    }

    public IGRecipeBuilder<R> addItem(String key, ItemLike item) {
        return this.addItem(key, new ItemStack(item));
    }

    public IGRecipeBuilder<R> addItem(String key, ItemStack stack) {
        Preconditions.checkArgument((!stack.m_41619_() ? 1 : 0) != 0, (Object)"May not add empty ItemStack to recipe");
        return this.addWriter(jsonObject -> jsonObject.add(key, (JsonElement)this.serializeItemStack(stack)));
    }

    public IGRecipeBuilder<R> addIngredient(String key, ItemLike ... itemProviders) {
        return this.addIngredient(key, Ingredient.m_43929_((ItemLike[])itemProviders));
    }

    public IGRecipeBuilder<R> addIngredient(String key, ItemStack ... itemStacks) {
        return this.addIngredient(key, Ingredient.m_43927_((ItemStack[])itemStacks));
    }

    public IGRecipeBuilder<R> addIngredient(String key, TagKey<Item> tag) {
        return this.addIngredient(key, Ingredient.m_204132_(tag));
    }

    public IGRecipeBuilder<R> addIngredient(String key, Ingredient ingredient) {
        return this.addWriter(jsonObject -> jsonObject.add(key, ingredient.m_43942_()));
    }

    public IGRecipeBuilder<R> addIngredient(String key, IngredientWithSize ingredient) {
        return this.addWriter(jsonObject -> jsonObject.add(key, ingredient.serialize()));
    }

    public IGRecipeBuilder<R> addFluid(String key, FluidStack fluidStack) {
        return this.addWriter(jsonObject -> jsonObject.add(key, ApiUtils.jsonSerializeFluidStack((FluidStack)fluidStack)));
    }

    public IGRecipeBuilder<R> addFluid(FluidStack fluidStack) {
        return this.addFluid("fluid", fluidStack);
    }

    public IGRecipeBuilder<R> addFluid(Fluid fluid, int amount) {
        return this.addFluid("fluid", new FluidStack(fluid, amount));
    }

    public IGRecipeBuilder<R> addFluidTag(String key, FluidTagInput fluidTag) {
        return this.addWriter(jsonObject -> jsonObject.add(key, fluidTag.serialize()));
    }

    public IGRecipeBuilder<R> addFluidTag(String key, TagKey<Fluid> fluidTag, int amount) {
        return this.addFluidTag(key, new FluidTagInput(fluidTag, amount, (CompoundTag)null));
    }

    public IGRecipeBuilder<R> addFluidTag(TagKey<Fluid> fluidTag, int amount) {
        return this.addFluidTag("fluid", new FluidTagInput(fluidTag, amount, (CompoundTag)null));
    }

    public void m_7917_(JsonObject jsonObject) {
        for (Consumer<JsonObject> writer : this.writerFunctions) {
            writer.accept(jsonObject);
        }
    }

    public ResourceLocation m_6445_() {
        return this.id;
    }

    public RecipeSerializer<?> m_6637_() {
        return this.serializer;
    }

    @Nullable
    public JsonObject m_5860_() {
        return null;
    }

    @Nullable
    public ResourceLocation m_6448_() {
        return null;
    }

    protected static JsonObject serializeStackWithChance(IngredientWithSize ingredient, float chance, ICondition ... conditions) {
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty("chance", (Number)Float.valueOf(chance));
        jsonObject.add("output", ingredient.serialize());
        if (conditions.length > 0) {
            JsonArray conditionArray = new JsonArray();
            ICondition[] var5 = conditions;
            int var6 = conditions.length;
            for (int var7 = 0; var7 < var6; ++var7) {
                ICondition condition = var5[var7];
                conditionArray.add((JsonElement)CraftingHelper.serialize((ICondition)condition));
            }
            jsonObject.add("conditions", (JsonElement)conditionArray);
        }
        return jsonObject;
    }
}

