/*
 * Decompiled with CFR 0.152.
 */
package com.igteam.immersivegeology.client.menu;

import com.igteam.immersivegeology.core.material.data.enums.MetalEnum;
import com.igteam.immersivegeology.core.material.data.enums.MineralEnum;
import com.igteam.immersivegeology.core.material.helper.flags.IFlagType;
import com.igteam.immersivegeology.core.material.helper.flags.ItemCategoryFlags;
import com.igteam.immersivegeology.core.material.helper.material.MaterialInterface;
import org.checkerframework.checker.nullness.qual.NonNull;

public enum ItemSubGroup {
    geologic(ItemCategoryFlags.NORMAL_ORE, MetalEnum.Gold),
    components(ItemCategoryFlags.PLATE, MetalEnum.Zirconium),
    pyrometallurgy(ItemCategoryFlags.PELLET, MineralEnum.Cuprite),
    hydrometallurgy(ItemCategoryFlags.CRYSTAL, MineralEnum.Saltpeter),
    structural(ItemCategoryFlags.HAMMER, MetalEnum.StainlessSteel);

    private final IFlagType<?> flag;
    private final MaterialInterface<?> material;
    private final MaterialInterface<?> secondary;

    private ItemSubGroup(IFlagType<?> flag, MaterialInterface<?> material) {
        this.flag = flag;
        this.material = material;
        this.secondary = material;
    }

    private ItemSubGroup(IFlagType<?> flag, MaterialInterface<?> material, MaterialInterface<?> secondary) {
        this.flag = flag;
        this.material = material;
        this.secondary = secondary;
    }

    @NonNull IFlagType<?> getFlag() {
        return this.flag;
    }

    MaterialInterface<?> getMaterial() {
        return this.material;
    }

    MaterialInterface<?> getSecondary() {
        return this.secondary;
    }
}

