/*
 * Decompiled with CFR 0.152.
 */
package com.igteam.immersivegeology.client.menu.multiblock;

import blusunrize.immersiveengineering.api.multiblocks.ClientMultiblocks;
import blusunrize.immersiveengineering.api.multiblocks.MultiblockHandler;
import blusunrize.immersiveengineering.client.gui.IEContainerScreen;
import blusunrize.immersiveengineering.client.gui.info.EnergyInfoArea;
import blusunrize.immersiveengineering.client.gui.info.FluidInfoArea;
import blusunrize.immersiveengineering.client.gui.info.InfoArea;
import blusunrize.immersiveengineering.client.utils.IERenderTypes;
import blusunrize.immersiveengineering.client.utils.TransformingVertexBuilder;
import blusunrize.immersiveengineering.common.util.fakeworld.TemplateWorld;
import com.google.common.collect.ImmutableList;
import com.igteam.immersivegeology.client.IGShaders;
import com.igteam.immersivegeology.client.helper.FluidCuboid;
import com.igteam.immersivegeology.client.helper.IGFluidRenderHelper;
import com.igteam.immersivegeology.client.renderer.IGRenderTypes;
import com.igteam.immersivegeology.common.block.multiblocks.IGGeothermalExchangerMultiblock;
import com.igteam.immersivegeology.common.block.multiblocks.gui.GeothermalExchangerMenu;
import com.igteam.immersivegeology.common.block.multiblocks.recipe.GeothermalConversionRecipe;
import com.igteam.immersivegeology.core.lib.IGLib;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Transformation;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.client.extensions.common.IClientFluidTypeExtensions;
import net.minecraftforge.client.model.data.ModelData;
import org.jetbrains.annotations.NotNull;
import org.joml.Quaternionf;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class GeothermalExchangerScreen
extends IEContainerScreen<GeothermalExchangerMenu> {
    private static final ResourceLocation TEXTURE = IGLib.makeTextureLocation("multiblocks/geothermal_exchanger");
    public static double lastPrintedErrorTimeMs;
    private final TemplateWorld structureWorld;
    private final MultiblockRenderInfo renderInfo;
    FluidCuboid fluidCube = FluidCuboid.builder().face(true, 0, Direction.SOUTH, Direction.WEST).face(false, 0, Direction.UP, new Direction[0]).build();

    public GeothermalExchangerScreen(GeothermalExchangerMenu menu, Inventory inv, Component title) {
        super((AbstractContainerMenu)menu, inv, title, TEXTURE);
        this.f_97726_ = 234;
        this.f_97727_ = 185;
        Level level = inv.f_35978_.m_9236_();
        List structure = IGGeothermalExchangerMultiblock.INSTANCE.getStructure(level);
        this.renderInfo = new MultiblockRenderInfo(structure);
        this.structureWorld = new TemplateWorld(structure, (Predicate)this.renderInfo, level.m_9598_());
    }

    protected void m_7856_() {
        super.m_7856_();
        this.f_97731_ = this.f_97727_ - 94;
        this.f_97730_ = 38;
    }

    protected void drawBackgroundTexture(GuiGraphics graphics) {
        PoseStack pose = graphics.m_280168_();
        graphics.m_280218_(TEXTURE, this.f_97735_ + 198, this.f_97736_ + 29, 33, 187, 31, 62);
        graphics.m_280218_(TEXTURE, this.f_97735_ + 5, this.f_97736_ + 29, 1, 187, 31, 62);
        pose.m_85836_();
        pose.m_252880_((float)(this.f_97735_ + 193), (float)(this.f_97736_ + 56), 0.0f);
        pose.m_85836_();
        pose.m_85837_(4.5, 3.5, 0.0);
        pose.m_252781_(new Quaternionf().rotateAxis(0.0f, (Vector3fc)new Vector3f(0.0f, 0.0f, 1.0f)));
        pose.m_252781_(new Quaternionf().rotateAxis(-(160.0f * ((Float)((GeothermalExchangerMenu)this.f_97732_).display_heat.get()).floatValue()) * ((float)Math.PI / 180), (Vector3fc)new Vector3f(0.0f, 0.0f, 1.0f)));
        pose.m_85837_(-4.5, -3.5, 0.0);
        graphics.m_280218_(TEXTURE, 0, 0, 65, 187, 32, 7);
        pose.m_85849_();
        pose.m_85849_();
        pose.m_85836_();
        pose.m_252880_((float)(this.f_97735_ + 29), (float)(this.f_97736_ + 56), 0.0f);
        pose.m_85836_();
        pose.m_85837_(4.5, 3.5, 0.0);
        pose.m_252781_(new Quaternionf().rotateAxis(1.6057029f, (Vector3fc)new Vector3f(0.0f, 0.0f, 1.0f)));
        pose.m_252781_(new Quaternionf().rotateAxis(170.0f * ((Float)((GeothermalExchangerMenu)this.f_97732_).cooling_rate.get()).floatValue() * ((float)Math.PI / 180), (Vector3fc)new Vector3f(0.0f, 0.0f, 1.0f)));
        pose.m_85837_(-4.5, -3.5, 0.0);
        graphics.m_280218_(TEXTURE, 0, 0, 65, 187, 32, 7);
        pose.m_85849_();
        pose.m_85849_();
        graphics.m_280218_(TEXTURE, this.f_97735_, this.f_97736_, 0, 0, this.f_97726_, this.f_97727_);
    }

    protected void m_280003_(GuiGraphics graphics, int mouseX, int mouseY) {
        super.m_280003_(graphics, mouseX, mouseY);
    }

    public void m_88315_(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        super.m_88315_(graphics, mouseX, mouseY, partialTicks);
        MultiBufferSource.BufferSource bufferSource = graphics.m_280091_();
        PoseStack pose = graphics.m_280168_();
        this.renderMultiblock(pose, graphics, (MultiBufferSource)bufferSource);
    }

    public void m_280273_(@NotNull GuiGraphics graphics) {
        super.m_280273_(graphics);
    }

    private Transformation createRenderTransform() {
        return new Transformation(null, new Quaternionf().rotateXYZ((float)Math.toRadians(25.0), 0.0f, 0.0f), null, new Quaternionf().rotateXYZ(0.0f, (float)Math.toRadians(-45.0), 0.0f));
    }

    private void renderMultiblock(PoseStack pose, GuiGraphics graphics, MultiBufferSource bufferSource) {
        ClientLevel level = Minecraft.m_91087_().f_91073_;
        if (level == null) {
            return;
        }
        IGGeothermalExchangerMultiblock multiblock = IGGeothermalExchangerMultiblock.INSTANCE;
        ClientMultiblocks.MultiblockManualData renderProperties = ClientMultiblocks.get((MultiblockHandler.IMultiblock)multiblock);
        List structure = multiblock.getStructure((Level)level);
        BlockRenderDispatcher blockRender = Minecraft.m_91087_().m_91289_();
        ItemRenderer itemRender = Minecraft.m_91087_().m_91291_();
        ItemStack multiblockRenderIcon = new ItemStack((ItemLike)multiblock.getBlock());
        int[] structureDimensions = this.calculateStructureDimensions(structure);
        int structureHeight = structureDimensions[0];
        int structureWidth = structureDimensions[1];
        int structureLength = structureDimensions[2];
        float scale = multiblock.getManualScale() * 0.65f;
        float renderPosX = this.f_97735_ + 116;
        float renderPosY = (float)this.f_97736_ + 46.0f;
        float maxDimension = Math.max(structureHeight, Math.max(structureWidth, structureLength));
        PoseStack.Pose lastEntryBeforeTry = pose.m_85850_();
        try {
            pose.m_85836_();
            pose.m_252880_(renderPosX, renderPosY, maxDimension);
            pose.m_85841_(scale, -scale, 1.0f);
            Transformation additionalTransform = this.createRenderTransform();
            pose.pushTransformation(additionalTransform);
            pose.m_252781_(new Quaternionf().rotateXYZ(0.0f, 1.5707964f, 0.0f));
            pose.m_252880_((float)structureLength / -2.0f, (float)structureHeight / -2.0f, (float)structureWidth / -2.0f);
            pose.m_85836_();
            pose.m_252880_(0.0f, 4.0f, 0.0f);
            BakedModel itemModel = itemRender.m_174264_(multiblockRenderIcon, (Level)level, null, 0);
            pose.m_85837_(1.5, -0.5, 1.5);
            itemRender.m_115189_(itemModel, multiblockRenderIcon, -1, OverlayTexture.f_118083_, pose, bufferSource.m_6299_(IERenderTypes.TRANSLUCENT_FULLBRIGHT));
            pose.m_85849_();
            IGShaders.setGeothermalRenderData(0.8f);
            int blockIndex = 0;
            TransformingVertexBuilder translucentFullbright = new TransformingVertexBuilder(bufferSource, IGRenderTypes.GEOTHERMAL_DISPLAY);
            for (int h = -1; h < structureHeight; ++h) {
                for (int l = 0; l < structureLength; ++l) {
                    for (int w = 0; w < structureWidth; ++w) {
                        BlockPos pos = new BlockPos(l, h, w);
                        BlockState state = this.structureWorld.m_8055_(pos);
                        int overlay = OverlayTexture.f_118083_;
                        if (!state.m_60795_() || blockIndex > 53) continue;
                        int heatState = this.unpackHeatStateAtIndex(blockIndex);
                        Block heatBlock = GeothermalConversionRecipe.getBlockFromIndex((Level)level, heatState);
                        pose.m_85836_();
                        pose.m_252880_((float)l, (float)h, (float)w);
                        ModelData modelData = ModelData.EMPTY;
                        BlockState extraState = heatBlock.m_49966_();
                        BakedModel model = blockRender.m_110910_(extraState);
                        modelData = model.getModelData((BlockAndTintGetter)this.structureWorld, pos, extraState, modelData);
                        pose.m_85836_();
                        pose.m_85837_(-0.5, 0.5, 0.5);
                        if (extraState.m_60819_().m_192917_(Fluids.f_76191_)) {
                            blockRender.m_110937_().tesselateBlock((BlockAndTintGetter)this.structureWorld, model, extraState, pos, pose, (VertexConsumer)translucentFullbright, false, this.structureWorld.f_46441_, state.m_60726_(pos), overlay, modelData, (RenderType)null);
                        }
                        if (!extraState.m_60819_().m_192917_(Fluids.f_76191_)) {
                            Fluid fluid = heatBlock.m_49966_().m_60819_().m_76152_();
                            IClientFluidTypeExtensions fluidAttributes = IClientFluidTypeExtensions.of((Fluid)fluid);
                            TextureAtlasSprite flowing = (TextureAtlasSprite)Minecraft.m_91087_().m_91258_(InventoryMenu.f_39692_).apply(fluidAttributes.getFlowingTexture());
                            TextureAtlasSprite still = (TextureAtlasSprite)Minecraft.m_91087_().m_91258_(InventoryMenu.f_39692_).apply(fluidAttributes.getStillTexture());
                            IGFluidRenderHelper.renderCuboid(pose, (VertexConsumer)translucentFullbright, this.fluidCube, still, flowing, new Vector3f(0.0f, 0.0f, 0.0f), new Vector3f(1.0f, 1.0f, 1.0f), -1, -1);
                        }
                        pose.m_85849_();
                        pose.m_85849_();
                        ++blockIndex;
                    }
                }
            }
            pose.m_85849_();
        }
        catch (Exception e) {
            long now = System.currentTimeMillis();
            if ((double)now > lastPrintedErrorTimeMs + 1000.0) {
                e.printStackTrace();
                lastPrintedErrorTimeMs = now;
            }
            while (lastEntryBeforeTry != pose.m_85850_()) {
                pose.m_85849_();
            }
        }
    }

    public int unpackHeatStateAtIndex(int index) {
        return ((byte[])((GeothermalExchangerMenu)this.f_97732_).BLOCK_MAP_DATA.get())[index];
    }

    private int[] calculateStructureDimensions(List<StructureTemplate.StructureBlockInfo> structure) {
        int structureHeight = 0;
        int structureWidth = 0;
        int structureLength = 0;
        for (StructureTemplate.StructureBlockInfo block : structure) {
            structureHeight = Math.max(structureHeight, block.f_74675_().m_123342_() + 1);
            structureWidth = Math.max(structureWidth, block.f_74675_().m_123343_() + 1);
            structureLength = Math.max(structureLength, block.f_74675_().m_123341_() + 1);
        }
        return new int[]{structureHeight, structureWidth, structureLength};
    }

    protected void drawContainerBackgroundPre(@Nonnull GuiGraphics graphics, float f, int mx, int my) {
    }

    @NotNull
    protected List<InfoArea> makeInfoAreas() {
        return ImmutableList.of((Object)new FluidInfoArea(((GeothermalExchangerMenu)this.f_97732_).tanks[0], new Rect2i(this.f_97735_ + 157, this.f_97736_ + 23, 16, 47), 101, 187, 20, 51, TEXTURE), (Object)new FluidInfoArea(((GeothermalExchangerMenu)this.f_97732_).tanks[1], new Rect2i(this.f_97735_ + 61, this.f_97736_ + 23, 16, 47), 101, 187, 20, 51, TEXTURE), (Object)new EnergyInfoArea(this.f_97735_ + 206, this.f_97736_ + 98, ((GeothermalExchangerMenu)this.f_97732_).energy_storage));
    }

    static class MultiblockRenderInfo
    implements Predicate<BlockPos> {
        public Map<BlockPos, StructureTemplate.StructureBlockInfo> data = new HashMap<BlockPos, StructureTemplate.StructureBlockInfo>();
        private final int structureHeight;
        private final int structureLength;
        private final int structureWidth;
        private final int maxBlockIndex;
        private int showLayer = -1;
        private int blockIndex;

        MultiblockRenderInfo(List<StructureTemplate.StructureBlockInfo> structure) {
            int structureHeight = 0;
            int structureWidth = 0;
            int structureLength = 0;
            for (StructureTemplate.StructureBlockInfo block : structure) {
                structureHeight = Math.max(structureHeight, block.f_74675_().m_123342_() + 1);
                structureWidth = Math.max(structureWidth, block.f_74675_().m_123343_() + 1);
                structureLength = Math.max(structureLength, block.f_74675_().m_123341_() + 1);
                this.data.put(block.f_74675_(), block);
            }
            this.maxBlockIndex = this.blockIndex = structureHeight * structureLength * structureWidth;
            this.structureHeight = structureHeight;
            this.structureLength = structureLength;
            this.structureWidth = structureWidth;
        }

        void setShowLayer(int layer) {
            this.showLayer = layer;
            if (layer < 0) {
                this.reset();
            } else {
                this.blockIndex = (layer + 1) * this.structureLength * this.structureWidth - 1;
            }
        }

        public void reset() {
            this.blockIndex = this.maxBlockIndex;
        }

        void step() {
            int start = this.blockIndex;
            do {
                if (++this.blockIndex < this.maxBlockIndex) continue;
                this.blockIndex = 0;
            } while (this.isEmpty(this.blockIndex) && this.blockIndex != start);
        }

        private boolean isEmpty(int index) {
            int r = index % (this.structureLength * this.structureWidth);
            int x = r / this.structureWidth;
            int y = index / (this.structureLength * this.structureWidth);
            int z = r % this.structureWidth;
            return !this.data.containsKey(new BlockPos(x, y, z));
        }

        int getLimiter() {
            return this.blockIndex;
        }

        @Override
        public boolean test(BlockPos blockPos) {
            int index = blockPos.m_123343_() + this.structureWidth * (blockPos.m_123341_() + this.structureLength * blockPos.m_123342_());
            return index <= this.getLimiter();
        }
    }
}

