/*
 * Decompiled with CFR 0.152.
 */
package com.igteam.immersivegeology.client.renderer;

import blusunrize.immersiveengineering.api.ApiUtils;
import blusunrize.immersiveengineering.api.utils.DirectionUtils;
import blusunrize.immersiveengineering.client.utils.RenderUtils;
import com.igteam.immersivegeology.client.helper.LinkedMultiSkin;
import com.igteam.immersivegeology.client.models.IGDynamicModel;
import com.igteam.immersivegeology.common.block.multiblocks.IGAlternatorMultiblock;
import com.igteam.immersivegeology.common.block.multiblocks.IGTemplateMultiblock;
import com.igteam.immersivegeology.common.block.multiblocks.part.SkinableMultiblockPart;
import com.igteam.immersivegeology.common.block.multiblocks.skins.helpers.IIGMultiSkinHelper;
import com.igteam.immersivegeology.common.config.IGClientConfig;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.client.model.data.ModelData;
import org.joml.Quaternionf;

public abstract class IGBlockEntityRenderer<T extends BlockEntity>
implements BlockEntityRenderer<T> {
    private static final Map<Direction, Quaternionf> ROTATE_FOR_FACING = (Map)Util.m_137469_(new EnumMap(Direction.class), m -> {
        for (Direction facing : DirectionUtils.BY_HORIZONTAL_INDEX) {
            m.put(facing, new Quaternionf().rotateY((float)Math.PI / 180 * (180.0f - facing.m_122435_())));
        }
    });
    private final Map<String, List<BakedQuad>> quadCache = new HashMap<String, List<BakedQuad>>();

    protected static void rotateForFacingNoCentering(PoseStack stack, Direction facing) {
        stack.m_252781_(ROTATE_FOR_FACING.get(facing));
    }

    public int m_142163_() {
        double distanceMod = (Double)IGClientConfig.multiblockSpecialRenderDistanceModifier.get();
        return (int)((double)super.m_142163_() * distanceMod);
    }

    protected static void rotateForFacing(PoseStack stack, Direction facing) {
        stack.m_85837_(0.5, 0.5, 0.5);
        IGBlockEntityRenderer.rotateForFacingNoCentering(stack, facing);
        stack.m_85837_(-0.5, -0.5, -0.5);
    }

    private static <T extends Enum<T>> EnumProperty<T> castEnumProperty(Property<?> property) {
        return (EnumProperty)property;
    }

    public void renderDynamicModel(IGDynamicModel model, PoseStack matrix, MultiBufferSource buffer, Direction facing, Level level, BlockPos pos, int light, int overlay, IIGMultiSkinHelper skin) {
        matrix.m_85836_();
        String skinKey = skin.m_7912_();
        List outQuads = this.quadCache.computeIfAbsent(skinKey, key -> {
            BlockRenderDispatcher brd = Minecraft.m_91087_().m_91289_();
            BlockState state = null;
            try {
                IGTemplateMultiblock multiblock;
                Block multipartBlock;
                Class<? extends IGTemplateMultiblock> multiblockClass;
                Field instanceField;
                Object instance;
                Class<?> rendererClass = this.getClass();
                LinkedMultiSkin annotation = rendererClass.getAnnotation(LinkedMultiSkin.class);
                if (annotation != null && (instance = (instanceField = (multiblockClass = annotation.multiblock()).getField("INSTANCE")).get(null)) instanceof IGTemplateMultiblock && (multipartBlock = (multiblock = (IGTemplateMultiblock)instance).getBlock()) instanceof SkinableMultiblockPart) {
                    SkinableMultiblockPart part = (SkinableMultiblockPart)multipartBlock;
                    int ord = skin.instance().ordinal();
                    state = (BlockState)multiblock.getBlock().m_49966_().m_61124_(IGBlockEntityRenderer.castEnumProperty(part.getSkinProperty()), (Comparable)((Object)((Enum)IGBlockEntityRenderer.castEnumProperty(part.getSkinProperty()).m_6908_().stream().toList().get(ord))));
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (state == null) {
                state = IGAlternatorMultiblock.INSTANCE.getBlock().m_49966_();
            }
            BakedModel baseModel = brd.m_110910_(state);
            TextureAtlasSprite newSprite = baseModel.getParticleIcon(ModelData.EMPTY);
            List baseQuads = model.get().getQuads(null, null, ApiUtils.RANDOM_SOURCE, ModelData.EMPTY, null);
            ArrayList<BakedQuad> remapped = new ArrayList<BakedQuad>(baseQuads.size());
            for (BakedQuad q : baseQuads) {
                TextureAtlasSprite oldSprite = q.m_173410_();
                remapped.add(IGBlockEntityRenderer.remapQuad(q, oldSprite, newSprite));
            }
            return remapped;
        });
        IGBlockEntityRenderer.rotateForFacing(matrix, facing);
        RenderUtils.renderModelTESRFancy((List)outQuads, (VertexConsumer)buffer.m_6299_(RenderType.m_110463_()), (PoseStack)matrix, (Level)level, (BlockPos)pos, (boolean)false, (int)0xFFFFFF, (int)light);
        matrix.m_85849_();
    }

    private static BakedQuad remapQuad(BakedQuad quad, TextureAtlasSprite oldSprite, TextureAtlasSprite newSprite) {
        int[] vertices = Arrays.copyOf(quad.m_111303_(), quad.m_111303_().length);
        float oldU0 = oldSprite.m_118409_();
        float oldU1 = oldSprite.m_118410_();
        float oldV0 = oldSprite.m_118411_();
        float oldV1 = oldSprite.m_118412_();
        float newU0 = newSprite.m_118409_();
        float newU1 = newSprite.m_118410_();
        float newV0 = newSprite.m_118411_();
        float newV1 = newSprite.m_118412_();
        for (int i = 0; i < vertices.length; i += 8) {
            float u = Float.intBitsToFloat(vertices[i + 4]);
            float v = Float.intBitsToFloat(vertices[i + 5]);
            float normU = (u - oldU0) / (oldU1 - oldU0);
            float normV = (v - oldV0) / (oldV1 - oldV0);
            float mappedU = newU0 + normU * (newU1 - newU0);
            float mappedV = newV0 + normV * (newV1 - newV0);
            vertices[i + 4] = Float.floatToRawIntBits(mappedU);
            vertices[i + 5] = Float.floatToRawIntBits(mappedV);
        }
        return new BakedQuad(vertices, quad.m_111305_(), quad.m_111306_(), newSprite, quad.m_111307_(), quad.hasAmbientOcclusion());
    }
}

