/*
 * Decompiled with CFR 0.152.
 */
package com.igteam.immersivegeology.client.renderer.multiblocks;

import blusunrize.immersiveengineering.api.ApiUtils;
import blusunrize.immersiveengineering.api.multiblocks.blocks.env.IMultiblockBEHelperMaster;
import blusunrize.immersiveengineering.api.multiblocks.blocks.env.IMultiblockContext;
import blusunrize.immersiveengineering.api.multiblocks.blocks.registry.MultiblockBlockEntityMaster;
import blusunrize.immersiveengineering.api.multiblocks.blocks.util.MultiblockOrientation;
import blusunrize.immersiveengineering.client.utils.RenderUtils;
import com.igteam.immersivegeology.client.models.IGDynamicModel;
import com.igteam.immersivegeology.client.renderer.IGBlockEntityRenderer;
import com.igteam.immersivegeology.common.block.multiblocks.logic.CentrifugeLogic;
import com.igteam.immersivegeology.common.config.IGClientConfig;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.List;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.Level;
import net.minecraftforge.client.model.data.ModelData;
import org.jetbrains.annotations.NotNull;
import org.joml.Quaternionf;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class CentrifugeRenderer
extends IGBlockEntityRenderer<MultiblockBlockEntityMaster<CentrifugeLogic.State>> {
    public static final String DRUM_NAME = "centrifuge_spinner";
    public static IGDynamicModel DRUM;

    public void render(MultiblockBlockEntityMaster<CentrifugeLogic.State> tile, float pPartialTick, PoseStack poseStack, @NotNull MultiBufferSource buffer, int pPackedLight, int pPackedOverlay) {
        boolean doRendering = (Boolean)IGClientConfig.doSpecialRenderCentrifuge.get();
        if (!doRendering) {
            return;
        }
        IMultiblockBEHelperMaster helper = tile.getHelper();
        IMultiblockContext context = helper.getContext();
        MultiblockOrientation orientation = context.getLevel().getOrientation();
        CentrifugeLogic.State state = (CentrifugeLogic.State)context.getState();
        float rot = state.getRotation();
        BlockPos pos = tile.m_58899_();
        Level level = tile.m_58904_();
        Direction dir = orientation.front();
        boolean isActive = state.shouldRenderActive();
        poseStack.m_85836_();
        CentrifugeRenderer.rotateForFacing(poseStack, dir);
        if (orientation.mirrored()) {
            poseStack.m_252880_(-2.0f, 0.0f, 0.0f);
        }
        poseStack.m_85836_();
        poseStack.m_85837_(1.5, -0.4, 1.5);
        float angleDrum = isActive ? rot + pPartialTick : rot;
        poseStack.m_85836_();
        poseStack.m_252781_(new Quaternionf().rotateAxis(angleDrum * ((float)Math.PI / 180), (Vector3fc)new Vector3f(0.0f, 1.0f, 0.0f)));
        this.renderDynamicModel(DRUM, poseStack, buffer, dir, level, pos, pPackedLight, pPackedOverlay);
        poseStack.m_85849_();
        poseStack.m_85849_();
        poseStack.m_85849_();
    }

    private void renderDynamicModel(IGDynamicModel model, PoseStack matrix, MultiBufferSource buffer, Direction facing, Level level, BlockPos pos, int light, int overlay) {
        matrix.m_85836_();
        List quads = model.get().getQuads(null, null, ApiUtils.RANDOM_SOURCE, ModelData.EMPTY, null);
        RenderUtils.renderModelTESRFancy((List)quads, (VertexConsumer)buffer.m_6299_(RenderType.m_110463_()), (PoseStack)matrix, (Level)level, (BlockPos)pos, (boolean)false, (int)0xFFFFFF, (int)light);
        matrix.m_85849_();
    }
}

