/*
 * Decompiled with CFR 0.152.
 */
package com.igteam.immersivegeology.client.renderer.multiblocks;

import blusunrize.immersiveengineering.api.multiblocks.blocks.env.IMultiblockBEHelperMaster;
import blusunrize.immersiveengineering.api.multiblocks.blocks.registry.MultiblockBlockEntityMaster;
import blusunrize.immersiveengineering.api.multiblocks.blocks.util.MultiblockOrientation;
import com.igteam.immersivegeology.client.renderer.IGBlockEntityRenderer;
import com.igteam.immersivegeology.common.block.multiblocks.logic.ChemicalReactorLogic;
import com.igteam.immersivegeology.common.config.IGClientConfig;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.BlockPos;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.client.extensions.common.IClientFluidTypeExtensions;
import net.minecraftforge.fluids.FluidStack;
import org.joml.Matrix3f;
import org.joml.Matrix4f;

public class ChemicalReactorRenderer
extends IGBlockEntityRenderer<MultiblockBlockEntityMaster<ChemicalReactorLogic.State>> {
    public void render(MultiblockBlockEntityMaster<ChemicalReactorLogic.State> master, float v, PoseStack poseStack, MultiBufferSource multiBufferSource, int i, int i1) {
        float fillPercent;
        BlockPos tankPos;
        boolean doRendering = (Boolean)IGClientConfig.doSpecialRenderChemicalReactor.get();
        if (!doRendering) {
            return;
        }
        IMultiblockBEHelperMaster helper = master.getHelper();
        ChemicalReactorLogic.State state = (ChemicalReactorLogic.State)helper.getState();
        ChemicalReactorLogic.ChemicalReactorTanks tanks = state.tanks;
        int tank_capacity = tanks.getCapacity();
        FluidStack leftTank = tanks.leftInput().getFluid();
        FluidStack rightTank = tanks.rightInput().getFluid();
        FluidStack backTank = tanks.backInput().getFluid();
        FluidStack outputTank = tanks.output().getFluid();
        MultiblockOrientation rotation = helper.getContext().getLevel().getOrientation();
        boolean mirrored = rotation.mirrored();
        ChemicalReactorRenderer.rotateForFacing(poseStack, rotation.front());
        if (!leftTank.isEmpty()) {
            tankPos = tanks.getLeftTankPos(mirrored);
            fillPercent = (float)leftTank.getAmount() / (float)tank_capacity;
            this.renderFluidInTank(tankPos, leftTank, poseStack, multiBufferSource, fillPercent);
        }
        if (!rightTank.isEmpty()) {
            tankPos = tanks.getRightTankPos(mirrored);
            fillPercent = (float)rightTank.getAmount() / (float)tank_capacity;
            this.renderFluidInTank(tankPos, rightTank, poseStack, multiBufferSource, fillPercent);
        }
        if (!backTank.isEmpty()) {
            tankPos = tanks.getBackTankPos(mirrored);
            fillPercent = (float)backTank.getAmount() / (float)tank_capacity;
            this.renderFluidInTank(tankPos, backTank, poseStack, multiBufferSource, fillPercent);
        }
        if (!outputTank.isEmpty()) {
            tankPos = tanks.getOutputTankPos(mirrored);
            fillPercent = (float)outputTank.getAmount() / (float)tank_capacity;
            this.renderFluidInTank(tankPos, outputTank, poseStack, multiBufferSource, fillPercent);
        }
    }

    private void renderFluidInTank(BlockPos pos, FluidStack fluidStack, PoseStack matrix, MultiBufferSource buffer, float percent) {
        matrix.m_85836_();
        matrix.m_85837_(0.5, 0.5, 0.5);
        float offset = 0.15625f;
        matrix.m_252880_((float)pos.m_123341_() + offset, (float)pos.m_123342_(), (float)pos.m_123343_() - offset);
        Matrix4f matrix4f = matrix.m_85850_().m_252922_();
        Matrix3f matrix3f = matrix.m_85850_().m_252943_();
        Fluid fluid = fluidStack.getFluid();
        IClientFluidTypeExtensions fluidAttributes = IClientFluidTypeExtensions.of((Fluid)fluid);
        TextureAtlasSprite fluidTexture = this.getFluidStillSprite(fluidAttributes, fluidStack);
        int color = fluidAttributes.getTintColor(fluidStack);
        VertexConsumer builder = buffer.m_6299_(RenderType.m_110466_());
        float faceoffset = 0.6875f;
        for (int i = 0; i < 2; ++i) {
            matrix.m_252880_(0.0f, (float)i * percent, 0.0f);
            this.renderFluidSides(faceoffset, fluidTexture, matrix, matrix4f, matrix3f, builder, color, percent);
        }
        this.renderTopFluidFace(fluidTexture, matrix4f, matrix3f, builder, color, percent);
        matrix.m_252880_(faceoffset, 0.0f, 0.0f);
        this.renderTopFluidFace(fluidTexture, matrix4f, matrix3f, builder, color, percent);
        matrix.m_252880_(0.0f, 0.0f, -faceoffset);
        this.renderTopFluidFace(fluidTexture, matrix4f, matrix3f, builder, color, percent);
        matrix.m_252880_(-faceoffset, 0.0f, 0.0f);
        this.renderTopFluidFace(fluidTexture, matrix4f, matrix3f, builder, color, percent);
        matrix.m_85849_();
    }

    private void renderFluidSides(float faceoffset, TextureAtlasSprite fluidTexture, PoseStack matrix, Matrix4f matrix4f, Matrix3f matrix3f, VertexConsumer builder, int color, float percent) {
        matrix.m_252880_(0.0f, 0.0f, -faceoffset);
        this.renderNorthFluidFace(fluidTexture, matrix4f, matrix3f, builder, color, percent);
        matrix.m_252880_(faceoffset, 0.0f, 0.0f);
        this.renderNorthFluidFace(fluidTexture, matrix4f, matrix3f, builder, color, percent);
        matrix.m_252880_(-faceoffset, 0.0f, 0.0f);
        matrix.m_252880_(0.0f, 0.0f, faceoffset);
        matrix.m_252781_(Axis.f_252436_.m_252977_(90.0f));
        this.renderNorthFluidFace(fluidTexture, matrix4f, matrix3f, builder, color, percent);
        matrix.m_252880_(faceoffset, 0.0f, 0.0f);
        this.renderNorthFluidFace(fluidTexture, matrix4f, matrix3f, builder, color, percent);
        matrix.m_252880_(-faceoffset, 0.0f, 0.0f);
        matrix.m_252781_(Axis.f_252436_.m_252977_(90.0f));
        this.renderNorthFluidFace(fluidTexture, matrix4f, matrix3f, builder, color, percent);
        matrix.m_252880_(-faceoffset, 0.0f, 0.0f);
        this.renderNorthFluidFace(fluidTexture, matrix4f, matrix3f, builder, color, percent);
        matrix.m_252880_(faceoffset, 0.0f, 0.0f);
        matrix.m_252781_(Axis.f_252436_.m_252977_(90.0f));
        matrix.m_252880_(0.0f, 0.0f, -faceoffset);
        this.renderNorthFluidFace(fluidTexture, matrix4f, matrix3f, builder, color, percent);
        matrix.m_252880_(-faceoffset, 0.0f, 0.0f);
        this.renderNorthFluidFace(fluidTexture, matrix4f, matrix3f, builder, color, percent);
        matrix.m_252880_(faceoffset, 0.0f, 0.0f);
        matrix.m_252880_(0.0f, 0.0f, faceoffset);
        matrix.m_252781_(Axis.f_252436_.m_252977_(90.0f));
    }

    private void renderTopFluidFace(TextureAtlasSprite sprite, Matrix4f matrix4f, Matrix3f normalMatrix, VertexConsumer builder, int color, float percent) {
        float r = (float)(color >> 16 & 0xFF) / 255.0f;
        float g = (float)(color >> 8 & 0xFF) / 255.0f;
        float b = (float)(color & 0xFF) / 255.0f;
        float a = (float)(color >> 24 & 0xFF) / 255.0f;
        float width = 0.6875f;
        float height = 1.0f;
        float minU = sprite.m_118367_(3.0);
        float maxU = sprite.m_118367_(13.0);
        float minV = sprite.m_118393_(3.0);
        float maxV = sprite.m_118393_(13.0);
        builder.m_252986_(matrix4f, -width / 2.0f, -height / 2.0f + percent * height, -width / 2.0f).m_85950_(r, g, b, a).m_7421_(minU, minV).m_86008_(OverlayTexture.f_118083_).m_85969_(0xF000F0).m_252939_(normalMatrix, 0.0f, 1.0f, 0.0f).m_5752_();
        builder.m_252986_(matrix4f, -width / 2.0f, -height / 2.0f + percent * height, width / 2.0f).m_85950_(r, g, b, a).m_7421_(minU, maxV).m_86008_(OverlayTexture.f_118083_).m_85969_(0xF000F0).m_252939_(normalMatrix, 0.0f, 1.0f, 0.0f).m_5752_();
        builder.m_252986_(matrix4f, width / 2.0f, -height / 2.0f + percent * height, width / 2.0f).m_85950_(r, g, b, a).m_7421_(maxU, maxV).m_86008_(OverlayTexture.f_118083_).m_85969_(0xF000F0).m_252939_(normalMatrix, 0.0f, 1.0f, 0.0f).m_5752_();
        builder.m_252986_(matrix4f, width / 2.0f, -height / 2.0f + percent * height, -width / 2.0f).m_85950_(r, g, b, a).m_7421_(maxU, minV).m_86008_(OverlayTexture.f_118083_).m_85969_(0xF000F0).m_252939_(normalMatrix, 0.0f, 1.0f, 0.0f).m_5752_();
    }

    private void renderNorthFluidFace(TextureAtlasSprite sprite, Matrix4f matrix4f, Matrix3f normalMatrix, VertexConsumer builder, int color, float percent) {
        float r = (float)(color >> 16 & 0xFF) / 255.0f;
        float g = (float)(color >> 8 & 0xFF) / 255.0f;
        float b = (float)(color & 0xFF) / 255.0f;
        float a = (float)(color >> 24 & 0xFF) / 255.0f;
        float width = 0.6875f;
        float height = 1.0f;
        float minU = sprite.m_118367_(3.0);
        float maxU = sprite.m_118367_(13.0);
        float minV = sprite.m_118393_(1.0);
        float maxV = sprite.m_118393_((double)(15.0f * percent));
        builder.m_252986_(matrix4f, -width / 2.0f, -height / 2.0f + height * percent, -width / 2.0f + 0.001f).m_85950_(r, g, b, a).m_7421_(minU, minV).m_86008_(OverlayTexture.f_118083_).m_85969_(0xF000F0).m_252939_(normalMatrix, 0.0f, 0.0f, 1.0f).m_5752_();
        builder.m_252986_(matrix4f, width / 2.0f, -height / 2.0f + height * percent, -width / 2.0f + 0.001f).m_85950_(r, g, b, a).m_7421_(maxU, minV).m_86008_(OverlayTexture.f_118083_).m_85969_(0xF000F0).m_252939_(normalMatrix, 0.0f, 0.0f, 1.0f).m_5752_();
        builder.m_252986_(matrix4f, width / 2.0f, -height / 2.0f, -width / 2.0f + 0.001f).m_85950_(r, g, b, a).m_7421_(maxU, maxV).m_86008_(OverlayTexture.f_118083_).m_85969_(0xF000F0).m_252939_(normalMatrix, 0.0f, 0.0f, 1.0f).m_5752_();
        builder.m_252986_(matrix4f, -width / 2.0f, -height / 2.0f, -width / 2.0f + 0.001f).m_85950_(r, g, b, a).m_7421_(minU, maxV).m_86008_(OverlayTexture.f_118083_).m_85969_(0xF000F0).m_252939_(normalMatrix, 0.0f, 0.0f, 1.0f).m_5752_();
    }

    private TextureAtlasSprite getFluidStillSprite(IClientFluidTypeExtensions properties, FluidStack fluidStack) {
        return (TextureAtlasSprite)Minecraft.m_91087_().m_91258_(InventoryMenu.f_39692_).apply(properties.getStillTexture(fluidStack));
    }

    private TextureAtlasSprite getFluidFlowingSprite(IClientFluidTypeExtensions properties, FluidStack fluidStack) {
        return (TextureAtlasSprite)Minecraft.m_91087_().m_91258_(InventoryMenu.f_39692_).apply(properties.getFlowingTexture(fluidStack));
    }
}

