/*
 * Decompiled with CFR 0.152.
 */
package com.igteam.immersivegeology.client.renderer.multiblocks;

import blusunrize.immersiveengineering.api.ApiUtils;
import blusunrize.immersiveengineering.api.multiblocks.blocks.env.IMultiblockBEHelperMaster;
import blusunrize.immersiveengineering.api.multiblocks.blocks.env.IMultiblockContext;
import blusunrize.immersiveengineering.api.multiblocks.blocks.registry.MultiblockBlockEntityMaster;
import blusunrize.immersiveengineering.api.multiblocks.blocks.util.MultiblockOrientation;
import blusunrize.immersiveengineering.client.utils.RenderUtils;
import com.igteam.immersivegeology.client.models.IGDynamicModel;
import com.igteam.immersivegeology.client.renderer.IGBlockEntityRenderer;
import com.igteam.immersivegeology.common.block.multiblocks.logic.CoreDrillLogic;
import com.igteam.immersivegeology.common.config.IGClientConfig;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.List;
import java.util.Map;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.client.model.data.ModelData;
import org.jetbrains.annotations.NotNull;
import org.joml.Quaternionf;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class CoreDrillRenderer
extends IGBlockEntityRenderer<MultiblockBlockEntityMaster<CoreDrillLogic.State>> {
    public static final String DRILL_BIT_NAME = "coredrill_bit";
    public static final String DRILL_ENGINE_NAME = "coredrill_engine";
    public static final String DRILL_ENGINE_SUPPORT_NAME = "coredrill_vagons";
    public static final String DRILL_GEARSET_NAME = "coredrill_gears";
    public static IGDynamicModel DRILL_BIT;
    public static IGDynamicModel DRILL_ENGINE;
    public static IGDynamicModel DRILL_ENGINE_SUPPORT;
    public static IGDynamicModel DRILL_GEARSET;
    public static final Map<Direction, Vector3fc> MIRRORED_OFFSETS;
    public static final Map<Direction, Vec3> DRILL_BIT_OFFSETS;
    public static final Map<Direction, Vec3> DRILL_ENGINE_OFFSETS;
    public static final Map<Direction, Vec3> DRILL_SUPPORT_OFFSETS;
    public static final Map<Direction, Vector3fc> DRILL_GEAR_ROTATION_OFFSETS;
    public static final Map<Direction, Map<Integer, Vec3>> DRILL_GEAR_OFFSETS;

    public void render(MultiblockBlockEntityMaster<CoreDrillLogic.State> tile, float pPartialTick, PoseStack poseStack, @NotNull MultiBufferSource buffer, int pPackedLight, int pPackedOverlay) {
        boolean flipSupportAngle;
        boolean doRendering = (Boolean)IGClientConfig.doSpecialRenderCoreDrill.get();
        if (!doRendering) {
            return;
        }
        IMultiblockBEHelperMaster helper = tile.getHelper();
        IMultiblockContext context = helper.getContext();
        MultiblockOrientation orientation = context.getLevel().getOrientation();
        CoreDrillLogic.State state = (CoreDrillLogic.State)context.getState();
        boolean active = state.shouldRenderActive();
        boolean isMirrored = orientation.mirrored();
        float drill_height = state.getDrillHeight() + (active ? 0.015051525f * (float)(state.getDrillDirection() ? 1 : -1) : 0.0f);
        float gear_angle = state.getGearClockwiseAngle() + 0.03125f * pPartialTick * (float)(state.getDrillDirection() ? -1 : 1);
        float counter_gear_angle = state.getGearCounterClockwiseAngle() + 0.03125f * pPartialTick * (float)(state.getDrillDirection() ? 1 : -1);
        float shake = state.getDrillShake();
        BlockPos pos = tile.m_58899_();
        Level level = tile.m_58904_();
        Direction dir = orientation.front();
        boolean bl = flipSupportAngle = dir.equals((Object)Direction.EAST) || dir.equals((Object)Direction.WEST);
        if (isMirrored) {
            poseStack.m_252880_(-MIRRORED_OFFSETS.get(dir).x(), MIRRORED_OFFSETS.get(dir).y(), -MIRRORED_OFFSETS.get(dir).z());
        }
        poseStack.m_85836_();
        poseStack.m_85837_(DRILL_BIT_OFFSETS.get(dir).m_7096_(), DRILL_BIT_OFFSETS.get(dir).m_7098_() + (double)drill_height, DRILL_BIT_OFFSETS.get(dir).m_7094_());
        poseStack.m_85836_();
        float angle = state.getDrillAngle() + state.getDrillSpeed() * pPartialTick;
        poseStack.m_252781_(new Quaternionf().rotateAxis(angle * ((float)Math.PI / 180), (Vector3fc)new Vector3f(0.0f, 1.0f, 0.0f)));
        this.renderDynamicModel(DRILL_BIT, poseStack, buffer, Direction.NORTH, level, pos, pPackedLight, pPackedOverlay);
        poseStack.m_85849_();
        poseStack.m_85849_();
        poseStack.m_85836_();
        poseStack.m_85837_(DRILL_ENGINE_OFFSETS.get(dir).m_7096_() + (double)shake, DRILL_ENGINE_OFFSETS.get(dir).m_7098_() + (double)drill_height, DRILL_ENGINE_OFFSETS.get(dir).m_7094_() + (double)shake);
        this.renderDynamicModel(DRILL_ENGINE, poseStack, buffer, dir, level, pos, pPackedLight, pPackedOverlay);
        poseStack.m_85836_();
        poseStack.m_252781_(new Quaternionf().rotateAxis((float)(flipSupportAngle ? -90 : 90) * ((float)Math.PI / 180), (Vector3fc)new Vector3f(0.0f, 1.0f, 0.0f)));
        poseStack.m_85837_(DRILL_SUPPORT_OFFSETS.get(dir).m_7096_(), DRILL_SUPPORT_OFFSETS.get(dir).m_7098_(), DRILL_SUPPORT_OFFSETS.get(dir).m_7094_());
        this.renderDynamicModel(DRILL_ENGINE_SUPPORT, poseStack, buffer, dir, level, pos, pPackedLight, pPackedOverlay);
        poseStack.m_85837_(DRILL_GEAR_OFFSETS.get(dir).get(0).m_7096_(), DRILL_GEAR_OFFSETS.get(dir).get(0).m_7098_(), DRILL_GEAR_OFFSETS.get(dir).get(0).m_7094_());
        poseStack.m_252781_(new Quaternionf().rotateAxis((float)(flipSupportAngle ? 90 : 0) * ((float)Math.PI / 180), (Vector3fc)new Vector3f(0.0f, 1.0f, 0.0f)));
        poseStack.m_85836_();
        poseStack.m_85836_();
        poseStack.m_252781_(new Quaternionf().rotateAxis(gear_angle * (float)(flipSupportAngle ? 1 : -1) * ((float)Math.PI / 180), DRILL_GEAR_ROTATION_OFFSETS.get(dir)));
        this.renderDynamicModel(DRILL_GEARSET, poseStack, buffer, Direction.NORTH, level, pos, pPackedLight, pPackedOverlay);
        poseStack.m_85849_();
        poseStack.m_85837_(DRILL_GEAR_OFFSETS.get(dir).get(1).m_7096_(), DRILL_GEAR_OFFSETS.get(dir).get(1).m_7098_(), DRILL_GEAR_OFFSETS.get(dir).get(1).m_7094_());
        poseStack.m_85836_();
        poseStack.m_252781_(new Quaternionf().rotateAxis(counter_gear_angle * (float)(flipSupportAngle ? 1 : -1) * ((float)Math.PI / 180), DRILL_GEAR_ROTATION_OFFSETS.get(dir)));
        this.renderDynamicModel(DRILL_GEARSET, poseStack, buffer, Direction.NORTH, level, pos, pPackedLight, pPackedOverlay);
        poseStack.m_85849_();
        poseStack.m_85837_(DRILL_GEAR_OFFSETS.get(dir).get(2).m_7096_(), DRILL_GEAR_OFFSETS.get(dir).get(2).m_7098_(), DRILL_GEAR_OFFSETS.get(dir).get(2).m_7094_());
        poseStack.m_85836_();
        poseStack.m_252781_(new Quaternionf().rotateAxis(gear_angle * (float)(flipSupportAngle ? 1 : -1) * ((float)Math.PI / 180), DRILL_GEAR_ROTATION_OFFSETS.get(dir)));
        this.renderDynamicModel(DRILL_GEARSET, poseStack, buffer, Direction.NORTH, level, pos, pPackedLight, pPackedOverlay);
        poseStack.m_85849_();
        poseStack.m_85837_(DRILL_GEAR_OFFSETS.get(dir).get(3).m_7096_(), DRILL_GEAR_OFFSETS.get(dir).get(3).m_7098_(), DRILL_GEAR_OFFSETS.get(dir).get(3).m_7094_());
        poseStack.m_85836_();
        poseStack.m_252781_(new Quaternionf().rotateAxis(counter_gear_angle * (float)(flipSupportAngle ? 1 : -1) * ((float)Math.PI / 180), DRILL_GEAR_ROTATION_OFFSETS.get(dir)));
        this.renderDynamicModel(DRILL_GEARSET, poseStack, buffer, Direction.NORTH, level, pos, pPackedLight, pPackedOverlay);
        poseStack.m_85849_();
        poseStack.m_85849_();
        poseStack.m_85849_();
        poseStack.m_85849_();
    }

    private void renderDynamicModel(IGDynamicModel model, PoseStack matrix, MultiBufferSource buffer, Direction facing, Level level, BlockPos pos, int light, int overlay) {
        matrix.m_85836_();
        List quads = model.get().getQuads(null, null, ApiUtils.RANDOM_SOURCE, ModelData.EMPTY, null);
        CoreDrillRenderer.rotateForFacing(matrix, facing);
        RenderUtils.renderModelTESRFancy((List)quads, (VertexConsumer)buffer.m_6299_(RenderType.m_110463_()), (PoseStack)matrix, (Level)level, (BlockPos)pos, (boolean)false, (int)0xFFFFFF, (int)light);
        matrix.m_85849_();
    }

    static {
        MIRRORED_OFFSETS = Map.of(Direction.NORTH, new Vector3f(-6.0f, 0.0f, 0.0f), Direction.EAST, new Vector3f(0.0f, 0.0f, -6.0f), Direction.SOUTH, new Vector3f(6.0f, 0.0f, 0.0f), Direction.WEST, new Vector3f(0.0f, 0.0f, 6.0f));
        DRILL_BIT_OFFSETS = Map.of(Direction.NORTH, new Vec3(-2.5, -1.9375, -2.5), Direction.EAST, new Vec3(3.5, -1.9375, -2.5), Direction.SOUTH, new Vec3(3.5, -1.9375, 3.5), Direction.WEST, new Vec3(-2.5, -1.9375, 3.5));
        DRILL_ENGINE_OFFSETS = Map.of(Direction.NORTH, new Vec3(-4.5, -7.875, -4.5), Direction.EAST, new Vec3(4.5, -7.875, -4.5), Direction.SOUTH, new Vec3(4.5, -7.875, 4.5), Direction.WEST, new Vec3(-4.5, -7.875, 4.5));
        DRILL_SUPPORT_OFFSETS = Map.of(Direction.NORTH, new Vec3(-4.0, 1.0, 0.0), Direction.EAST, new Vec3(3.0, 1.0, -1.0), Direction.SOUTH, new Vec3(2.0, 1.0, 0.0), Direction.WEST, new Vec3(-3.0, 1.0, -1.0));
        DRILL_GEAR_ROTATION_OFFSETS = Map.of(Direction.NORTH, new Vector3f(0.0f, 0.0f, 1.0f), Direction.EAST, new Vector3f(0.0f, 0.0f, -1.0f), Direction.SOUTH, new Vector3f(0.0f, 0.0f, -1.0f), Direction.WEST, new Vector3f(0.0f, 0.0f, -1.0f));
        DRILL_GEAR_OFFSETS = Map.of(Direction.NORTH, Map.of(0, new Vec3(-2.125, 6.2, 2.0), 1, new Vec3(2.25, 0.0, 0.0), 2, new Vec3(3.75, 0.0, 0.0), 3, new Vec3(2.25, 0.0, 0.0)), Direction.EAST, Map.of(0, new Vec3(-1.0, 6.2, 6.125), 1, new Vec3(2.25, 0.0, 0.0), 2, new Vec3(3.75, 0.0, 0.0), 3, new Vec3(2.25, 0.0, 0.0)), Direction.SOUTH, Map.of(0, new Vec3(3.125, 6.2, -1.0), 1, new Vec3(-2.25, 0.0, 0.0), 2, new Vec3(-3.75, 0.0, 0.0), 3, new Vec3(-2.25, 0.0, 0.0)), Direction.WEST, Map.of(0, new Vec3(2.0, 6.2, 3.125), 1, new Vec3(2.25, 0.0, 0.0), 2, new Vec3(3.75, 0.0, 0.0), 3, new Vec3(2.25, 0.0, 0.0)));
    }
}

