/*
 * Decompiled with CFR 0.152.
 */
package com.igteam.immersivegeology.client.renderer.multiblocks;

import blusunrize.immersiveengineering.api.multiblocks.blocks.env.IMultiblockBEHelperMaster;
import blusunrize.immersiveengineering.api.multiblocks.blocks.env.IMultiblockContext;
import blusunrize.immersiveengineering.api.multiblocks.blocks.registry.MultiblockBlockEntityMaster;
import blusunrize.immersiveengineering.api.multiblocks.blocks.util.MultiblockOrientation;
import blusunrize.immersiveengineering.common.blocks.multiblocks.process.MultiblockProcess;
import blusunrize.immersiveengineering.common.blocks.multiblocks.process.ProcessContext;
import com.igteam.immersivegeology.client.helper.LinkedMultiSkin;
import com.igteam.immersivegeology.client.models.IGDynamicModel;
import com.igteam.immersivegeology.client.renderer.IGBlockEntityRenderer;
import com.igteam.immersivegeology.common.block.multiblocks.IGPelletizerMultiblock;
import com.igteam.immersivegeology.common.block.multiblocks.logic.PelletizerLogic;
import com.igteam.immersivegeology.common.block.multiblocks.part.PelletizerPart;
import com.igteam.immersivegeology.common.block.multiblocks.recipe.PelletizerRecipe;
import com.igteam.immersivegeology.common.block.multiblocks.skins.IGPelletizerSkins;
import com.igteam.immersivegeology.common.config.IGClientConfig;
import com.igteam.immersivegeology.core.material.data.enums.ChemicalEnum;
import com.igteam.immersivegeology.core.material.helper.flags.BlockCategoryFlags;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.joml.Quaternionf;
import org.joml.Vector3f;
import org.joml.Vector3fc;

@LinkedMultiSkin(multiblock=IGPelletizerMultiblock.class)
public class PelletizerRenderer
extends IGBlockEntityRenderer<MultiblockBlockEntityMaster<PelletizerLogic.State>> {
    public static final String DISH_NAME = "pelletizer_dish";
    public static final String FUNNEL_NAME = "pelletizer_funnel";
    private final Map<String, List<BakedQuad>> quadCache = new HashMap<String, List<BakedQuad>>();
    public static IGDynamicModel DISH;
    public static IGDynamicModel FUNNEL;
    private ItemStack renderStack = ItemStack.f_41583_;

    public void render(MultiblockBlockEntityMaster<PelletizerLogic.State> tile, float pPartialTick, PoseStack poseStack, @NotNull MultiBufferSource buffer, int pPackedLight, int pPackedOverlay) {
        boolean doRendering = (Boolean)IGClientConfig.doSpecialRenderPelletizer.get();
        if (!doRendering) {
            return;
        }
        IMultiblockBEHelperMaster helper = tile.getHelper();
        IMultiblockContext context = helper.getContext();
        ItemRenderer itemRenderer = Minecraft.m_91087_().m_91291_();
        MultiblockOrientation orientation = context.getLevel().getOrientation();
        PelletizerLogic.State state = (PelletizerLogic.State)context.getState();
        IGPelletizerSkins skin = (IGPelletizerSkins)((Object)tile.m_58900_().m_61143_(PelletizerPart.PELLETIZER));
        float rot = state.getRotation();
        BlockPos pos = tile.m_58899_();
        Level level = tile.m_58904_();
        Direction dir = orientation.front();
        boolean isActive = state.shouldRenderActive();
        float angleDrum = isActive ? rot - pPartialTick : rot;
        List<MultiblockProcess<PelletizerRecipe, ProcessContext.ProcessContextInWorld<PelletizerRecipe>>> queue = state.getProcessQueue();
        boolean canProcess = state.energy.getEnergyStored() > 0 && state.tank.getFluid().getFluid().m_6212_(ChemicalEnum.BindingAgent.getFluid(BlockCategoryFlags.FLUID));
        ItemStack stack = state.getInventory().getStackInSlot(0);
        poseStack.m_85836_();
        PelletizerRenderer.rotateForFacing(poseStack, dir);
        poseStack.m_85836_();
        poseStack.m_85837_(0.5, 1.921875, 0.609375);
        poseStack.m_252781_(new Quaternionf().rotateAxis(0.5235988f, (Vector3fc)new Vector3f(1.0f, 0.0f, 0.0f)));
        poseStack.m_85836_();
        poseStack.m_252781_(new Quaternionf().rotateAxis(angleDrum * ((float)Math.PI / 180), (Vector3fc)new Vector3f(0.0f, 1.0f, 0.0f)));
        this.renderDynamicModel(DISH, poseStack, buffer, Direction.NORTH, level, pos, pPackedLight, pPackedOverlay, skin);
        poseStack.m_85849_();
        poseStack.m_252880_(0.0f, 0.0f, 1.0f);
        poseStack.m_85836_();
        poseStack.m_252781_(new Quaternionf().rotateAxis((float)(-(canProcess ? 90 : 105)) * ((float)Math.PI / 180), (Vector3fc)new Vector3f(1.0f, 0.0f, 0.0f)));
        poseStack.m_85836_();
        int maxIndex = Math.min(16, queue.size());
        for (int index = maxIndex - 1; index >= 0; --index) {
            MultiblockProcess<PelletizerRecipe, ProcessContext.ProcessContextInWorld<PelletizerRecipe>> process = queue.get(index);
            int processTick = process.processTick;
            int trueMax = process.getMaxTicks(level);
            int maxProcess = Math.round((float)trueMax * 0.5f);
            PelletizerRecipe recipe = (PelletizerRecipe)process.getRecipe(tile.m_58904_());
            if (recipe == null) continue;
            ItemStack input = recipe.itemIn.getRandomizedExampleStack(0);
            ItemStack output = (ItemStack)recipe.itemOutput.get();
            float angle = (float)index / (float)maxIndex * (float)Math.PI;
            float radiusX = 0.35f;
            float radiusY = 0.13f;
            float xOffset = (float)(Math.cos(angle) * (double)radiusX) - 0.0625f;
            float yOffset = (float)(Math.sin(angle) * (double)(-radiusY)) + (canProcess ? 0.125f : 0.0125f);
            poseStack.m_252880_(xOffset, yOffset, (float)index / 8.0f * 0.01f);
            poseStack.m_85836_();
            if (processTick > maxProcess) {
                float trueProcess = (float)processTick / (float)trueMax - 0.5f;
                scale = 0.5f + trueProcess;
                poseStack.m_85841_(scale, scale, 1.0f);
            } else {
                float progress = (float)processTick / (float)maxProcess * 0.5f;
                scale = 1.0f - progress;
                poseStack.m_85841_(scale, scale, 1.0f);
            }
            poseStack.m_252781_(new Quaternionf().rotateAxis(((float)(index * 15 * ((index ^ 1) == 0 ? -1 : 1)) + angleDrum * 4.0f % 360.0f) * ((float)Math.PI / 180), (Vector3fc)new Vector3f(0.0f, 0.0f, 1.0f)));
            itemRenderer.m_269128_(processTick > maxProcess ? output : input, ItemDisplayContext.GROUND, pPackedLight, pPackedOverlay, poseStack, buffer, level, 0);
            poseStack.m_85849_();
            poseStack.m_252880_(-xOffset, -yOffset, -((float)index / 8.0f) * 0.01f);
        }
        if (queue.isEmpty() & !stack.m_41619_()) {
            int max;
            for (int index = max = Math.min(7, stack.m_41613_()); index >= 0; --index) {
                float angle = (float)index / 8.0f * (float)Math.PI;
                float radiusX = 0.35f;
                float radiusY = 0.13f;
                float xOffset = (float)(Math.cos(angle) * (double)radiusX) - 0.0625f;
                float yOffset = (float)(Math.sin(angle) * (double)(-radiusY)) + (canProcess ? 0.125f : 0.0115f);
                poseStack.m_252880_(xOffset, yOffset, (float)index / 8.0f * 0.01f);
                poseStack.m_85836_();
                poseStack.m_252781_(new Quaternionf().rotateAxis(((float)(index * 15 * ((index ^ 1) == 0 ? -1 : 1)) + angleDrum * 4.0f % 360.0f) * ((float)Math.PI / 180), (Vector3fc)new Vector3f(0.0f, 0.0f, 1.0f)));
                itemRenderer.m_269128_(stack, ItemDisplayContext.GROUND, pPackedLight, pPackedOverlay, poseStack, buffer, level, 0);
                poseStack.m_85849_();
                poseStack.m_252880_(-xOffset, -yOffset, -((float)index / 8.0f) * 0.01f);
            }
        }
        poseStack.m_85849_();
        poseStack.m_85849_();
        poseStack.m_85849_();
        poseStack.m_85849_();
    }
}

