/*
 * Decompiled with CFR 0.152.
 */
package com.igteam.immersivegeology.common.block;

import com.igteam.immersivegeology.client.menu.ItemSubGroup;
import com.igteam.immersivegeology.common.block.helper.IGBlockType;
import com.igteam.immersivegeology.core.material.GeologyMaterial;
import com.igteam.immersivegeology.core.material.helper.flags.BlockCategoryFlags;
import com.igteam.immersivegeology.core.material.helper.flags.IFlagType;
import com.igteam.immersivegeology.core.material.helper.material.MaterialInterface;
import com.igteam.immersivegeology.core.material.helper.material.MaterialTexture;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;

public class IGGenericBlock
extends Block
implements IGBlockType {
    protected final Map<MaterialTexture, MaterialInterface<?>> materialMap = new HashMap();
    protected final BlockCategoryFlags category;

    public IGGenericBlock(BlockCategoryFlags flag, MaterialInterface<?> material) {
        this(flag, material, ((GeologyMaterial)material.instance()).getProperties(flag));
    }

    public IGGenericBlock(BlockCategoryFlags flag, MaterialInterface<?> material, BlockBehaviour.Properties props) {
        super(props);
        this.materialMap.put(MaterialTexture.base, material);
        this.category = flag;
    }

    @Override
    public IFlagType<?> getFlag() {
        return this.category;
    }

    @Override
    public ItemSubGroup getGroup() {
        return this.category.getSubGroup();
    }

    @Override
    public int getColor(int index, BlockState state) {
        if (this.materialMap == null || this.materialMap.isEmpty()) {
            return -1;
        }
        MaterialTexture texture = MaterialTexture.base;
        if (MaterialTexture.values()[index > 0 ? 1 : 0] != null) {
            texture = MaterialTexture.values()[index > 0 ? 1 : 0];
        }
        if (index > this.materialMap.size()) {
            return this.materialMap.get((Object)texture).getColor(this.category, 0);
        }
        if (this.materialMap.get((Object)texture) != null) {
            return this.materialMap.get((Object)texture).getColor(this.category, 0);
        }
        return -1;
    }

    @Override
    @NotNull
    public Collection<MaterialInterface<?>> getMaterials() {
        return this.materialMap.values();
    }

    @Override
    public MaterialInterface<?> getMaterial(MaterialTexture t) {
        return this.materialMap.get((Object)t);
    }

    @Override
    public Block getIGBlock() {
        return this;
    }

    @Override
    public Map<MaterialTexture, MaterialInterface<?>> getMaterialMap() {
        return this.materialMap;
    }
}

