/*
 * Decompiled with CFR 0.152.
 */
package com.igteam.immersivegeology.common.block.entity.cable;

import blusunrize.immersiveengineering.api.ApiUtils;
import blusunrize.immersiveengineering.api.IEProperties;
import blusunrize.immersiveengineering.api.client.ieobj.BlockCallback;
import blusunrize.immersiveengineering.api.shader.ShaderCase;
import blusunrize.immersiveengineering.api.utils.DirectionUtils;
import blusunrize.immersiveengineering.common.util.chickenbones.Matrix4;
import com.igteam.immersivegeology.common.block.entity.cable.IGEnergyPipeEntity;
import com.mojang.math.Transformation;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.client.model.data.ModelData;
import org.joml.Vector4f;
import org.joml.Vector4fc;

public class EnergyPipeCallback
implements BlockCallback<Key> {
    public static final EnergyPipeCallback INSTANCE = new EnergyPipeCallback();
    private static final Key INVALID = new Key((Map)Util.m_137469_(new EnumMap(Direction.class), m -> {
        for (Direction d : DirectionUtils.VALUES) {
            m.put(d, IGEnergyPipeEntity.ConnectionStyle.NO_CONNECTION);
        }
    }), null, null);

    public Key extractKey(@Nonnull BlockAndTintGetter level, @Nonnull BlockPos pos, @Nonnull BlockState state, BlockEntity blockEntity) {
        Direction[] var7;
        if (!(blockEntity instanceof IGEnergyPipeEntity)) {
            return this.getDefaultKey();
        }
        IGEnergyPipeEntity pipeBE = (IGEnergyPipeEntity)blockEntity;
        EnumMap<Direction, IGEnergyPipeEntity.ConnectionStyle> connections = new EnumMap<Direction, IGEnergyPipeEntity.ConnectionStyle>(Direction.class);
        for (Direction face : var7 = DirectionUtils.VALUES) {
            connections.put(face, pipeBE.getConnectionStyle(face));
        }
        return new Key(connections, pipeBE.cover == Blocks.f_50016_ ? null : pipeBE.cover, pipeBE.getColor());
    }

    public Key getDefaultKey() {
        return INVALID;
    }

    public IEProperties.IEObjState getIEOBJState(Key key) {
        ArrayList<Object> parts = new ArrayList<Object>();
        Matrix4 rotationMatrix = new Matrix4();
        rotationMatrix.translate(0.5, 0.5, 0.5);
        Direction[] directions = Direction.values();
        HashSet<Direction> addedDirections = new HashSet<Direction>();
        boolean hasAddedStraight = false;
        int totalConnections = key.numActiveConnections();
        for (Direction f : directions) {
            Direction d;
            if (key.hasPluggedConnection(f)) {
                d = f;
                if (Direction.Plane.HORIZONTAL.test(f)) {
                    d = f.m_122424_();
                }
                parts.add("elec_" + this.getDirectionSuffix(d));
            }
            if (key.hasCouplingConnection(f)) {
                d = f;
                if (Direction.Plane.HORIZONTAL.test(f)) {
                    d = f.m_122424_();
                }
                parts.add("con_" + this.getDirectionSuffix(d));
            }
            if (!key.hasActiveConnection(f)) continue;
            d = f;
            if (Direction.Plane.HORIZONTAL.test(f)) {
                d = f.m_122424_();
            }
            if (key.hasActiveConnection(f.m_122424_()) && totalConnections == 2) {
                if (addedDirections.contains(f.m_122424_())) continue;
                if (Direction.Plane.VERTICAL.test(f) && !hasAddedStraight) {
                    parts.add("pipe_y");
                    hasAddedStraight = true;
                }
                if (Direction.Plane.HORIZONTAL.test(f)) {
                    if (f.m_122434_().equals((Object)Direction.Axis.X) && !hasAddedStraight) {
                        parts.add("pipe_x");
                        hasAddedStraight = true;
                    }
                    if (f.m_122434_().equals((Object)Direction.Axis.Z) && !hasAddedStraight) {
                        parts.add("pipe_z");
                        hasAddedStraight = true;
                    }
                }
            }
            if (!hasAddedStraight) {
                parts.add("pipe_" + d.m_122433_().toLowerCase());
            }
            addedDirections.add(f);
        }
        if (!hasAddedStraight) {
            if (totalConnections <= 1) {
                parts.add("center_frame");
            } else {
                parts.add("center");
            }
        }
        rotationMatrix.translate(-0.5, -0.5, -0.5);
        return new IEProperties.IEObjState(IEProperties.VisibilityList.show(parts), new Transformation(rotationMatrix.toMatrix4f()));
    }

    public List<BakedQuad> modifyQuads(Key key, List<BakedQuad> quads) {
        if (key.cover() != null) {
            BlockState state = key.cover().m_49966_();
            BakedModel model = Minecraft.m_91087_().m_91289_().m_110907_().m_110893_(state);
            for (RenderType layer : RenderType.m_110506_()) {
                for (Direction direction : Direction.values()) {
                    quads.addAll(model.getQuads(state, direction, ApiUtils.RANDOM_SOURCE, ModelData.EMPTY, layer));
                }
                quads.addAll(model.getQuads(state, (Direction)null, ApiUtils.RANDOM_SOURCE, ModelData.EMPTY, layer));
            }
        }
        return quads;
    }

    private String getDirectionSuffix(Direction dir) {
        switch (dir) {
            case UP: {
                return "yMax";
            }
            case DOWN: {
                return "yMin";
            }
            case NORTH: {
                return "zMax";
            }
            case SOUTH: {
                return "zMin";
            }
            case EAST: {
                return "xMin";
            }
            case WEST: {
                return "xMax";
            }
        }
        return "";
    }

    public Vector4f getRenderColor(Key key, String group, String material, ShaderCase shaderCase, Vector4f original) {
        if (key.color() != null) {
            float[] rgb = key.color().m_41068_();
            return new Vector4f(rgb[0], rgb[1], rgb[2], 1.0f).mul((Vector4fc)original);
        }
        return original;
    }

    public record Key(Map<Direction, IGEnergyPipeEntity.ConnectionStyle> connections, @Nullable Block cover, @Nullable DyeColor color) {
        int numActiveConnections() {
            int count = 0;
            for (IGEnergyPipeEntity.ConnectionStyle c : this.connections.values()) {
                if (c == IGEnergyPipeEntity.ConnectionStyle.NO_CONNECTION) continue;
                ++count;
            }
            return count;
        }

        public boolean hasActiveConnection(Direction side) {
            return this.connections.get(side) != IGEnergyPipeEntity.ConnectionStyle.NO_CONNECTION;
        }

        public boolean hasCouplingConnection(Direction side) {
            return this.connections.get(side) == IGEnergyPipeEntity.ConnectionStyle.FLANGE;
        }

        public boolean hasPluggedConnection(Direction side) {
            return this.connections.get(side) == IGEnergyPipeEntity.ConnectionStyle.PLUGGED;
        }

        public boolean anyPluggedConnection(Direction ... sides) {
            Direction[] var2 = sides;
            int var3 = sides.length;
            for (int var4 = 0; var4 < var3; ++var4) {
                Direction side = var2[var4];
                if (!this.hasPluggedConnection(side)) continue;
                return true;
            }
            return false;
        }

        public boolean any(Direction ... sides) {
            Direction[] var2 = sides;
            int var3 = sides.length;
            for (int var4 = 0; var4 < var3; ++var4) {
                Direction side = var2[var4];
                if (!this.hasActiveConnection(side)) continue;
                return true;
            }
            return false;
        }

        public boolean all(Direction ... sides) {
            Direction[] var2 = sides;
            int var3 = sides.length;
            for (int var4 = 0; var4 < var3; ++var4) {
                Direction side = var2[var4];
                if (this.hasActiveConnection(side)) continue;
                return false;
            }
            return true;
        }

        public int numPluggedConnections() {
            Direction[] v;
            int i = 0;
            for (Direction d : v = Direction.values()) {
                if (!this.hasPluggedConnection(d)) continue;
                ++i;
            }
            return i;
        }
    }
}

