/*
 * Decompiled with CFR 0.152.
 */
package com.igteam.immersivegeology.common.block.entity.cable;

import blusunrize.immersiveengineering.api.IETags;
import blusunrize.immersiveengineering.api.utils.DirectionUtils;
import blusunrize.immersiveengineering.api.utils.SafeChunkUtils;
import blusunrize.immersiveengineering.api.utils.shapes.CachedVoxelShapes;
import blusunrize.immersiveengineering.common.EventHandler;
import blusunrize.immersiveengineering.common.blocks.IEBaseBlock;
import blusunrize.immersiveengineering.common.blocks.IEBaseBlockEntity;
import blusunrize.immersiveengineering.common.blocks.IEBlockInterfaces;
import blusunrize.immersiveengineering.common.register.IEBlocks;
import blusunrize.immersiveengineering.common.register.IEItems;
import blusunrize.immersiveengineering.common.util.ResettableCapability;
import blusunrize.immersiveengineering.common.util.Utils;
import blusunrize.immersiveengineering.common.util.WorldMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.igteam.immersivegeology.common.block.entity.cable.IEnergyPipe;
import com.igteam.immersivegeology.common.block.entity.cable.IGEnergyPipe;
import com.igteam.immersivegeology.common.block.helper.IGUndefinedEnergyInterface;
import com.igteam.immersivegeology.common.block.helper.MultiblockCapabilityReference;
import com.igteam.immersivegeology.core.registration.IGRegistrationHolder;
import it.unimi.dsi.fastutil.HashCommon;
import it.unimi.dsi.fastutil.objects.Object2BooleanMap;
import it.unimi.dsi.fastutil.objects.Object2BooleanOpenHashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.event.level.LevelEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;

@Mod.EventBusSubscriber(modid="immersivegeology", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class IGEnergyPipeEntity
extends IEBaseBlockEntity
implements IEnergyPipe,
IEBlockInterfaces.IColouredBE,
IEBlockInterfaces.IPlayerInteraction,
IEBlockInterfaces.IHammerInteraction,
IEBlockInterfaces.IPlacementInteraction,
IEBlockInterfaces.ISelectionBounds,
IEBlockInterfaces.ICollisionBounds,
IEBlockInterfaces.IAdditionalDrops {
    static WorldMap<BlockPos, Set<DirectionalEnergyOutput>> indirectConnections = new WorldMap();
    public static ArrayList<Predicate<Block>> validPipeCovers = new ArrayList();
    public static ArrayList<Predicate<Block>> climbablePipeCovers = new ArrayList();
    public Object2BooleanMap<Direction> sideConfig = new Object2BooleanOpenHashMap();
    public Block cover;
    private byte connections;
    @Nullable
    private DyeColor color;
    private final Map<Direction, ResettableCapability<IEnergyStorage>> sidedHandlers;
    private final Map<Direction, MultiblockCapabilityReference<IEnergyStorage>> neighbors;
    private static final CachedVoxelShapes<BoundingBoxKey> SHAPES = new CachedVoxelShapes(IGEnergyPipeEntity::getBoxes);

    public IGEnergyPipeEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)IGRegistrationHolder.ENERGY_PIPE.get(), pos, state);
        Direction f;
        int var5;
        Direction[] var3 = DirectionUtils.VALUES;
        int var4 = var3.length;
        for (var5 = 0; var5 < var4; ++var5) {
            f = var3[var5];
            this.sideConfig.put((Object)f, true);
        }
        this.cover = Blocks.f_50016_;
        this.connections = 0;
        this.color = null;
        this.sidedHandlers = new EnumMap<Direction, ResettableCapability<IEnergyStorage>>(Direction.class);
        this.neighbors = MultiblockCapabilityReference.forAllNeighbors((BlockEntity)this, ForgeCapabilities.ENERGY);
        for (var5 = 0; var5 < var4; ++var5) {
            f = var3[var5];
            this.sidedHandlers.put(f, (ResettableCapability<IEnergyStorage>)this.registerCapability(new PipeEnergyHandler(this, f)));
        }
    }

    @Override
    public boolean hasVoltageLimit() {
        return true;
    }

    @Override
    public int getVoltageLimit(IGEnergyPipe pipe) {
        return pipe.getTransferLimit();
    }

    public static void initCovers() {
        validPipeCovers.add(b -> b.m_49966_().m_204336_(IETags.scaffoldingAlu));
        validPipeCovers.add(b -> b.m_49966_().m_204336_(IETags.scaffoldingSteel));
        validPipeCovers.add(input -> input == IEBlocks.WoodenDecoration.TREATED_SCAFFOLDING.get());
        climbablePipeCovers.add(b -> b.m_49966_().m_204336_(IETags.scaffoldingAlu));
        climbablePipeCovers.add(b -> b.m_49966_().m_204336_(IETags.scaffoldingSteel));
        climbablePipeCovers.add(input -> input == IEBlocks.WoodenDecoration.TREATED_SCAFFOLDING.get());
    }

    public static Set<DirectionalEnergyOutput> getConnectedEnergyHandlers(BlockPos node, Level world) {
        if (world.f_46443_) {
            return ImmutableSet.of();
        }
        Set cachedResult = (Set)indirectConnections.get(world, (Object)node);
        if (cachedResult != null) {
            return cachedResult;
        }
        ArrayList<BlockPos> openList = new ArrayList<BlockPos>();
        ArrayList<BlockPos> closedList = new ArrayList<BlockPos>();
        Set<DirectionalEnergyOutput> energyHandlers = Collections.newSetFromMap(new ConcurrentHashMap());
        openList.add(node);
        while (!openList.isEmpty() && closedList.size() < 1024) {
            BlockPos next = (BlockPos)openList.get(0);
            openList.remove(0);
            BlockEntity pipeTile = Utils.getExistingTileEntity((Level)world, (BlockPos)next);
            if (closedList.contains(next) || !(pipeTile instanceof IGEnergyPipeEntity)) continue;
            closedList.add(next);
            for (Direction fd : DirectionUtils.VALUES) {
                BlockPos nextPos;
                BlockEntity adjacentTile;
                if (!((IGEnergyPipeEntity)pipeTile).hasOutputConnection(fd) || (adjacentTile = Utils.getExistingTileEntity((Level)world, (BlockPos)(nextPos = next.m_121945_(fd)))) == null) continue;
                if (adjacentTile instanceof IGEnergyPipeEntity) {
                    openList.add(nextPos);
                    continue;
                }
                LazyOptional handlerOptional = adjacentTile.getCapability(ForgeCapabilities.ENERGY, fd.m_122424_());
                handlerOptional.ifPresent(handler -> energyHandlers.add(new DirectionalEnergyOutput((IEnergyStorage)handler, fd, adjacentTile)));
            }
        }
        indirectConnections.put(world, (Object)node, energyHandlers);
        return energyHandlers;
    }

    public void onLoad() {
        super.onLoad();
        if (this.f_58857_ != null && !this.f_58857_.f_46443_) {
            EventHandler.SERVER_TASKS.add(() -> {
                boolean changed = false;
                for (Direction f : DirectionUtils.VALUES) {
                    changed |= this.updateConnectionByte(f);
                }
                if (changed) {
                    this.f_58857_.m_46672_(this.f_58858_, this.m_58900_().m_60734_());
                    this.markContainingBlockForUpdate(null);
                }
            });
        }
    }

    public void setRemovedIE() {
        super.setRemovedIE();
        if (this.f_58857_ != null && !this.f_58857_.f_46443_) {
            indirectConnections.clearDimension(this.f_58857_);
        }
    }

    public void onChunkUnloaded() {
        super.onChunkUnloaded();
        if (this.f_58857_ != null && !this.f_58857_.f_46443_) {
            indirectConnections.clearDimension(this.f_58857_);
        }
    }

    public void onEntityCollision(Level world, Entity entity) {
        if (entity instanceof LivingEntity && !((LivingEntity)entity).m_6147_() && this.cover != Blocks.f_50016_) {
            boolean climb = false;
            for (Predicate<Block> f : climbablePipeCovers) {
                if (f == null || !f.test(this.cover)) continue;
                climb = true;
                break;
            }
            if (climb) {
                IEBaseBlock.IELadderBlock.applyLadderLogic((Entity)entity);
            }
        }
    }

    public void readCustomNBT(CompoundTag nbt, boolean descPacket) {
        int[] config = nbt.m_128465_("sideConfig");
        for (int i = 0; i < 6; ++i) {
            Direction curDir = Direction.m_122376_((int)i);
            if (i < config.length) {
                boolean connected = config[i] != 0;
                this.sideConfig.put((Object)curDir, connected);
                if (connected) {
                    this.setValidHandler(curDir);
                    continue;
                }
                this.invalidateHandler(curDir);
                continue;
            }
            this.sideConfig.put((Object)curDir, false);
            this.invalidateHandler(curDir);
        }
        Block oldCover = this.cover;
        this.cover = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(nbt.m_128461_("cover")));
        DyeColor oldColor = this.color;
        this.color = nbt.m_128425_("color", 3) ? DyeColor.m_41053_((int)nbt.m_128451_("color")) : null;
        byte oldConns = this.connections;
        this.connections = nbt.m_128445_("connections");
        if (this.f_58857_ != null && this.f_58857_.f_46443_ && (this.connections != oldConns || this.color != oldColor || this.cover != oldCover)) {
            BlockState state = this.f_58857_.m_8055_(this.f_58858_);
            this.f_58857_.m_7260_(this.f_58858_, state, state, 3);
        }
    }

    public void writeCustomNBT(CompoundTag nbt, boolean descPacket) {
        int[] config = new int[6];
        for (int i = 0; i < 6; ++i) {
            if (!this.sideConfig.getBoolean((Object)Direction.m_122376_((int)i))) continue;
            config[i] = 1;
        }
        nbt.m_128385_("sideConfig", config);
        if (this.hasCover()) {
            nbt.m_128359_("cover", ForgeRegistries.BLOCKS.getKey((Object)this.cover).toString());
        }
        nbt.m_128344_("connections", this.connections);
        if (this.color != null) {
            nbt.m_128405_("color", this.color.m_41060_());
        }
    }

    private void invalidateHandler(Direction side) {
        ResettableCapability<IEnergyStorage> handler = this.sidedHandlers.get(side);
        if (handler != null) {
            this.sidedHandlers.put(side, null);
            handler.reset();
        }
    }

    private void setValidHandler(Direction side) {
        ResettableCapability<IEnergyStorage> handler = this.sidedHandlers.get(side);
        if (handler == null) {
            this.sidedHandlers.put(side, (ResettableCapability<IEnergyStorage>)this.registerCapability(new PipeEnergyHandler(this, side)));
        }
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> capability, @Nullable Direction facing) {
        return capability == ForgeCapabilities.ENERGY && facing != null && this.sideConfig.getBoolean((Object)facing) ? this.sidedHandlers.get(facing).cast() : super.getCapability(capability, facing);
    }

    protected boolean hasCover() {
        return this.cover != Blocks.f_50016_;
    }

    public Collection<ItemStack> getExtraDrops(Player player, BlockState state) {
        return this.hasCover() ? Lists.newArrayList((Object[])new ItemStack[]{new ItemStack((ItemLike)this.cover)}) : null;
    }

    public void onNeighborBlockChange(BlockPos otherPos) {
        super.onNeighborBlockChange(otherPos);
        Direction dir = Direction.m_122372_((float)(otherPos.m_123341_() - this.f_58858_.m_123341_()), (float)(otherPos.m_123342_() - this.f_58858_.m_123342_()), (float)(otherPos.m_123343_() - this.f_58858_.m_123343_()));
        if (this.updateConnectionByte(dir)) {
            Level world = this.getLevelNonnull();
            world.m_46590_(this.f_58858_, this.m_58900_().m_60734_(), dir);
            this.markContainingBlockForUpdate(null);
            if (!world.f_46443_) {
                indirectConnections.clearDimension(world);
            }
        }
    }

    public boolean updateConnectionByte(Direction dir) {
        if (this.f_58857_ != null && !this.f_58857_.f_46443_ && SafeChunkUtils.isChunkSafe((LevelAccessor)this.f_58857_, (BlockPos)this.f_58858_.m_121945_(dir))) {
            MultiblockCapabilityReference<IEnergyStorage> neighbor;
            IEnergyStorage handler;
            byte oldConn = this.connections;
            int i = dir.m_122411_();
            int mask = 1 << i;
            this.connections = (byte)(this.connections & ~mask);
            if (this.sideConfig.getBoolean((Object)dir) && (handler = (neighbor = this.neighbors.get(dir)).getNullable()) != null && (handler.getEnergyStored() >= 0 || !(handler instanceof IGUndefinedEnergyInterface))) {
                this.connections = (byte)(this.connections | mask);
            }
            return oldConn != this.connections;
        }
        return false;
    }

    public byte getAvailableConnectionByte() {
        byte availableConnections = this.connections;
        int mask = 1;
        for (Direction dir : DirectionUtils.VALUES) {
            if ((availableConnections & mask) == 0) {
                BlockEntity be = this.f_58857_.m_7702_(this.m_58899_().m_121945_(dir));
                if (be instanceof IGEnergyPipeEntity) {
                    availableConnections = (byte)(availableConnections | mask);
                } else {
                    IEnergyStorage handler = this.neighbors.get(dir).getNullable();
                    if (handler != null && handler.getEnergyStored() > 0) {
                        availableConnections = (byte)(availableConnections | mask);
                        continue;
                    }
                }
            }
            mask <<= 1;
        }
        return availableConnections;
    }

    public ConnectionStyle getConnectionStyle(Direction connection) {
        if ((this.connections & 1 << connection.m_122411_()) == 0) {
            return ConnectionStyle.NO_CONNECTION;
        }
        if (this.connections != 3 && this.connections != 12 && this.connections != 48) {
            IEnergyStorage handler = this.neighbors.get(connection).getNullable();
            BlockEntity con = Utils.getExistingTileEntity((Level)this.f_58857_, (BlockPos)this.m_58899_().m_121945_(connection));
            if (handler != null && handler.getEnergyStored() >= 0 & !(con instanceof IGEnergyPipeEntity)) {
                return ConnectionStyle.PLUGGED;
            }
            return ConnectionStyle.FLANGE;
        }
        BlockEntity con = Utils.getExistingTileEntity((Level)this.f_58857_, (BlockPos)this.m_58899_().m_121945_(connection));
        if (con instanceof IGEnergyPipeEntity) {
            IGEnergyPipeEntity pipe = (IGEnergyPipeEntity)con;
            int tileConnections = pipe.connections | 1 << connection.m_122424_().m_122411_();
            if (this.connections == tileConnections) {
                return ConnectionStyle.PLAIN;
            }
        } else {
            IEnergyStorage handler = this.neighbors.get(connection).getNullable();
            if (!(handler == null || handler.getEnergyStored() < 0 && handler instanceof IGUndefinedEnergyInterface)) {
                return ConnectionStyle.PLUGGED;
            }
        }
        return ConnectionStyle.FLANGE;
    }

    public void toggleSide(Direction side) {
        boolean newSideConnected = !this.sideConfig.getBoolean((Object)side);
        this.setSide(side, newSideConnected);
    }

    public void setSide(Direction side, boolean connectable) {
        this.setSide(side, connectable, true);
    }

    public void setSide(Direction side, boolean connectable, boolean firstPipe) {
        this.sideConfig.put((Object)side, connectable);
        if (connectable) {
            this.setValidHandler(side);
        } else {
            this.invalidateHandler(side);
        }
        this.m_6596_();
        if (firstPipe) {
            BlockEntity neighborTile = this.f_58857_.m_7702_(this.m_58899_().m_121945_(side));
            if (neighborTile instanceof IGEnergyPipeEntity) {
                ((IGEnergyPipeEntity)neighborTile).setSide(side.m_122424_(), connectable, false);
            }
            this.updateConnectionByte(side);
        }
        this.f_58857_.m_7696_(this.m_58899_(), this.m_58900_().m_60734_(), 0, 0);
    }

    public boolean m_7531_(int id, int arg) {
        if (id == 0) {
            this.markContainingBlockForUpdate(null);
            return true;
        }
        return false;
    }

    public VoxelShape getCollisionShape(CollisionContext ctx) {
        return SHAPES.get((Object)new BoundingBoxKey(false, this));
    }

    public VoxelShape getSelectionShape(@Nullable CollisionContext ctx) {
        boolean hammer = ctx != null && ctx.m_7142_(IEItems.Tools.HAMMER.get());
        return SHAPES.get((Object)new BoundingBoxKey(hammer, this));
    }

    private static List<AABB> getBoxes(BoundingBoxKey key) {
        double[] dArray;
        ArrayList list = Lists.newArrayList();
        if (!key.showToolView && key.hasCover) {
            list.add(new AABB(0.0, 0.0, 0.0, 1.0, 1.0, 1.0).m_82400_(-0.03125));
            return list;
        }
        byte availableConnections = key.availableConnections;
        byte activeConnections = key.connections;
        if (key.hasCover) {
            double[] dArray2 = new double[6];
            dArray2[0] = 0.002;
            dArray2[1] = 0.998;
            dArray2[2] = 0.002;
            dArray2[3] = 0.998;
            dArray2[4] = 0.002;
            dArray = dArray2;
            dArray2[5] = 0.998;
        } else {
            double[] dArray3 = new double[6];
            dArray3[0] = 0.25;
            dArray3[1] = 0.75;
            dArray3[2] = 0.25;
            dArray3[3] = 0.75;
            dArray3[4] = 0.25;
            dArray = dArray3;
            dArray3[5] = 0.75;
        }
        double[] baseAABB = dArray;
        for (Direction d : DirectionUtils.VALUES) {
            int i = d.m_122411_();
            if ((availableConnections & 1) == 1 && ((activeConnections & 1) == 1 || key.showToolView)) {
                list.add(new AABB(i == 4 ? 0.0 : (i == 5 ? 0.75 : 0.25), i == 0 ? 0.0 : (i == 1 ? 0.75 : 0.25), i == 2 ? 0.0 : (i == 3 ? 0.75 : 0.25), i == 4 ? 0.25 : (i == 5 ? 1.0 : 0.75), i == 0 ? 0.25 : (i == 1 ? 1.0 : 0.75), i == 2 ? 0.25 : (i == 3 ? 1.0 : 0.75)));
                if (key.connectionStyles.get(d) == ConnectionStyle.FLANGE) {
                    list.add(new AABB(i == 4 ? 0.0 : (i == 5 ? 0.875 : 0.21875), i == 0 ? 0.0 : (i == 1 ? 0.875 : 0.21875), i == 2 ? 0.0 : (i == 3 ? 0.875 : 0.21875), i == 4 ? 0.125 : (i == 5 ? 1.0 : 0.78125), i == 0 ? 0.125 : (i == 1 ? 1.0 : 0.78125), i == 2 ? 0.125 : (i == 3 ? 1.0 : 0.78125)));
                }
            }
            availableConnections = (byte)(availableConnections >> 1);
            activeConnections = (byte)(activeConnections >> 1);
        }
        list.add(new AABB(baseAABB[4], baseAABB[0], baseAABB[2], baseAABB[5], baseAABB[1], baseAABB[3]));
        return list;
    }

    public int getRenderColour(int tintIndex) {
        return 0xFFFFFF;
    }

    public void dropCover(Player player) {
        ItemEntity entityitem;
        if (!this.f_58857_.f_46443_ && this.hasCover() && this.f_58857_.m_46469_().m_46207_(GameRules.f_46136_) && (entityitem = player.m_36176_(new ItemStack((ItemLike)this.cover), false)) != null) {
            entityitem.m_32061_();
        }
    }

    public boolean interact(Direction side, Player player, InteractionHand hand, ItemStack heldItem, float hitX, float hitY, float hitZ) {
        if (heldItem.m_41619_() && player.m_6144_() && this.hasCover()) {
            if (!player.m_9236_().f_46443_) {
                this.dropCover(player);
                this.cover = Blocks.f_50016_;
                this.markContainingBlockForUpdate(null);
                this.f_58857_.m_7696_(this.m_58899_(), this.m_58900_().m_60734_(), 255, 0);
                this.markChunkDirty();
            }
            return true;
        }
        return !heldItem.m_41619_() && !player.m_6144_() ? this.setColorOrCoverFrom(heldItem, player) : false;
    }

    private boolean setColorOrCoverFrom(ItemStack heldItem, Player player) {
        Predicate<Block> func;
        DyeColor heldDye = Utils.getDye((ItemStack)heldItem);
        if (heldDye != null) {
            if (!player.m_9236_().f_46443_) {
                this.color = heldDye;
                this.markChunkDirty();
                this.markContainingBlockForUpdate(null);
                this.f_58857_.m_7696_(this.m_58899_(), this.m_58900_().m_60734_(), 255, 0);
            }
            return true;
        }
        Block heldBlock = Block.m_49814_((Item)heldItem.m_41720_());
        if (heldBlock == Blocks.f_50016_) {
            return false;
        }
        Iterator<Predicate<Block>> var5 = validPipeCovers.iterator();
        do {
            if (var5.hasNext()) continue;
            return false;
        } while (!(func = var5.next()).test(heldBlock) || this.cover == heldBlock);
        if (!player.m_9236_().f_46443_) {
            this.dropCover(player);
            this.cover = heldBlock;
            this.markChunkDirty();
            if (!player.m_150110_().f_35937_) {
                heldItem.m_41774_(1);
            }
            this.markContainingBlockForUpdate(null);
            this.f_58857_.m_7696_(this.m_58899_(), this.m_58900_().m_60734_(), 255, 0);
        }
        return true;
    }

    public boolean hammerUseSide(Direction side, Player player, InteractionHand hand, Vec3 hitVec) {
        if (this.f_58857_.f_46443_) {
            return true;
        }
        hitVec = hitVec.m_82546_(Vec3.m_82528_((Vec3i)this.f_58858_));
        Direction fd = side;
        List<AABB> boxes = IGEnergyPipeEntity.getBoxes(new BoundingBoxKey(true, this));
        block0: for (AABB box : boxes) {
            if (!box.m_82400_(0.002).m_82390_(hitVec)) continue;
            for (Direction d : DirectionUtils.VALUES) {
                Vec3 testVec = new Vec3(0.5 + 0.5 * (double)d.m_122429_(), 0.5 + 0.5 * (double)d.m_122430_(), 0.5 + 0.5 * (double)d.m_122431_());
                if (!box.m_82400_(0.002).m_82390_(testVec)) continue;
                fd = d;
                break block0;
            }
        }
        if (fd != null) {
            this.toggleSide(fd);
            this.markContainingBlockForUpdate(null);
            indirectConnections.clearDimension(this.f_58857_);
            return true;
        }
        return false;
    }

    public void onBEPlaced(BlockPlaceContext ctx) {
        Level level = ctx.m_43725_();
        if (!level.f_46443_) {
            if (ctx.m_43723_() != null) {
                InteractionHand otherHand = ctx.m_43724_() == InteractionHand.MAIN_HAND ? InteractionHand.OFF_HAND : InteractionHand.MAIN_HAND;
                this.setColorOrCoverFrom(ctx.m_43723_().m_21120_(otherHand), ctx.m_43723_());
            }
            BlockPos pos = ctx.m_8083_();
            for (Direction dir : Direction.values()) {
                BlockEntity var9 = level.m_7702_(pos.m_121945_(dir));
                if (!(var9 instanceof IGEnergyPipeEntity)) continue;
                IGEnergyPipeEntity neighborPipe = (IGEnergyPipeEntity)var9;
                if (neighborPipe.color == this.color && neighborPipe.sideConfig.getBoolean((Object)dir.m_122424_())) continue;
                this.setSide(dir, false);
            }
        }
    }

    public boolean hasOutputConnection(Direction side) {
        return this.sideConfig.getBoolean((Object)side);
    }

    @SubscribeEvent
    public static void onWorldUnload(LevelEvent.Unload ev) {
        LevelAccessor var2;
        if (!ev.getLevel().m_5776_() && (var2 = ev.getLevel()) instanceof Level) {
            Level level = (Level)var2;
            indirectConnections.clearDimension(level);
        }
    }

    @Nullable
    public DyeColor getColor() {
        return this.color;
    }

    static class PipeEnergyHandler
    implements IEnergyStorage {
        private static final Random CURRENT_TICK_RANDOM = new Random();
        IGEnergyPipeEntity pipe;
        Direction facing;

        public PipeEnergyHandler(IGEnergyPipeEntity pipe, Direction facing) {
            this.pipe = pipe;
            this.facing = facing;
        }

        public int receiveEnergy(int maxReceive, boolean simulate) {
            if (maxReceive <= 0) {
                return 0;
            }
            Set<DirectionalEnergyOutput> outputList = IGEnergyPipeEntity.getConnectedEnergyHandlers(this.pipe.m_58899_(), this.pipe.f_58857_);
            if (outputList.isEmpty()) {
                return 0;
            }
            BlockPos sourcePos = new BlockPos((Vec3i)this.pipe.m_58899_().m_121945_(this.facing));
            int sum = 0;
            HashMap<DirectionalEnergyOutput, Integer> sorting = new HashMap<DirectionalEnergyOutput, Integer>();
            for (DirectionalEnergyOutput output : outputList) {
                BlockPos outputPos = output.containingTile().m_58899_();
                if (outputPos.equals((Object)sourcePos) || !this.pipe.f_58857_.m_46805_(outputPos) || this.pipe.equals(output.containingTile()) || !output.output().canReceive()) continue;
                int transferableAmount = this.getTransferableAmount(output.containingTile());
                int amountToTry = Math.min(transferableAmount, maxReceive);
                int accepted = 0;
                if (output.limitVoltage()) {
                    accepted = output.output().receiveEnergy(amountToTry, true);
                }
                if (accepted <= 0) continue;
                sorting.put(output, accepted);
                sum += accepted;
            }
            int energyTransferred = 0;
            for (DirectionalEnergyOutput output : sorting.keySet()) {
                int amount = (Integer)sorting.get(output);
                if (sum > maxReceive) {
                    int transferableAmount = this.getTransferableAmount(output.containingTile());
                    int amountToTransfer = Math.min(transferableAmount, maxReceive - energyTransferred);
                    float priority = (float)amount / (float)sum;
                    amount = (int)Math.ceil(Mth.m_14036_((float)amount, (float)1.0f, (float)Math.min((float)maxReceive * priority, (float)amountToTransfer)));
                    amount = Math.min(amount, maxReceive - energyTransferred);
                }
                int transferred = 0;
                if (output.limitVoltage()) {
                    transferred = output.output().receiveEnergy(amount, simulate);
                }
                energyTransferred += transferred;
                if ((maxReceive -= transferred) > 0) continue;
                break;
            }
            return energyTransferred;
        }

        private int getTransferableAmount(BlockEntity target) {
            Block block = target.m_58900_().m_60734_();
            if (block instanceof IGEnergyPipe) {
                IGEnergyPipe cable = (IGEnergyPipe)block;
                return this.pipe.getTransferableAmount(cable);
            }
            return 32768;
        }

        public int extractEnergy(int maxExtract, boolean simulate) {
            if (maxExtract <= 0) {
                return 0;
            }
            Level world = this.pipe.getLevelNonnull();
            ArrayList<DirectionalEnergyOutput> outputList = new ArrayList<DirectionalEnergyOutput>(IGEnergyPipeEntity.getConnectedEnergyHandlers(this.pipe.m_58899_(), world));
            BlockPos sourcePos = new BlockPos((Vec3i)this.pipe.m_58899_().m_121945_(this.facing));
            outputList.removeIf(output -> sourcePos.equals((Object)output.containingTile().m_58899_()));
            if (outputList.isEmpty()) {
                return 0;
            }
            CURRENT_TICK_RANDOM.setSeed(HashCommon.mix((long)world.m_46467_()));
            int chosen = outputList.size() == 1 ? 0 : CURRENT_TICK_RANDOM.nextInt(outputList.size());
            DirectionalEnergyOutput output2 = (DirectionalEnergyOutput)outputList.get(chosen);
            if (!output2.output().canExtract()) {
                return 0;
            }
            int available = output2.output().extractEnergy(maxExtract, true);
            BlockEntity extractingBE = SafeChunkUtils.getSafeBE((LevelAccessor)world, (BlockPos)this.pipe.m_58899_().m_121945_(this.facing));
            int limit = this.getTransferableAmount(extractingBE);
            int actualExtract = Math.min(limit, Math.min(available, maxExtract));
            return output2.output().extractEnergy(actualExtract, simulate);
        }

        public int getEnergyStored() {
            return 0;
        }

        public int getMaxEnergyStored() {
            return Integer.MAX_VALUE;
        }

        public boolean canExtract() {
            return true;
        }

        public boolean canReceive() {
            return true;
        }
    }

    public static enum ConnectionStyle {
        NO_CONNECTION,
        PLAIN,
        PLUGGED,
        FLANGE;

    }

    private static class BoundingBoxKey {
        private final boolean showToolView;
        private final byte connections;
        private final byte availableConnections;
        private final boolean hasCover;
        private final Map<Direction, ConnectionStyle> connectionStyles = new EnumMap<Direction, ConnectionStyle>(Direction.class);

        private BoundingBoxKey(boolean showToolView, IGEnergyPipeEntity te) {
            this.showToolView = showToolView;
            this.connections = te.connections;
            this.availableConnections = te.getAvailableConnectionByte();
            this.hasCover = te.hasCover();
            for (Direction d : DirectionUtils.VALUES) {
                this.connectionStyles.put(d, te.getConnectionStyle(d));
            }
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o != null && this.getClass() == o.getClass()) {
                BoundingBoxKey that = (BoundingBoxKey)o;
                return this.showToolView == that.showToolView && this.connections == that.connections && this.availableConnections == that.availableConnections && this.hasCover == that.hasCover && this.connectionStyles.equals(that.connectionStyles);
            }
            return false;
        }

        public int hashCode() {
            return Objects.hash(this.showToolView, this.connections, this.availableConnections, this.hasCover, this.connectionStyles);
        }
    }

    public record DirectionalEnergyOutput(IEnergyStorage output, Direction direction, BlockEntity containingTile) {
        boolean limitVoltage() {
            BlockEntity var2 = this.containingTile;
            if (var2 instanceof IEnergyPipe) {
                IEnergyPipe pipe = (IEnergyPipe)var2;
                return pipe.hasVoltageLimit();
            }
            return true;
        }
    }
}

