/*
 * Decompiled with CFR 0.152.
 */
package com.igteam.immersivegeology.common.block.entity.cable;

import com.igteam.immersivegeology.common.block.entity.cable.IGEnergyPipeEntity;
import java.util.HashMap;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Stream;
import net.minecraftforge.fml.InterModComms;

public class IGIMCHandler {
    private static final HashMap<String, Consumer<InterModComms.IMCMessage>> MESSAGE_HANDLERS = new HashMap();

    public static void init() {
        MESSAGE_HANDLERS.put("energypipe_cover", imcMessage -> {
            Predicate func = (Predicate)imcMessage.messageSupplier().get();
            IGEnergyPipeEntity.validPipeCovers.add(func);
        });
        MESSAGE_HANDLERS.put("energypipe_cover_climb", imcMessage -> {
            Predicate func = (Predicate)imcMessage.messageSupplier().get();
            IGEnergyPipeEntity.climbablePipeCovers.add(func);
        });
    }

    public static void handleIMCMessages(Stream<InterModComms.IMCMessage> messages) {
        messages.forEach(message -> {
            if (MESSAGE_HANDLERS.containsKey(message.method())) {
                Consumer<InterModComms.IMCMessage> handler = MESSAGE_HANDLERS.get(message.method());
                handler.accept((InterModComms.IMCMessage)message);
            }
        });
    }
}

