/*
 * Decompiled with CFR 0.152.
 */
package com.igteam.immersivegeology.common.block.entity.vent;

import blusunrize.immersiveengineering.api.utils.CapabilityReference;
import blusunrize.immersiveengineering.common.blocks.IEBaseBlockEntity;
import blusunrize.immersiveengineering.common.blocks.ticking.IEClientTickableBE;
import blusunrize.immersiveengineering.common.blocks.ticking.IEServerTickableBE;
import blusunrize.immersiveengineering.common.util.Utils;
import com.igteam.immersivegeology.common.block.helper.IGBlockType;
import com.igteam.immersivegeology.core.material.data.enums.ChemicalEnum;
import com.igteam.immersivegeology.core.material.helper.flags.BlockCategoryFlags;
import com.igteam.immersivegeology.core.material.helper.material.MaterialInterface;
import com.igteam.immersivegeology.core.material.helper.material.MaterialTexture;
import com.igteam.immersivegeology.core.registration.IGRegistrationHolder;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.Lazy;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidTank;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class IGHydroVentEntity
extends IEBaseBlockEntity
implements ICapabilityProvider,
IEServerTickableBE,
IEClientTickableBE {
    public final FluidTank tank = new FluidTank(250);
    CapabilityReference<IFluidHandler> ventOutput;
    private final LazyOptional<IFluidHandler> holder = LazyOptional.of(() -> this.tank);
    private final Lazy<Fluid> ventType;
    int tick_count = 0;
    Random rand = new Random();

    public IGHydroVentEntity(BlockPos pos, BlockState state) {
        super(IGHydroVentEntity.resolveEntityType(state), pos, state);
        this.ventType = () -> {
            Fluid fluid;
            Block patt2700$temp = state.m_60734_();
            if (patt2700$temp instanceof IGBlockType) {
                IGBlockType type = (IGBlockType)patt2700$temp;
                fluid = type.getMaterial(MaterialTexture.base).getFluid(BlockCategoryFlags.FLUID);
            } else {
                fluid = null;
            }
            return fluid;
        };
        this.ventOutput = CapabilityReference.forNeighbor((BlockEntity)this, (Capability)ForgeCapabilities.FLUID_HANDLER, (Direction)Direction.UP);
    }

    private static BlockEntityType<?> resolveEntityType(BlockState state) {
        Block block = state.m_60734_();
        if (block instanceof IGBlockType) {
            IGBlockType ventBlock = (IGBlockType)block;
            MaterialInterface<?> material = ventBlock.getMaterial(MaterialTexture.base);
            String registryKey = BlockCategoryFlags.HYDROVENT.getRegistryKey(material);
            return IGRegistrationHolder.getTE.apply(registryKey);
        }
        String fallbackKey = BlockCategoryFlags.HYDROVENT.getRegistryKey(ChemicalEnum.SulfurDioxde);
        return IGRegistrationHolder.getTE.apply(fallbackKey);
    }

    public void invalidateCaps() {
        super.invalidateCaps();
    }

    public void readCustomNBT(CompoundTag compoundTag, boolean b) {
    }

    public void writeCustomNBT(CompoundTag compoundTag, boolean b) {
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> capability, @Nullable Direction facing) {
        return capability == ForgeCapabilities.FLUID_HANDLER && (facing == null || facing.equals((Object)Direction.UP)) ? this.holder.cast() : super.getCapability(capability, facing);
    }

    public void tickServer() {
        boolean update = false;
        ++this.tick_count;
        if (this.tank.getFluidAmount() < 200 && this.tick_count % 10 == 0) {
            if (this.ventType.get() == null) {
                return;
            }
            this.tank.fill(new FluidStack((Fluid)this.ventType.get(), 10), IFluidHandler.FluidAction.EXECUTE);
            this.tick_count = 0;
        }
        if (this.tank.getFluidAmount() > 0) {
            int accepted;
            FluidStack drained;
            int out = Math.min(1000, this.tank.getFluidAmount());
            IFluidHandler handler = (IFluidHandler)this.ventOutput.getNullable();
            if (handler != null && !(drained = this.tank.drain(accepted = handler.fill(Utils.copyFluidStackWithAmount((FluidStack)this.tank.getFluid(), (int)out, (boolean)false), IFluidHandler.FluidAction.SIMULATE), IFluidHandler.FluidAction.EXECUTE)).isEmpty()) {
                handler.fill(drained, IFluidHandler.FluidAction.EXECUTE);
                update = true;
            }
        }
        if (update) {
            this.m_6596_();
            this.markContainingBlockForUpdate(null);
        }
    }

    public void tickClient() {
        ++this.tick_count;
        Level level = this.m_58904_();
        if (level != null && this.tick_count % 4 == 0) {
            boolean canSmoke;
            BlockState state = level.m_8055_(this.m_58899_().m_7494_());
            boolean bl = canSmoke = state.m_60795_() || state.m_60713_(Blocks.f_49990_);
            if (!canSmoke) {
                return;
            }
            level.m_7106_((ParticleOptions)ParticleTypes.f_123777_, (double)((float)this.m_58899_().m_123341_() + 0.5f + this.rand.nextFloat(-0.25f, 0.25f)), (double)((float)this.m_58899_().m_123342_() + 1.05f), (double)((float)this.m_58899_().m_123343_() + 0.5f + this.rand.nextFloat(-0.25f, 0.25f)), 0.0, (double)0.1f, 0.0);
            this.tick_count = 0;
        }
    }
}

