/*
 * Decompiled with CFR 0.152.
 */
package com.igteam.immersivegeology.common.block.multiblocks.logic;

import blusunrize.immersiveengineering.api.crafting.MultiblockRecipe;
import blusunrize.immersiveengineering.api.energy.AveragingEnergyStorage;
import blusunrize.immersiveengineering.api.multiblocks.blocks.component.IClientTickableComponent;
import blusunrize.immersiveengineering.api.multiblocks.blocks.component.IServerTickableComponent;
import blusunrize.immersiveengineering.api.multiblocks.blocks.component.RedstoneControl;
import blusunrize.immersiveengineering.api.multiblocks.blocks.env.IInitialMultiblockContext;
import blusunrize.immersiveengineering.api.multiblocks.blocks.env.IMultiblockContext;
import blusunrize.immersiveengineering.api.multiblocks.blocks.env.IMultiblockLevel;
import blusunrize.immersiveengineering.api.multiblocks.blocks.logic.IMultiblockLogic;
import blusunrize.immersiveengineering.api.multiblocks.blocks.util.CapabilityPosition;
import blusunrize.immersiveengineering.api.multiblocks.blocks.util.MBInventoryUtils;
import blusunrize.immersiveengineering.api.multiblocks.blocks.util.MultiblockFace;
import blusunrize.immersiveengineering.api.multiblocks.blocks.util.RelativeBlockFace;
import blusunrize.immersiveengineering.api.multiblocks.blocks.util.ShapeType;
import blusunrize.immersiveengineering.api.multiblocks.blocks.util.StoredCapability;
import blusunrize.immersiveengineering.common.blocks.multiblocks.process.MultiblockProcess;
import blusunrize.immersiveengineering.common.blocks.multiblocks.process.MultiblockProcessInWorld;
import blusunrize.immersiveengineering.common.blocks.multiblocks.process.MultiblockProcessor;
import blusunrize.immersiveengineering.common.blocks.multiblocks.process.ProcessContext;
import blusunrize.immersiveengineering.common.util.DroppingMultiblockOutput;
import blusunrize.immersiveengineering.common.util.inventory.InsertOnlyInventory;
import com.igteam.immersivegeology.common.block.multiblocks.logic.helper.IGMultiblockState;
import com.igteam.immersivegeology.common.block.multiblocks.recipe.BallmillRecipe;
import com.igteam.immersivegeology.common.block.multiblocks.shapes.BallmillShape;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.items.IItemHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BallmillLogic
implements IMultiblockLogic<State>,
IServerTickableComponent<State>,
IClientTickableComponent<State> {
    public static final BlockPos REDSTONE_IN = new BlockPos(4, 1, 3);
    private static final int ENERGY_CAPACITY = 64000;
    private static final Set<CapabilityPosition> ENERGY_INPUTS = Set.of(new CapabilityPosition(0, 1, 3, RelativeBlockFace.UP));
    private static final MultiblockFace OUTPUT_POS = new MultiblockFace(2, 0, 4, RelativeBlockFace.FRONT);
    private static final MultiblockFace INPUT_POS = new MultiblockFace(0, 0, 1, RelativeBlockFace.FRONT);
    private static final CapabilityPosition ITEM_OUTPUT_CAP = CapabilityPosition.opposing((MultiblockFace)OUTPUT_POS);
    private static final CapabilityPosition ITEM_INPUT_CAP = new CapabilityPosition(0, 0, 1, RelativeBlockFace.RIGHT);
    public static final int ENERGY_CONSUMPTION_RATE = 80;

    public void tickClient(IMultiblockContext<State> context) {
        State state = (State)context.getState();
        if (state.renderAsActive) {
            float rot = state.rotation;
            state.rotation = (float)(((double)rot + 2.5) % 360.0);
        }
    }

    public void tickServer(IMultiblockContext<State> context) {
        State state = (State)context.getState();
        boolean wasActive = state.renderAsActive;
        state.renderAsActive = state.processor.tickServer((ProcessContext)state, context.getLevel(), state.rsState.isEnabled(context));
        if (wasActive != state.renderAsActive) {
            context.requestMasterBESync();
        }
    }

    public State createInitialState(IInitialMultiblockContext<State> capability) {
        return new State(capability);
    }

    public void dropExtraItems(State state, Consumer<ItemStack> drop) {
        MBInventoryUtils.dropItems((IItemHandler)state.getInventory(), drop);
    }

    public <T> LazyOptional<T> getCapability(IMultiblockContext<State> ctx, CapabilityPosition position, Capability<T> cap) {
        State state = (State)ctx.getState();
        if (cap == ForgeCapabilities.ENERGY && (position.side() == null || ENERGY_INPUTS.contains(position))) {
            return state.energyCap.cast(ctx);
        }
        if (cap == ForgeCapabilities.ITEM_HANDLER && ITEM_INPUT_CAP.equals((Object)position)) {
            return state.insertionHandler.cast(ctx);
        }
        return LazyOptional.empty();
    }

    public Function<BlockPos, VoxelShape> shapeGetter(ShapeType shapeType) {
        return BallmillShape.GETTER;
    }

    public static class State
    implements IGMultiblockState,
    ProcessContext.ProcessContextInWorld<BallmillRecipe> {
        public final AveragingEnergyStorage energy = new AveragingEnergyStorage(64000);
        public final RedstoneControl.RSState rsState = RedstoneControl.RSState.enabledByDefault();
        private final DroppingMultiblockOutput output;
        private final StoredCapability<IItemHandler> insertionHandler;
        private float rotation = 0.0f;
        private boolean renderAsActive;
        private final StoredCapability<IEnergyStorage> energyCap = new StoredCapability((Object)this.energy);
        private final MultiblockProcessor<BallmillRecipe, ProcessContext.ProcessContextInWorld<BallmillRecipe>> processor;
        Supplier<@Nullable Level> levelGetter;

        /*
         * Issues handling annotations - annotations may be inaccurate
         */
        public State(IInitialMultiblockContext<State> ctx) {
            this.output = new DroppingMultiblockOutput(OUTPUT_POS, ctx);
            this.processor = new MultiblockProcessor(64, 0.0f, 8, ctx.getMarkDirtyRunnable(), (arg_0, arg_1) -> BallmillRecipe.RECIPES.getById(arg_0, arg_1));
            final @Nullable Supplier levelGetter = ctx.levelSupplier();
            Runnable markDirty = ctx.getMarkDirtyRunnable();
            Runnable sync = ctx.getSyncRunnable();
            Runnable changedAndSync = () -> {
                markDirty.run();
                sync.run();
            };
            this.insertionHandler = new StoredCapability((Object)new InsertOnlyInventory(){

                protected ItemStack insert(ItemStack toInsert, boolean simulate) {
                    ItemStack stack = toInsert.m_41777_();
                    BallmillRecipe recipe = BallmillRecipe.findRecipe((Level)levelGetter.get(), stack);
                    if (recipe == null) {
                        return stack;
                    }
                    MultiblockProcessInWorld process = new MultiblockProcessInWorld((MultiblockRecipe)recipe, stack);
                    if (processor.addProcessToQueue((MultiblockProcess)process, (Level)levelGetter.get(), simulate)) {
                        stack.m_41774_(recipe.itemIn.getCount());
                    }
                    return stack;
                }
            });
        }

        public void doProcessOutput(ItemStack result, IMultiblockLevel level) {
            this.output.insertOrDrop(result, level);
        }

        public void writeSaveNBT(CompoundTag nbt) {
            nbt.m_128365_("energy", this.energy.serializeNBT());
            nbt.m_128365_("processor", this.processor.toNBT());
        }

        public boolean shouldRenderActive() {
            return this.renderAsActive;
        }

        public void readSaveNBT(CompoundTag nbt) {
            this.energy.deserializeNBT(nbt.m_128423_("energy"));
            this.processor.fromNBT(nbt.m_128423_("processor"), MultiblockProcessInWorld::new);
        }

        public void writeSyncNBT(CompoundTag nbt) {
            this.writeSaveNBT(nbt);
            nbt.m_128379_("renderActive", this.renderAsActive);
        }

        public void readSyncNBT(CompoundTag nbt) {
            this.readSaveNBT(nbt);
            this.renderAsActive = nbt.m_128471_("renderActive");
        }

        public AveragingEnergyStorage getEnergy() {
            return this.energy;
        }

        public float getRotation() {
            return this.rotation;
        }

        @Override
        public void invalidate(@NotNull IMultiblockContext<?> context) {
            this.energyCap.get(context).invalidate();
            this.insertionHandler.get(context).invalidate();
        }
    }
}

