/*
 * Decompiled with CFR 0.152.
 */
package com.igteam.immersivegeology.common.block.multiblocks.logic;

import blusunrize.immersiveengineering.api.crafting.MultiblockRecipe;
import blusunrize.immersiveengineering.api.energy.AveragingEnergyStorage;
import blusunrize.immersiveengineering.api.multiblocks.blocks.component.IClientTickableComponent;
import blusunrize.immersiveengineering.api.multiblocks.blocks.component.IServerTickableComponent;
import blusunrize.immersiveengineering.api.multiblocks.blocks.component.RedstoneControl;
import blusunrize.immersiveengineering.api.multiblocks.blocks.env.IInitialMultiblockContext;
import blusunrize.immersiveengineering.api.multiblocks.blocks.env.IMultiblockContext;
import blusunrize.immersiveengineering.api.multiblocks.blocks.env.IMultiblockLevel;
import blusunrize.immersiveengineering.api.multiblocks.blocks.logic.IMultiblockLogic;
import blusunrize.immersiveengineering.api.multiblocks.blocks.util.CapabilityPosition;
import blusunrize.immersiveengineering.api.multiblocks.blocks.util.MBInventoryUtils;
import blusunrize.immersiveengineering.api.multiblocks.blocks.util.MultiblockFace;
import blusunrize.immersiveengineering.api.multiblocks.blocks.util.RelativeBlockFace;
import blusunrize.immersiveengineering.api.multiblocks.blocks.util.ShapeType;
import blusunrize.immersiveengineering.api.multiblocks.blocks.util.StoredCapability;
import blusunrize.immersiveengineering.api.utils.CapabilityReference;
import blusunrize.immersiveengineering.client.utils.TextUtils;
import blusunrize.immersiveengineering.common.blocks.multiblocks.logic.interfaces.MBOverlayText;
import blusunrize.immersiveengineering.common.blocks.multiblocks.process.MultiblockProcess;
import blusunrize.immersiveengineering.common.blocks.multiblocks.process.MultiblockProcessInMachine;
import blusunrize.immersiveengineering.common.blocks.multiblocks.process.MultiblockProcessor;
import blusunrize.immersiveengineering.common.blocks.multiblocks.process.ProcessContext;
import blusunrize.immersiveengineering.common.fluids.ArrayFluidHandler;
import blusunrize.immersiveengineering.common.util.DroppingMultiblockOutput;
import blusunrize.immersiveengineering.common.util.Utils;
import blusunrize.immersiveengineering.common.util.inventory.SlotwiseItemHandler;
import blusunrize.immersiveengineering.common.util.inventory.WrappingItemHandler;
import com.igteam.immersivegeology.common.block.multiblocks.logic.helper.IGMultiblockState;
import com.igteam.immersivegeology.common.block.multiblocks.recipe.CentrifugeRecipe;
import com.igteam.immersivegeology.common.block.multiblocks.shapes.CentrifugeShape;
import com.igteam.immersivegeology.core.lib.IGLib;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidTank;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CentrifugeLogic
implements IMultiblockLogic<State>,
IServerTickableComponent<State>,
IClientTickableComponent<State>,
MBOverlayText<State> {
    public static final BlockPos REDSTONE_IN = new BlockPos(2, 1, 1);
    private static final int ENERGY_CAPACITY = 32000;
    private static final Set<CapabilityPosition> ENERGY_INPUTS = Set.of(new CapabilityPosition(2, 2, 0, RelativeBlockFace.FRONT), new CapabilityPosition(2, 1, 0, RelativeBlockFace.FRONT));
    private static final CapabilityPosition FLUID_INPUT_CAP = new CapabilityPosition(4, 0, 4, RelativeBlockFace.BACK);
    private static final MultiblockFace OUTPUT_POS = new MultiblockFace(2, 0, -1, RelativeBlockFace.BACK);
    private static final CapabilityPosition ITEM_OUTPUT_CAP = CapabilityPosition.opposing((MultiblockFace)OUTPUT_POS);
    private static final CapabilityPosition FLUID_PRIMARY_OUTPUT_CAP = new CapabilityPosition(0, 2, 0, RelativeBlockFace.UP);
    private static final CapabilityPosition FLUID_SECONDARY_OUTPUT_CAP = new CapabilityPosition(4, 2, 0, RelativeBlockFace.UP);
    public static final int TANK_VOLUME = 4000;

    public void tickServer(IMultiblockContext<State> context) {
        State state = (State)context.getState();
        if (state.mbLevelGetter == null) {
            state.mbLevelGetter = () -> context.getLevel();
        }
        if (!state.tank.isEmpty()) {
            this.tryRunRecipe(state, context.getLevel().getRawLevel());
        }
        boolean wasActive = state.isActive;
        state.isActive = state.processor.tickServer((ProcessContext)state, context.getLevel(), state.rsState.isEnabled(context));
        if (state.processor.getQueueSize() > 0) {
            context.requestMasterBESync();
        }
        if (wasActive != state.isActive) {
            context.requestMasterBESync();
        }
        if (!state.primary_output_tank.isEmpty()) {
            this.drainOutputTank(context, state.fluidOutputPrimary, state.primary_output_tank);
            context.requestMasterBESync();
        }
        if (!state.secondary_output_tank.isEmpty()) {
            this.drainOutputTank(context, state.fluidOutputSecondary, state.secondary_output_tank);
            context.requestMasterBESync();
        }
    }

    public void dropExtraItems(State state, Consumer<ItemStack> drop) {
        MBInventoryUtils.dropItems((IItemHandler)state.getInventory(), drop);
    }

    private void tryRunRecipe(State state, Level level) {
        if (state.energy.getEnergyStored() <= 0 || state.processor.getQueueSize() >= state.processor.getMaxQueueSize()) {
            return;
        }
        FluidStack input = state.tank.getFluid();
        if (input.isEmpty()) {
            return;
        }
        CentrifugeRecipe recipe = CentrifugeRecipe.findRecipe(level, input);
        if (recipe == null) {
            return;
        }
        MultiblockProcessInMachine process = new MultiblockProcessInMachine((MultiblockRecipe)recipe, new int[0]);
        if (input.isEmpty()) {
            process.setInputTanks(new int[]{0});
        }
        if (state.processor.addProcessToQueue((MultiblockProcess)process, level, true)) {
            state.tank.drain(recipe.fluidIn.getAmount(), IFluidHandler.FluidAction.EXECUTE);
            state.processor.addProcessToQueue((MultiblockProcess)process, level, false);
        }
    }

    private void drainOutputTank(IMultiblockContext<State> context, CapabilityReference<IFluidHandler> outputRef, FluidTank tank) {
        int outSize = Math.min(1000, tank.getFluidAmount());
        FluidStack out = Utils.copyFluidStackWithAmount((FluidStack)tank.getFluid(), (int)outSize, (boolean)false);
        IFluidHandler output = (IFluidHandler)outputRef.getNullable();
        if (output == null) {
            return;
        }
        int accepted = output.fill(out, IFluidHandler.FluidAction.SIMULATE);
        if (accepted > 0) {
            int drained = output.fill(Utils.copyFluidStackWithAmount((FluidStack)out, (int)Math.min(out.getAmount(), accepted), (boolean)false), IFluidHandler.FluidAction.EXECUTE);
            tank.drain(drained, IFluidHandler.FluidAction.EXECUTE);
            context.markMasterDirty();
            context.requestMasterBESync();
        }
    }

    public State createInitialState(IInitialMultiblockContext<State> capability) {
        return new State(capability);
    }

    public <T> LazyOptional<T> getCapability(IMultiblockContext<State> ctx, CapabilityPosition position, Capability<T> cap) {
        State state = (State)ctx.getState();
        if (cap == ForgeCapabilities.ENERGY && (position.side() == null || ENERGY_INPUTS.contains(position))) {
            return state.energyCap.cast(ctx);
        }
        if (cap == ForgeCapabilities.FLUID_HANDLER) {
            if (FLUID_INPUT_CAP.equals((Object)position)) {
                return state.fInputCap.cast(ctx);
            }
            if (FLUID_PRIMARY_OUTPUT_CAP.equals((Object)position)) {
                return state.fPrimaryOutput.cast(ctx);
            }
            if (FLUID_SECONDARY_OUTPUT_CAP.equals((Object)position)) {
                return state.fSecondaryOutput.cast(ctx);
            }
        }
        if (cap == ForgeCapabilities.ITEM_HANDLER && ITEM_OUTPUT_CAP.equals((Object)position)) {
            return state.itemOutputCap.cast(ctx);
        }
        return LazyOptional.empty();
    }

    public Function<BlockPos, VoxelShape> shapeGetter(ShapeType shapeType) {
        return CentrifugeShape.GETTER;
    }

    @Nullable
    public List<Component> getOverlayText(State state, Player player, boolean b) {
        if (Utils.isFluidRelatedItemStack((ItemStack)player.m_21120_(InteractionHand.MAIN_HAND))) {
            return List.of(TextUtils.formatFluidStack((FluidStack)state.tank.getFluid()), TextUtils.formatFluidStack((FluidStack)state.primary_output_tank.getFluid()), TextUtils.formatFluidStack((FluidStack)state.secondary_output_tank.getFluid()), Component.m_237113_((String)("Processes: " + state.processor.getQueueSize())));
        }
        return null;
    }

    public void tickClient(IMultiblockContext<State> context) {
        State state = (State)context.getState();
        float rot = state.rotation;
        if (state.shouldRenderActive()) {
            state.rotation = (float)(((double)rot - 3.5) % 360.0);
        }
    }

    public static class State
    implements IGMultiblockState,
    ProcessContext.ProcessContextInMachine<CentrifugeRecipe> {
        public final AveragingEnergyStorage energy = new AveragingEnergyStorage(32000);
        private final MultiblockProcessor<CentrifugeRecipe, ProcessContext.ProcessContextInMachine<CentrifugeRecipe>> processor;
        public final SlotwiseItemHandler inventory;
        public final RedstoneControl.RSState rsState = RedstoneControl.RSState.enabledByDefault();
        public final FluidTank tank = new FluidTank(4000);
        private final StoredCapability<IFluidHandler> fInputCap;
        private final StoredCapability<IEnergyStorage> energyCap;
        private final DroppingMultiblockOutput output;
        private final StoredCapability<IItemHandler> itemOutputCap;
        private final CapabilityReference<IFluidHandler> fluidOutputPrimary;
        private final CapabilityReference<IFluidHandler> fluidOutputSecondary;
        private final StoredCapability<IFluidHandler> fPrimaryOutput;
        private final StoredCapability<IFluidHandler> fSecondaryOutput;
        public final FluidTank primary_output_tank = new FluidTank(4000);
        public final FluidTank secondary_output_tank = new FluidTank(4000);
        private Supplier<IMultiblockLevel> mbLevelGetter;
        public float rotation;
        public boolean isActive;

        /*
         * Issues handling annotations - annotations may be inaccurate
         */
        public State(IInitialMultiblockContext<State> ctx) {
            @Nullable Supplier getLevel = ctx.levelSupplier();
            this.rotation = 0.0f;
            this.energyCap = new StoredCapability((Object)this.energy);
            this.output = new DroppingMultiblockOutput(OUTPUT_POS, ctx);
            this.processor = new MultiblockProcessor(16, 0.0f, 8, ctx.getMarkDirtyRunnable(), (arg_0, arg_1) -> CentrifugeRecipe.RECIPES.getById(arg_0, arg_1));
            this.inventory = SlotwiseItemHandler.makeWithGroups(List.of(new SlotwiseItemHandler.IOConstraintGroup(SlotwiseItemHandler.IOConstraint.NO_CONSTRAINT, 1)), (Runnable)ctx.getMarkDirtyRunnable());
            Runnable changedAndSync = () -> {
                ctx.getSyncRunnable().run();
                ctx.getMarkDirtyRunnable().run();
            };
            this.itemOutputCap = new StoredCapability((Object)new WrappingItemHandler((IItemHandler)this.inventory, false, true, new WrappingItemHandler.IntRange(0, 1)));
            this.fInputCap = new StoredCapability((Object)new ArrayFluidHandler((IFluidTank)this.tank, true, true, changedAndSync));
            this.fPrimaryOutput = new StoredCapability((Object)new ArrayFluidHandler((IFluidTank)this.primary_output_tank, true, false, changedAndSync));
            this.fSecondaryOutput = new StoredCapability((Object)new ArrayFluidHandler((IFluidTank)this.secondary_output_tank, true, false, changedAndSync));
            this.fluidOutputPrimary = ctx.getCapabilityAt(ForgeCapabilities.FLUID_HANDLER, new MultiblockFace(FLUID_PRIMARY_OUTPUT_CAP.side(), FLUID_PRIMARY_OUTPUT_CAP.posInMultiblock().m_7494_()));
            this.fluidOutputSecondary = ctx.getCapabilityAt(ForgeCapabilities.FLUID_HANDLER, new MultiblockFace(FLUID_SECONDARY_OUTPUT_CAP.side(), FLUID_SECONDARY_OUTPUT_CAP.posInMultiblock().m_7494_()));
            this.isActive = false;
        }

        public void writeSaveNBT(CompoundTag nbt) {
            nbt.m_128365_("energy", this.energy.serializeNBT());
            nbt.m_128365_("processor", this.processor.toNBT());
            nbt.m_128365_("tank", (Tag)this.tank.writeToNBT(new CompoundTag()));
            nbt.m_128365_("primary_output_tank", (Tag)this.primary_output_tank.writeToNBT(new CompoundTag()));
            nbt.m_128365_("secondary_output_tank", (Tag)this.secondary_output_tank.writeToNBT(new CompoundTag()));
            nbt.m_128365_("inventory", this.inventory.serializeNBT());
            nbt.m_128379_("isActive", this.isActive);
        }

        public void readSaveNBT(CompoundTag nbt) {
            this.energy.deserializeNBT(nbt.m_128423_("energy"));
            this.processor.fromNBT(nbt.m_128423_("processor"), MultiblockProcessInMachine::new);
            this.tank.readFromNBT(nbt.m_128469_("tank"));
            this.primary_output_tank.readFromNBT(nbt.m_128469_("primary_output_tank"));
            this.secondary_output_tank.readFromNBT(nbt.m_128469_("secondary_output_tank"));
            this.inventory.deserializeNBT(nbt.m_128469_("inventory"));
            this.isActive = nbt.m_128471_("isActive");
        }

        public void writeSyncNBT(CompoundTag nbt) {
            this.writeSaveNBT(nbt);
        }

        public void readSyncNBT(CompoundTag nbt) {
            this.readSaveNBT(nbt);
        }

        public void onProcessFinish(MultiblockProcess<CentrifugeRecipe, ?> process, Level level) {
            try {
                CentrifugeRecipe recipe = (CentrifugeRecipe)process.getRecipe(level);
                this.primary_output_tank.fill((FluidStack)recipe.primaryFluidOutput.get(), IFluidHandler.FluidAction.EXECUTE);
                this.secondary_output_tank.fill((FluidStack)recipe.secondaryFluidOutput.get(), IFluidHandler.FluidAction.EXECUTE);
            }
            catch (Exception error) {
                IGLib.IG_LOGGER.error("Error: {}", (Object)error.getMessage());
            }
        }

        public int[] getOutputSlots() {
            return new int[]{0};
        }

        public int[] getOutputTanks() {
            return new int[]{1, 2};
        }

        public IFluidTank[] getInternalTanks() {
            return new FluidTank[]{this.tank, this.primary_output_tank, this.secondary_output_tank};
        }

        public IItemHandlerModifiable getInventory() {
            return this.inventory.getRawHandler();
        }

        public AveragingEnergyStorage getEnergy() {
            return this.energy;
        }

        public float getRotation() {
            return this.rotation;
        }

        public boolean shouldRenderActive() {
            return this.isActive;
        }

        @Override
        public void invalidate(@NotNull IMultiblockContext<?> context) {
            this.fPrimaryOutput.get(context).invalidate();
            this.fSecondaryOutput.get(context).invalidate();
            this.itemOutputCap.get(context).invalidate();
            this.fInputCap.get(context).invalidate();
            this.energyCap.get(context).invalidate();
            this.itemOutputCap.get(context).invalidate();
        }
    }
}

