/*
 * Decompiled with CFR 0.152.
 */
package com.igteam.immersivegeology.common.block.multiblocks.logic;

import blusunrize.immersiveengineering.api.crafting.FluidTagInput;
import blusunrize.immersiveengineering.api.crafting.IngredientWithSize;
import blusunrize.immersiveengineering.api.crafting.MultiblockRecipe;
import blusunrize.immersiveengineering.api.energy.AveragingEnergyStorage;
import blusunrize.immersiveengineering.api.multiblocks.blocks.component.IServerTickableComponent;
import blusunrize.immersiveengineering.api.multiblocks.blocks.component.RedstoneControl;
import blusunrize.immersiveengineering.api.multiblocks.blocks.env.IInitialMultiblockContext;
import blusunrize.immersiveengineering.api.multiblocks.blocks.env.IMultiblockBEHelper;
import blusunrize.immersiveengineering.api.multiblocks.blocks.env.IMultiblockContext;
import blusunrize.immersiveengineering.api.multiblocks.blocks.env.IMultiblockLevel;
import blusunrize.immersiveengineering.api.multiblocks.blocks.logic.IMultiblockLogic;
import blusunrize.immersiveengineering.api.multiblocks.blocks.util.CapabilityPosition;
import blusunrize.immersiveengineering.api.multiblocks.blocks.util.MBInventoryUtils;
import blusunrize.immersiveengineering.api.multiblocks.blocks.util.MultiblockFace;
import blusunrize.immersiveengineering.api.multiblocks.blocks.util.RelativeBlockFace;
import blusunrize.immersiveengineering.api.multiblocks.blocks.util.ShapeType;
import blusunrize.immersiveengineering.api.multiblocks.blocks.util.StoredCapability;
import blusunrize.immersiveengineering.api.utils.CapabilityReference;
import blusunrize.immersiveengineering.client.utils.TextUtils;
import blusunrize.immersiveengineering.common.blocks.multiblocks.process.MultiblockProcess;
import blusunrize.immersiveengineering.common.blocks.multiblocks.process.MultiblockProcessInMachine;
import blusunrize.immersiveengineering.common.blocks.multiblocks.process.MultiblockProcessor;
import blusunrize.immersiveengineering.common.blocks.multiblocks.process.ProcessContext;
import blusunrize.immersiveengineering.common.fluids.ArrayFluidHandler;
import blusunrize.immersiveengineering.common.util.Utils;
import blusunrize.immersiveengineering.common.util.inventory.SlotwiseItemHandler;
import blusunrize.immersiveengineering.common.util.inventory.WrappingItemHandler;
import com.igteam.immersivegeology.common.block.multiblocks.logic.helper.IGMultiblockState;
import com.igteam.immersivegeology.common.block.multiblocks.logic.helper.IGPositionalOverlayText;
import com.igteam.immersivegeology.common.block.multiblocks.recipe.ChemicalRecipe;
import com.igteam.immersivegeology.common.block.multiblocks.shapes.ChemicalReactorShape;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidTank;
import net.minecraftforge.items.IItemHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ChemicalReactorLogic
implements IMultiblockLogic<State>,
IGPositionalOverlayText<State>,
IServerTickableComponent<State> {
    public static final BlockPos REDSTONE_IN = new BlockPos(5, 1, 6);
    private static final Set<CapabilityPosition> ENERGY_POS;
    private static final MultiblockFace FLUID_OUTPUT;
    private static final MultiblockFace ITEM_OUTPUT;
    private static final MultiblockFace ITEM_INPUT_OUTPUT;
    private static final CapabilityPosition FLUID_OUTPUT_CAP;
    private static final Set<CapabilityPosition> FLUID_INPUT_CAPS;
    private static final Set<BlockPos> FLUID_INPUTS;
    private static final BlockPos ITEM_INPUT;
    private static final Set<BlockPos> TANK_LEFT_POSITIONS;
    private static final Set<BlockPos> TANK_RIGHT_POSITIONS;
    private static final Set<BlockPos> TANK_BACK_POSITIONS;
    private static final Set<BlockPos> TANK_FRONT_POSITIONS;
    private static final Set<BlockPos> REACTOR_CHAMBER_POSITIONS;
    public static final int ENERGY_CAPACITY = 64000;

    public void dropExtraItems(State state, Consumer<ItemStack> drop) {
        MBInventoryUtils.dropItems((IItemHandler)state.getInventory(), drop);
    }

    public void tickServer(IMultiblockContext<State> ctx) {
        State state = (State)ctx.getState();
        boolean isEnabled = state.rsState.isEnabled(ctx);
        if (isEnabled) {
            ChemicalReactorLogic.insertRecipeToProcess(state, ctx);
        }
        state.processor.tickServer((ProcessContext)state, ctx.getLevel(), state.rsState.isEnabled(ctx));
        if (state.tanks.output.getFluid().getAmount() > 0) {
            this.drainOutputTank(state, ctx, state.fluidOutput);
        }
        if (!state.rsState.isEnabled(ctx)) {
            ItemStack stack;
            ItemStack itemStack = state.inventory.getStackInSlot(0);
            if (!itemStack.m_41619_() && state.processor.getQueue().stream().noneMatch(q -> {
                ChemicalRecipe rec = (ChemicalRecipe)q.getRecipe(ctx.getLevel().getRawLevel());
                if (rec != null) {
                    return rec.itemInput.testIgnoringSize(itemStack);
                }
                return true;
            }) && (stack = Utils.insertStackIntoInventory(state.input_output, (ItemStack)itemStack.m_255036_(1), (boolean)true)).m_41619_()) {
                Utils.insertStackIntoInventory(state.input_output, (ItemStack)itemStack.m_255036_(1), (boolean)false);
                itemStack.m_41774_(1);
            }
            if (state.processor.getQueueSize() > 0) {
                state.clearProcessor();
            }
        }
        ctx.requestMasterBESync();
    }

    private static void insertRecipeToProcess(State state, IMultiblockContext<State> ctx) {
        IMultiblockLevel mbLevel = ctx.getLevel();
        Level level = mbLevel.getRawLevel();
        ChemicalReactorTanks fluidTanks = state.tanks;
        ChemicalRecipe recipe = state.getRecipeForInputs(level);
        if (recipe != null) {
            boolean hasInputForNewRecipe;
            MultiblockProcessInMachine process = new MultiblockProcessInMachine((MultiblockRecipe)recipe, new int[]{0});
            process.setInputAmounts(new int[]{recipe.itemInput.getCount()});
            int size = (fluidTanks.leftInput.isEmpty() ? 0 : 1) + (fluidTanks.backInput.isEmpty() ? 0 : 1) + (fluidTanks.rightInput.isEmpty() ? 0 : 1);
            int[] intArray = new int[size];
            int index = 0;
            if (!fluidTanks.leftInput.isEmpty()) {
                intArray[index++] = 0;
            }
            if (!fluidTanks.backInput.isEmpty()) {
                intArray[index++] = 1;
            }
            if (!fluidTanks.rightInput.isEmpty()) {
                intArray[index] = 2;
            }
            ItemStack inputStack = state.inventory.getStackInSlot(0).m_41777_();
            int recipeInputRequirements = 0;
            List processQueue = state.processor.getQueue();
            for (MultiblockProcess p : processQueue) {
                IngredientWithSize input;
                ChemicalRecipe checkRecipe = (ChemicalRecipe)p.getRecipe(level);
                if (checkRecipe == null || !(input = checkRecipe.itemInput).testIgnoringSize(inputStack)) continue;
                recipeInputRequirements += input.getCount();
            }
            boolean bl = hasInputForNewRecipe = inputStack.m_41613_() >= recipeInputRequirements + recipe.itemInput.getCount();
            if (hasInputForNewRecipe) {
                process.setInputTanks(intArray);
                if (state.processor.addProcessToQueue((MultiblockProcess)process, level, true)) {
                    state.processor.addProcessToQueue((MultiblockProcess)process, level, false);
                    ctx.markMasterDirty();
                }
            }
        } else if (state.processor.getQueueSize() > 0) {
            state.clearProcessor();
        }
    }

    public State createInitialState(IInitialMultiblockContext<State> capability) {
        return new State(capability);
    }

    public <T> LazyOptional<T> getCapability(IMultiblockContext<State> ctx, CapabilityPosition position, Capability<T> cap) {
        State state = (State)ctx.getState();
        if (cap == ForgeCapabilities.ENERGY && (position.side() == null || ENERGY_POS.contains(position))) {
            return state.energyCap.cast(ctx);
        }
        if (cap == ForgeCapabilities.FLUID_HANDLER) {
            if (FLUID_INPUT_CAPS.contains(position) && position.side() != null) {
                if (position.side().equals((Object)RelativeBlockFace.LEFT)) {
                    return state.inputCapRight.cast(ctx);
                }
                if (position.side().equals((Object)RelativeBlockFace.RIGHT)) {
                    return state.inputCapLeft.cast(ctx);
                }
                if (position.side().equals((Object)RelativeBlockFace.FRONT)) {
                    return state.inputCapBack.cast(ctx);
                }
            }
            if (FLUID_OUTPUT_CAP.equals((Object)position)) {
                return state.outputCap.cast(ctx);
            }
        }
        if (cap == ForgeCapabilities.ITEM_HANDLER) {
            if (position.posInMultiblock().equals((Object)ITEM_INPUT)) {
                return state.itemInputCap.cast(ctx);
            }
            if (position.posInMultiblock().equals((Object)ITEM_OUTPUT.posInMultiblock()) && position.side() == ITEM_OUTPUT.face()) {
                return state.outputHandler.cast(ctx);
            }
        }
        return LazyOptional.empty();
    }

    private void drainOutputTank(State state, IMultiblockContext<State> context, CapabilityReference<IFluidHandler> outputRef) {
        int outSize = Math.min(1000, state.tanks.output.getFluidAmount());
        FluidStack out = Utils.copyFluidStackWithAmount((FluidStack)state.tanks.output.getFluid(), (int)outSize, (boolean)false);
        IFluidHandler output = (IFluidHandler)outputRef.getNullable();
        if (output == null) {
            return;
        }
        int accepted = output.fill(out, IFluidHandler.FluidAction.SIMULATE);
        if (accepted > 0) {
            int drained = output.fill(Utils.copyFluidStackWithAmount((FluidStack)out, (int)Math.min(out.getAmount(), accepted), (boolean)false), IFluidHandler.FluidAction.EXECUTE);
            state.tanks.output.drain(drained, IFluidHandler.FluidAction.EXECUTE);
            context.markMasterDirty();
            context.requestMasterBESync();
        }
    }

    public Function<BlockPos, VoxelShape> shapeGetter(ShapeType shapeType) {
        return ChemicalReactorShape.GETTER;
    }

    @Override
    @Nullable
    public List<Component> getOverlayText(State state, Player player, IMultiblockBEHelper<State> helper) {
        ItemStack input;
        if (state == null) {
            return List.of();
        }
        BlockPos posInMultiblock = helper.getPositionInMB();
        if (TANK_LEFT_POSITIONS.contains(posInMultiblock)) {
            return List.of(TextUtils.formatFluidStack((FluidStack)state.tanks.leftInput.getFluid()));
        }
        if (TANK_BACK_POSITIONS.contains(posInMultiblock)) {
            return List.of(TextUtils.formatFluidStack((FluidStack)state.tanks.backInput.getFluid()));
        }
        if (TANK_RIGHT_POSITIONS.contains(posInMultiblock)) {
            return List.of(TextUtils.formatFluidStack((FluidStack)state.tanks.rightInput.getFluid()));
        }
        if (TANK_FRONT_POSITIONS.contains(posInMultiblock)) {
            return List.of(TextUtils.formatFluidStack((FluidStack)state.tanks.output.getFluid()));
        }
        if (REACTOR_CHAMBER_POSITIONS.contains(posInMultiblock) && !(input = state.inventory.getStackInSlot(0)).m_41619_()) {
            return List.of(Component.m_237113_((String)(input.m_41613_() + " " + input.m_41786_().getString())), Component.m_237113_((String)("Processing: " + state.processor.getQueueSize() + " / " + state.processor.getMaxQueueSize())));
        }
        return List.of(Component.m_237113_((String)("Processing: " + state.processor.getQueueSize() + " / " + state.processor.getMaxQueueSize())));
    }

    private static Set<BlockPos> generateBlockPositions(BlockPos bottomLeft, BlockPos topRight) {
        HashSet<BlockPos> positions = new HashSet<BlockPos>();
        for (int x = bottomLeft.m_123341_(); x <= topRight.m_123341_(); ++x) {
            for (int y = bottomLeft.m_123342_(); y <= topRight.m_123342_(); ++y) {
                for (int z = bottomLeft.m_123343_(); z <= topRight.m_123343_(); ++z) {
                    positions.add(new BlockPos(x, y, z));
                }
            }
        }
        return positions;
    }

    static {
        ITEM_INPUT = new BlockPos(4, 5, 4);
        ENERGY_POS = Set.of(new CapabilityPosition(6, 1, 6, RelativeBlockFace.UP));
        FLUID_OUTPUT = new MultiblockFace(5, 0, 8, RelativeBlockFace.BACK);
        ITEM_OUTPUT = new MultiblockFace(3, 0, 8, RelativeBlockFace.BACK);
        ITEM_INPUT_OUTPUT = new MultiblockFace(4, -1, 4, RelativeBlockFace.UP);
        FLUID_OUTPUT_CAP = new CapabilityPosition(5, 0, 8, RelativeBlockFace.BACK);
        FLUID_INPUT_CAPS = Set.of(new CapabilityPosition(0, 0, 5, RelativeBlockFace.RIGHT), new CapabilityPosition(8, 0, 3, RelativeBlockFace.LEFT), new CapabilityPosition(3, 0, 0, RelativeBlockFace.FRONT));
        FLUID_INPUTS = FLUID_INPUT_CAPS.stream().map(CapabilityPosition::posInMultiblock).collect(Collectors.toSet());
        TANK_LEFT_POSITIONS = ChemicalReactorLogic.generateBlockPositions(new BlockPos(0, 1, 3), new BlockPos(1, 3, 4));
        TANK_RIGHT_POSITIONS = ChemicalReactorLogic.generateBlockPositions(new BlockPos(7, 1, 4), new BlockPos(8, 3, 5));
        TANK_BACK_POSITIONS = ChemicalReactorLogic.generateBlockPositions(new BlockPos(4, 1, 0), new BlockPos(5, 3, 1));
        TANK_FRONT_POSITIONS = ChemicalReactorLogic.generateBlockPositions(new BlockPos(3, 1, 7), new BlockPos(4, 3, 8));
        REACTOR_CHAMBER_POSITIONS = ChemicalReactorLogic.generateBlockPositions(new BlockPos(3, 1, 3), new BlockPos(5, 4, 5));
    }

    public static class State
    implements IGMultiblockState,
    ProcessContext.ProcessContextInMachine<ChemicalRecipe> {
        public final AveragingEnergyStorage energy = new AveragingEnergyStorage(64000);
        public final RedstoneControl.RSState rsState = RedstoneControl.RSState.enabledByDefault();
        public final ChemicalReactorTanks tanks = new ChemicalReactorTanks();
        private final MultiblockProcessor.InMachineProcessor<ChemicalRecipe> processor;
        private final StoredCapability<IEnergyStorage> energyCap;
        private final StoredCapability<IFluidHandler> outputCap;
        public final SlotwiseItemHandler inventory;
        private final StoredCapability<IItemHandler> itemInputCap;
        private final CapabilityReference<IItemHandler> input_output;
        private final StoredCapability<IItemHandler> outputHandler;
        private final Supplier<ChemicalRecipe> cachedRecipe;
        private final StoredCapability<IFluidHandler> inputCapLeft;
        private final StoredCapability<IFluidHandler> inputCapBack;
        private final StoredCapability<IFluidHandler> inputCapRight;
        private final CapabilityReference<IFluidHandler> fluidOutput;
        private final MultiblockProcessor.InMachineProcessor<ChemicalRecipe> dummy;

        /*
         * Issues handling annotations - annotations may be inaccurate
         */
        public State(IInitialMultiblockContext<State> ctx) {
            @Nullable Supplier getLevel = ctx.levelSupplier();
            Runnable markDirty = ctx.getMarkDirtyRunnable();
            this.energyCap = new StoredCapability((Object)this.energy);
            this.inventory = new SlotwiseItemHandler(List.of(new SlotwiseItemHandler.IOConstraint(true, arg_0 -> State.lambda$new$0((Supplier)getLevel, arg_0)), SlotwiseItemHandler.IOConstraint.OUTPUT), ctx.getMarkDirtyRunnable());
            this.input_output = ctx.getCapabilityAt(ForgeCapabilities.ITEM_HANDLER, ITEM_INPUT_OUTPUT);
            this.outputHandler = new StoredCapability((Object)new WrappingItemHandler((IItemHandler)this.inventory, false, true, new WrappingItemHandler.IntRange(1, 2)));
            this.fluidOutput = ctx.getCapabilityAt(ForgeCapabilities.FLUID_HANDLER, new MultiblockFace(FLUID_OUTPUT_CAP.side(), FLUID_OUTPUT_CAP.posInMultiblock().m_122019_()));
            this.processor = new MultiblockProcessor.InMachineProcessor(4, 0.0f, 4, ctx.getMarkDirtyRunnable(), (arg_0, arg_1) -> ChemicalRecipe.RECIPES.getById(arg_0, arg_1));
            this.inputCapLeft = new StoredCapability((Object)new ArrayFluidHandler(true, true, markDirty, new IFluidTank[]{this.tanks.leftInput}));
            this.inputCapBack = new StoredCapability((Object)new ArrayFluidHandler(true, true, markDirty, new IFluidTank[]{this.tanks.backInput}));
            this.inputCapRight = new StoredCapability((Object)new ArrayFluidHandler(true, true, markDirty, new IFluidTank[]{this.tanks.rightInput}));
            this.outputCap = new StoredCapability((Object)ArrayFluidHandler.drainOnly((IFluidTank)this.tanks.output, (Runnable)markDirty));
            this.cachedRecipe = () -> this.lambda$new$1((Supplier)getLevel);
            this.itemInputCap = new StoredCapability((Object)this.inventory);
            this.dummy = new MultiblockProcessor.InMachineProcessor(4, 0.0f, 4, ctx.getMarkDirtyRunnable(), (arg_0, arg_1) -> ChemicalRecipe.RECIPES.getById(arg_0, arg_1));
        }

        public void readSaveNBT(CompoundTag nbt) {
            this.energy.deserializeNBT(nbt.m_128423_("energy"));
            this.tanks.readNBT(nbt.m_128469_("tanks"));
            this.inventory.deserializeNBT(nbt.m_128469_("inventory"));
            this.processor.fromNBT(nbt.m_128423_("processor"), MultiblockProcessInMachine::new);
        }

        public void clearProcessor() {
            this.processor.fromNBT(this.dummy.toNBT(), MultiblockProcessInMachine::new);
        }

        public void writeSaveNBT(CompoundTag nbt) {
            nbt.m_128365_("energy", this.energy.serializeNBT());
            nbt.m_128365_("tanks", this.tanks.toNBT());
            nbt.m_128365_("processor", this.processor.toNBT());
            nbt.m_128365_("inventory", this.inventory.serializeNBT());
        }

        public void writeSyncNBT(CompoundTag nbt) {
            this.writeSaveNBT(nbt);
        }

        public void readSyncNBT(CompoundTag nbt) {
            this.readSaveNBT(nbt);
        }

        public AveragingEnergyStorage getEnergy() {
            return this.energy;
        }

        public boolean additionalCanProcessCheck(MultiblockProcess<ChemicalRecipe, ?> process, Level level) {
            ChemicalRecipe recipe = (ChemicalRecipe)process.getRecipe(level);
            if (recipe == null) {
                return false;
            }
            boolean fluid_pass = false;
            for (IFluidTank fluid : this.getInternalTanks()) {
                for (FluidTagInput f : recipe.fluidIn) {
                    if (!f.test(fluid.getFluid())) continue;
                    fluid_pass = fluid.getFluidAmount() >= f.getAmount();
                }
            }
            boolean item_pass = recipe.itemOutput.equals(ItemStack.f_41583_) || this.getInventory().insertItem(1, recipe.itemOutput, true) != ItemStack.f_41583_;
            return fluid_pass && item_pass;
        }

        public IFluidTank[] getInternalTanks() {
            return new FluidTank[]{this.tanks.leftInput, this.tanks.backInput, this.tanks.rightInput, this.tanks.output};
        }

        public ChemicalReactorTanks getChemicalReactorTanks() {
            return this.tanks;
        }

        public int[] getOutputTanks() {
            return new int[]{3};
        }

        public int[] getOutputSlots() {
            return new int[]{1};
        }

        public SlotwiseItemHandler getInventory() {
            return this.inventory;
        }

        @Nullable
        public ChemicalRecipe getRecipeForInputs(Level level) {
            return ChemicalRecipe.findRecipe(level, this.tanks.leftInput.getFluid(), this.tanks.backInput.getFluid(), this.tanks.rightInput.getFluid(), this.inventory.getStackInSlot(0));
        }

        @Override
        public void invalidate(@NotNull IMultiblockContext<?> context) {
            this.inputCapRight.get(context).invalidate();
            this.inputCapLeft.get(context).invalidate();
            this.inputCapBack.get(context).invalidate();
            this.outputCap.get(context).invalidate();
            this.outputHandler.get(context).invalidate();
            this.itemInputCap.get(context).invalidate();
            this.energyCap.get(context).invalidate();
        }

        private /* synthetic */ ChemicalRecipe lambda$new$1(Supplier getLevel) {
            return ChemicalRecipe.findRecipe((Level)getLevel.get(), this.tanks.leftInput.getFluid(), this.tanks.backInput.getFluid(), this.tanks.rightInput.getFluid(), this.inventory.getStackInSlot(0));
        }

        private static /* synthetic */ boolean lambda$new$0(Supplier getLevel, ItemStack i) {
            return ChemicalRecipe.acceptableCatalyst((Level)getLevel.get(), i);
        }
    }

    public record ChemicalReactorTanks(FluidTank leftInput, FluidTank rightInput, FluidTank backInput, FluidTank output) {
        private static final int TANK_BUFFER_CAPACITY = 32000;

        public ChemicalReactorTanks() {
            this(new FluidTank(32000), new FluidTank(32000), new FluidTank(32000), new FluidTank(32000));
        }

        public Tag toNBT() {
            CompoundTag tag = new CompoundTag();
            tag.m_128365_("leftIn", (Tag)this.leftInput.writeToNBT(new CompoundTag()));
            tag.m_128365_("rightIn", (Tag)this.rightInput.writeToNBT(new CompoundTag()));
            tag.m_128365_("backIn", (Tag)this.backInput.writeToNBT(new CompoundTag()));
            tag.m_128365_("out", (Tag)this.output.writeToNBT(new CompoundTag()));
            return tag;
        }

        public void readNBT(CompoundTag tag) {
            this.leftInput.readFromNBT(tag.m_128469_("leftIn"));
            this.rightInput.readFromNBT(tag.m_128469_("rightIn"));
            this.backInput.readFromNBT(tag.m_128469_("backIn"));
            this.output.readFromNBT(tag.m_128469_("out"));
        }

        public BlockPos getLeftTankPos(boolean isMirrored) {
            BlockPos pos = new BlockPos(-4, 1, 0);
            if (isMirrored) {
                pos = new BlockPos(3, 1, 0);
            }
            return pos;
        }

        public BlockPos getRightTankPos(boolean isMirrored) {
            BlockPos pos = new BlockPos(3, 1, 1);
            if (isMirrored) {
                pos = new BlockPos(-4, 1, 1);
            }
            return pos;
        }

        public BlockPos getBackTankPos(boolean isMirrored) {
            BlockPos pos = new BlockPos(0, 1, -3);
            if (isMirrored) {
                pos = new BlockPos(-1, 1, -3);
            }
            return pos;
        }

        public BlockPos getOutputTankPos(boolean isMirrored) {
            BlockPos pos = new BlockPos(-1, 1, 4);
            if (isMirrored) {
                pos = new BlockPos(0, 1, 4);
            }
            return pos;
        }

        public int getCapacity() {
            return 32000;
        }
    }
}

