/*
 * Decompiled with CFR 0.152.
 */
package com.igteam.immersivegeology.common.block.multiblocks.logic;

import blusunrize.immersiveengineering.api.crafting.MultiblockRecipe;
import blusunrize.immersiveengineering.api.energy.AveragingEnergyStorage;
import blusunrize.immersiveengineering.api.multiblocks.blocks.component.IClientTickableComponent;
import blusunrize.immersiveengineering.api.multiblocks.blocks.component.IServerTickableComponent;
import blusunrize.immersiveengineering.api.multiblocks.blocks.component.RedstoneControl;
import blusunrize.immersiveengineering.api.multiblocks.blocks.env.IInitialMultiblockContext;
import blusunrize.immersiveengineering.api.multiblocks.blocks.env.IMultiblockContext;
import blusunrize.immersiveengineering.api.multiblocks.blocks.logic.IMultiblockLogic;
import blusunrize.immersiveengineering.api.multiblocks.blocks.logic.IMultiblockState;
import blusunrize.immersiveengineering.api.multiblocks.blocks.util.CapabilityPosition;
import blusunrize.immersiveengineering.api.multiblocks.blocks.util.MBInventoryUtils;
import blusunrize.immersiveengineering.api.multiblocks.blocks.util.MultiblockFace;
import blusunrize.immersiveengineering.api.multiblocks.blocks.util.RelativeBlockFace;
import blusunrize.immersiveengineering.api.multiblocks.blocks.util.ShapeType;
import blusunrize.immersiveengineering.api.multiblocks.blocks.util.StoredCapability;
import blusunrize.immersiveengineering.api.utils.CapabilityReference;
import blusunrize.immersiveengineering.client.utils.TextUtils;
import blusunrize.immersiveengineering.common.blocks.multiblocks.logic.interfaces.MBOverlayText;
import blusunrize.immersiveengineering.common.blocks.multiblocks.process.MultiblockProcess;
import blusunrize.immersiveengineering.common.blocks.multiblocks.process.MultiblockProcessInMachine;
import blusunrize.immersiveengineering.common.blocks.multiblocks.process.MultiblockProcessor;
import blusunrize.immersiveengineering.common.blocks.multiblocks.process.ProcessContext;
import blusunrize.immersiveengineering.common.fluids.ArrayFluidHandler;
import blusunrize.immersiveengineering.common.util.Utils;
import blusunrize.immersiveengineering.common.util.inventory.SlotwiseItemHandler;
import blusunrize.immersiveengineering.common.util.inventory.WrappingItemHandler;
import com.igteam.immersivegeology.common.block.multiblocks.recipe.FoundryRecipe;
import com.igteam.immersivegeology.common.block.multiblocks.shapes.FoundryShape;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidTank;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import org.jetbrains.annotations.Nullable;

public class FoundryLogic
implements IMultiblockLogic<State>,
IServerTickableComponent<State>,
IClientTickableComponent<State>,
MBOverlayText<State> {
    public static final BlockPos REDSTONE_IN = new BlockPos(0, 1, 1);
    private static final int ENERGY_CAPACITY = 48000;
    private static final CapabilityPosition ENERGY_INPUT = new CapabilityPosition(0, 1, 0, RelativeBlockFace.LEFT);
    private static final CapabilityPosition FLUID_INPUT_CAP = new CapabilityPosition(1, 2, 0, RelativeBlockFace.UP);
    private static final MultiblockFace OUTPUT_POS = new MultiblockFace(3, 1, 1, RelativeBlockFace.RIGHT);
    private static final CapabilityPosition ITEM_OUTPUT_CAP = CapabilityPosition.opposing((MultiblockFace)OUTPUT_POS);
    public static final int TANK_VOLUME = 1000;

    public void tickClient(IMultiblockContext<State> context) {
    }

    public void tickServer(IMultiblockContext<State> context) {
        State state = (State)context.getState();
        int tank_amount = state.tank.getFluidAmount();
        state.processor.tickServer((ProcessContext)state, context.getLevel(), state.rsState.isEnabled(context));
        this.tryRunRecipe(state, context.getLevel().getRawLevel());
        if (tank_amount != state.tank.getFluidAmount()) {
            context.requestMasterBESync();
        }
    }

    private void tryRunRecipe(State state, Level level) {
        if (state.energy.getEnergyStored() <= 0 || state.processor.getQueueSize() >= state.processor.getMaxQueueSize()) {
            return;
        }
        FluidStack input = state.tank.getFluid();
        if (input.isEmpty()) {
            return;
        }
        FoundryRecipe recipe = FoundryRecipe.findRecipe(level, input);
        if (recipe == null) {
            return;
        }
        MultiblockProcessInMachine process = new MultiblockProcessInMachine((MultiblockRecipe)recipe, new int[0]);
        if (input.isEmpty()) {
            process.setInputTanks(new int[]{1});
        }
        int drainSimulation = state.tank.drain(recipe.fluidIn.getAmount(), IFluidHandler.FluidAction.SIMULATE).getAmount();
        int drainAmount = recipe.fluidIn.getAmount();
        if (state.processor.addProcessToQueue((MultiblockProcess)process, level, true) && drainSimulation == drainAmount) {
            state.processor.addProcessToQueue((MultiblockProcess)process, level, false);
            state.tank.drain(recipe.fluidIn.getAmount(), IFluidHandler.FluidAction.EXECUTE).getAmount();
        }
    }

    public State createInitialState(IInitialMultiblockContext<State> capability) {
        return new State(capability);
    }

    public void dropExtraItems(State state, Consumer<ItemStack> drop) {
        MBInventoryUtils.dropItems((IItemHandler)state.getInventory(), drop);
    }

    public <T> LazyOptional<T> getCapability(IMultiblockContext<State> ctx, CapabilityPosition position, Capability<T> cap) {
        State state = (State)ctx.getState();
        if (cap == ForgeCapabilities.ENERGY && (position.side() == null || ENERGY_INPUT.equals((Object)position))) {
            return state.energyCap.cast(ctx);
        }
        if (cap == ForgeCapabilities.FLUID_HANDLER && FLUID_INPUT_CAP.equals((Object)position)) {
            return state.fInputCap.cast(ctx);
        }
        if (cap == ForgeCapabilities.ITEM_HANDLER && ITEM_OUTPUT_CAP.equals((Object)position)) {
            return state.itemOutputCap.cast(ctx);
        }
        return LazyOptional.empty();
    }

    @Nullable
    public List<Component> getOverlayText(State state, Player player, boolean b) {
        if (Utils.isFluidRelatedItemStack((ItemStack)player.m_21120_(InteractionHand.MAIN_HAND))) {
            return List.of(TextUtils.formatFluidStack((FluidStack)state.tank.getFluid()));
        }
        return null;
    }

    public Function<BlockPos, VoxelShape> shapeGetter(ShapeType shapeType) {
        return FoundryShape.GETTER;
    }

    public static class State
    implements IMultiblockState,
    ProcessContext.ProcessContextInMachine<FoundryRecipe> {
        public final RedstoneControl.RSState rsState = RedstoneControl.RSState.enabledByDefault();
        public final AveragingEnergyStorage energy = new AveragingEnergyStorage(48000);
        private final MultiblockProcessor<FoundryRecipe, ProcessContext.ProcessContextInMachine<FoundryRecipe>> processor;
        public final SlotwiseItemHandler inventory;
        private final StoredCapability<IFluidHandler> fInputCap;
        private final StoredCapability<IItemHandler> itemOutputCap;
        private final StoredCapability<IEnergyStorage> energyCap;
        private final CapabilityReference<IItemHandler> output;
        public final FluidTank tank = new FluidTank(1000);

        public State(IInitialMultiblockContext<State> ctx) {
            this.energyCap = new StoredCapability((Object)this.energy);
            this.output = ctx.getCapabilityAt(ForgeCapabilities.ITEM_HANDLER, OUTPUT_POS);
            this.processor = new MultiblockProcessor(1, 0.0f, 1, ctx.getMarkDirtyRunnable(), (arg_0, arg_1) -> FoundryRecipe.RECIPES.getById(arg_0, arg_1));
            this.inventory = SlotwiseItemHandler.makeWithGroups(List.of(new SlotwiseItemHandler.IOConstraintGroup(SlotwiseItemHandler.IOConstraint.NO_CONSTRAINT, 1)), (Runnable)ctx.getMarkDirtyRunnable());
            Runnable changedAndSync = () -> {
                ctx.getSyncRunnable().run();
                ctx.getMarkDirtyRunnable().run();
            };
            this.itemOutputCap = new StoredCapability((Object)new WrappingItemHandler((IItemHandler)this.inventory, false, true, new WrappingItemHandler.IntRange(0, 1)));
            this.fInputCap = new StoredCapability((Object)new ArrayFluidHandler((IFluidTank)this.tank, true, true, changedAndSync));
        }

        public void writeSaveNBT(CompoundTag nbt) {
            nbt.m_128365_("energy", this.energy.serializeNBT());
            nbt.m_128365_("processor", this.processor.toNBT());
            nbt.m_128365_("tank", (Tag)this.tank.writeToNBT(new CompoundTag()));
            nbt.m_128365_("inventory", this.inventory.serializeNBT());
        }

        public void readSaveNBT(CompoundTag nbt) {
            this.energy.deserializeNBT(nbt.m_128423_("energy"));
            this.tank.readFromNBT(nbt.m_128469_("tank"));
            this.inventory.deserializeNBT(nbt.m_128469_("inventory"));
            this.processor.fromNBT(nbt.m_128423_("processor"), MultiblockProcessInMachine::new);
        }

        public void writeSyncNBT(CompoundTag nbt) {
            this.writeSaveNBT(nbt);
        }

        public void readSyncNBT(CompoundTag nbt) {
            this.readSaveNBT(nbt);
        }

        public int[] getOutputSlots() {
            return new int[]{0};
        }

        public IFluidTank[] getInternalTanks() {
            return new FluidTank[]{this.tank};
        }

        public IItemHandlerModifiable getInventory() {
            return this.inventory.getRawHandler();
        }

        public AveragingEnergyStorage getEnergy() {
            return this.energy;
        }
    }
}

