/*
 * Decompiled with CFR 0.152.
 */
package com.igteam.immersivegeology.common.block.multiblocks.logic;

import blusunrize.immersiveengineering.api.multiblocks.blocks.component.IClientTickableComponent;
import blusunrize.immersiveengineering.api.multiblocks.blocks.component.IServerTickableComponent;
import blusunrize.immersiveengineering.api.multiblocks.blocks.component.RedstoneControl;
import blusunrize.immersiveengineering.api.multiblocks.blocks.env.IInitialMultiblockContext;
import blusunrize.immersiveengineering.api.multiblocks.blocks.env.IMultiblockContext;
import blusunrize.immersiveengineering.api.multiblocks.blocks.env.IMultiblockLevel;
import blusunrize.immersiveengineering.api.multiblocks.blocks.util.CapabilityPosition;
import blusunrize.immersiveengineering.api.multiblocks.blocks.util.MultiblockFace;
import blusunrize.immersiveengineering.api.multiblocks.blocks.util.RelativeBlockFace;
import blusunrize.immersiveengineering.api.multiblocks.blocks.util.ShapeType;
import blusunrize.immersiveengineering.api.multiblocks.blocks.util.StoredCapability;
import blusunrize.immersiveengineering.client.utils.TextUtils;
import blusunrize.immersiveengineering.common.blocks.multiblocks.logic.interfaces.MBOverlayText;
import blusunrize.immersiveengineering.common.fluids.ArrayFluidHandler;
import blusunrize.immersiveengineering.common.util.DroppingMultiblockOutput;
import blusunrize.immersiveengineering.common.util.Utils;
import blusunrize.immersiveengineering.common.util.inventory.InsertOnlyInventory;
import com.igteam.immersivegeology.common.block.multiblocks.logic.helper.IGMultiblockState;
import com.igteam.immersivegeology.common.block.multiblocks.logic.helper.ISkinnableMultiblockLogic;
import com.igteam.immersivegeology.common.block.multiblocks.logic.helper.SeparatorProcess;
import com.igteam.immersivegeology.common.block.multiblocks.recipe.GravitySeparatorRecipe;
import com.igteam.immersivegeology.common.block.multiblocks.shapes.GravitySeparatorShape;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidTank;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GravitySeparatorLogic
implements ISkinnableMultiblockLogic<State>,
IServerTickableComponent<State>,
MBOverlayText<State>,
IClientTickableComponent<State> {
    public static final BlockPos REDSTONE_IN = new BlockPos(1, 1, 1);
    private static final CapabilityPosition FLUID_INPUT_CAP = new CapabilityPosition(1, 5, 1, RelativeBlockFace.UP);
    private static final int MAX_PROCESSES = 64;
    private static final CapabilityPosition INPUT_POS = new CapabilityPosition(0, 1, 0, RelativeBlockFace.RIGHT);
    private static final MultiblockFace OUTPUT_POS = new MultiblockFace(3, 0, 1, RelativeBlockFace.RIGHT);
    private static final MultiblockFace SECONDARY_OUTPUT_POS = new MultiblockFace(-1, 0, 1, RelativeBlockFace.LEFT);
    private static final CapabilityPosition ITEM_OUTPUT_CAP = CapabilityPosition.opposing((MultiblockFace)OUTPUT_POS);
    public static final int TANK_VOLUME = 8000;

    public void tickClient(IMultiblockContext<State> iMultiblockContext) {
    }

    public void dropExtraItems(State state, Consumer<ItemStack> drop) {
    }

    public void tickServer(IMultiblockContext<State> context) {
        State state = (State)context.getState();
        IMultiblockLevel level = context.getLevel();
        Level rawLevel = level.getRawLevel();
        boolean wasActive = state.renderAsActive;
        if (state.tank.getFluidAmount() > 0) {
            ArrayList<SeparatorProcess> removalList = new ArrayList<SeparatorProcess>();
            int size = state.separatorProcessesQueue.size();
            ArrayList<SeparatorProcess> processList = new ArrayList<SeparatorProcess>(List.of(state.separatorProcessesQueue.toArray(new SeparatorProcess[size])));
            for (SeparatorProcess process : processList) {
                if (process.processStep(rawLevel, state.tank)) {
                    context.markMasterDirty();
                }
                if (!process.isProcessFinished()) continue;
                state.output.insertOrDrop(process.getCurrentOutput(), level);
                if (process.outputByproduct()) {
                    state.secondary.insertOrDrop(process.getCurrentByproduct(), level);
                }
                removalList.add(process);
                context.markDirtyAndSync();
            }
            state.separatorProcessesQueue.removeAll(removalList);
            if (wasActive != state.renderAsActive) {
                context.requestMasterBESync();
            }
        }
    }

    public void onEntityCollision(IMultiblockContext<State> ctx, BlockPos posInMultiblock, Entity collided) {
        if (collided.m_9236_().f_46443_) {
            return;
        }
        State state = (State)ctx.getState();
        IMultiblockLevel level = ctx.getLevel();
        AABB internalBB = new AABB(-2.0, 3.0, -2.0, 5.0, 6.0, 5.0);
        AABB separatorInternal = level.toAbsolute(internalBB);
        if (collided instanceof ItemEntity) {
            ItemEntity itemEntity = (ItemEntity)collided;
            if (state.insert_cooldown > 0) {
                ctx.markDirtyAndSync();
                --state.insert_cooldown;
                return;
            }
            state.insert_cooldown = 1;
            ctx.markDirtyAndSync();
            ItemStack stack = itemEntity.m_32055_();
            if (stack.m_41619_()) {
                return;
            }
            if (GravitySeparatorLogic.insertItemToProcess(stack = stack.m_41777_(), true, state, level.getRawLevel()) && GravitySeparatorLogic.insertItemToProcess(stack, false, state, level.getRawLevel())) {
                if (stack.m_41613_() <= 0) {
                    itemEntity.m_146870_();
                } else {
                    itemEntity.m_32045_(stack);
                }
            }
        }
    }

    private static boolean insertItemToProcess(ItemStack stack, boolean simulate, State state, Level rawLevel) {
        if (state.separatorProcessesQueue.size() >= 64) {
            return false;
        }
        GravitySeparatorRecipe recipe = GravitySeparatorRecipe.findRecipe(rawLevel, stack);
        if (recipe == null) {
            return false;
        }
        if (!simulate) {
            SeparatorProcess p = new SeparatorProcess(ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)1));
            state.separatorProcessesQueue.add(p);
            stack.m_41774_(1);
        }
        return true;
    }

    public State createInitialState(IInitialMultiblockContext<State> capability) {
        return new State(capability);
    }

    public Function<BlockPos, VoxelShape> shapeGetter(ShapeType shapeType) {
        return GravitySeparatorShape.GETTER;
    }

    public <T> LazyOptional<T> getCapability(IMultiblockContext<State> ctx, CapabilityPosition position, Capability<T> cap) {
        State state = (State)ctx.getState();
        if (cap == ForgeCapabilities.ITEM_HANDLER) {
            return state.insertionHandler.cast(ctx);
        }
        if (cap == ForgeCapabilities.FLUID_HANDLER && FLUID_INPUT_CAP.equals((Object)position)) {
            return state.fInputCap.cast(ctx);
        }
        return LazyOptional.empty();
    }

    @Nullable
    public List<Component> getOverlayText(State state, Player player, boolean b) {
        if (state == null) {
            return List.of();
        }
        if (!state.separatorProcessesQueue.isEmpty() && state.tank.getFluidAmount() < 20) {
            return List.of(Component.m_237115_((String)"immersivegeology.machine.low_water").m_130940_(ChatFormatting.RED));
        }
        if (Utils.isFluidRelatedItemStack((ItemStack)player.m_21120_(InteractionHand.MAIN_HAND))) {
            return List.of(TextUtils.formatFluidStack((FluidStack)state.tank.getFluid()));
        }
        return List.of();
    }

    public static class State
    implements IGMultiblockState {
        public final RedstoneControl.RSState rsState = RedstoneControl.RSState.disabledByDefault();
        public final ArrayList<SeparatorProcess> separatorProcessesQueue = new ArrayList();
        private int insert_cooldown = 10;
        private final StoredCapability<IItemHandler> insertionHandler;
        private final DroppingMultiblockOutput output;
        private final DroppingMultiblockOutput secondary;
        private final StoredCapability<IFluidHandler> fInputCap;
        public final FluidTank tank = new FluidTank(8000);
        private boolean renderAsActive;

        /*
         * Issues handling annotations - annotations may be inaccurate
         */
        public State(IInitialMultiblockContext<State> ctx) {
            final @Nullable Supplier levelGetter = ctx.levelSupplier();
            Runnable markDirty = ctx.getMarkDirtyRunnable();
            Runnable sync = ctx.getSyncRunnable();
            final Runnable changedAndSync = () -> {
                markDirty.run();
                sync.run();
            };
            this.output = new DroppingMultiblockOutput(OUTPUT_POS, ctx);
            this.secondary = new DroppingMultiblockOutput(SECONDARY_OUTPUT_POS, ctx);
            this.fInputCap = new StoredCapability((Object)new ArrayFluidHandler((IFluidTank)this.tank, true, true, changedAndSync));
            this.insertionHandler = new StoredCapability((Object)new InsertOnlyInventory(){

                protected ItemStack insert(ItemStack toInsert, boolean simulate) {
                    if (GravitySeparatorLogic.insertItemToProcess(toInsert = toInsert.m_41777_(), simulate, this, (Level)levelGetter.get())) {
                        changedAndSync.run();
                    }
                    return toInsert;
                }
            });
        }

        public boolean shouldRenderActive() {
            return this.renderAsActive;
        }

        public void writeSaveNBT(CompoundTag nbt) {
            this.writeSyncNBT(nbt);
        }

        public void readSaveNBT(CompoundTag nbt) {
            this.readSyncNBT(nbt);
        }

        public void writeSyncNBT(CompoundTag nbt) {
            this.writeCommonNBT(nbt);
            nbt.m_128365_("tank", (Tag)this.tank.writeToNBT(new CompoundTag()));
            nbt.m_128379_("renderActive", this.renderAsActive);
            nbt.m_128405_("insert_cooldown", this.insert_cooldown);
        }

        public void readSyncNBT(CompoundTag nbt) {
            this.readCommonNBT(nbt);
            this.tank.readFromNBT(nbt.m_128469_("tank"));
            this.renderAsActive = nbt.m_128471_("renderActive");
            this.insert_cooldown = nbt.m_128451_("insert_cooldown");
        }

        private void writeCommonNBT(CompoundTag nbt) {
            ListTag processes = new ListTag();
            for (SeparatorProcess process : this.separatorProcessesQueue) {
                processes.add((Object)process.writeToNBT());
            }
            nbt.m_128365_("processes", (Tag)processes);
        }

        private void readCommonNBT(CompoundTag nbt) {
            ListTag processes = nbt.m_128437_("processes", 10);
            this.separatorProcessesQueue.clear();
            for (int i = 0; i < processes.size(); ++i) {
                this.separatorProcessesQueue.add(SeparatorProcess.readFromNBT(processes.m_128728_(i)));
            }
        }

        @Override
        public void invalidate(@NotNull IMultiblockContext<?> ctx) {
            this.fInputCap.get(ctx).invalidate();
            this.insertionHandler.get(ctx).invalidate();
        }
    }
}

