/*
 * Decompiled with CFR 0.152.
 */
package com.igteam.immersivegeology.common.block.multiblocks.logic;

import blusunrize.immersiveengineering.api.ApiUtils;
import blusunrize.immersiveengineering.api.IEProperties;
import blusunrize.immersiveengineering.api.crafting.BlastFurnaceFuel;
import blusunrize.immersiveengineering.api.multiblocks.TemplateMultiblock;
import blusunrize.immersiveengineering.api.multiblocks.blocks.component.IClientTickableComponent;
import blusunrize.immersiveengineering.api.multiblocks.blocks.component.IServerTickableComponent;
import blusunrize.immersiveengineering.api.multiblocks.blocks.env.IInitialMultiblockContext;
import blusunrize.immersiveengineering.api.multiblocks.blocks.env.IMultiblockContext;
import blusunrize.immersiveengineering.api.multiblocks.blocks.env.IMultiblockLevel;
import blusunrize.immersiveengineering.api.multiblocks.blocks.logic.IMultiblockLogic;
import blusunrize.immersiveengineering.api.multiblocks.blocks.util.CapabilityPosition;
import blusunrize.immersiveengineering.api.multiblocks.blocks.util.MBInventoryUtils;
import blusunrize.immersiveengineering.api.multiblocks.blocks.util.MultiblockFace;
import blusunrize.immersiveengineering.api.multiblocks.blocks.util.RelativeBlockFace;
import blusunrize.immersiveengineering.api.multiblocks.blocks.util.ShapeType;
import blusunrize.immersiveengineering.api.multiblocks.blocks.util.StoredCapability;
import blusunrize.immersiveengineering.api.utils.CapabilityReference;
import blusunrize.immersiveengineering.client.utils.TextUtils;
import blusunrize.immersiveengineering.common.blocks.metal.BlastFurnacePreheaterBlockEntity;
import blusunrize.immersiveengineering.common.blocks.multiblocks.logic.NonMirrorableWithActiveBlock;
import blusunrize.immersiveengineering.common.blocks.multiblocks.logic.interfaces.MBOverlayText;
import blusunrize.immersiveengineering.common.fluids.ArrayFluidHandler;
import blusunrize.immersiveengineering.common.gui.sync.GetterAndSetter;
import blusunrize.immersiveengineering.common.util.CachedRecipe;
import blusunrize.immersiveengineering.common.util.Utils;
import blusunrize.immersiveengineering.common.util.inventory.SlotwiseItemHandler;
import blusunrize.immersiveengineering.common.util.inventory.WrappingItemHandler;
import com.igteam.immersivegeology.common.block.multiblocks.IGReverberationFurnaceMultiblock;
import com.igteam.immersivegeology.common.block.multiblocks.logic.helper.IGMultiblockState;
import com.igteam.immersivegeology.common.block.multiblocks.logic.helper.IGRevFurnaceHandler;
import com.igteam.immersivegeology.common.block.multiblocks.part.RevFurnacePart;
import com.igteam.immersivegeology.common.block.multiblocks.recipe.RevFurnaceRecipe;
import com.igteam.immersivegeology.common.block.multiblocks.shapes.RevFurnaceShape;
import com.igteam.immersivegeology.common.block.multiblocks.skins.IGRevFurnaceSkins;
import com.igteam.immersivegeology.core.material.data.enums.ChemicalEnum;
import com.igteam.immersivegeology.core.material.helper.flags.BlockCategoryFlags;
import com.igteam.immersivegeology.core.registration.IGRegistrationHolder;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidTank;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemHandlerHelper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RevFurnaceLogic
implements IMultiblockLogic<State>,
MBOverlayText<State>,
IServerTickableComponent<State>,
IClientTickableComponent<State> {
    public static final int TANK_CAPACITY = 24000;
    public static final int NUM_SLOTS = 6;
    CapabilityPosition SLOT_1_INPUT_POSITION = new CapabilityPosition(1, 1, 1, RelativeBlockFace.UP);
    CapabilityPosition SLOT_2_INPUT_POSITION = new CapabilityPosition(1, 1, 4, RelativeBlockFace.UP);
    private static final BlockPos[] HEATER_OFFSETS = new BlockPos[]{new BlockPos(1, 0, -1), new BlockPos(1, 0, 6)};
    public static final MultiblockFace SLOT_1_OUTPUT_POSITION = new MultiblockFace(0, 0, 1, RelativeBlockFace.LEFT);
    public static final MultiblockFace SLOT_2_OUTPUT_POSITION = new MultiblockFace(0, 0, 4, RelativeBlockFace.RIGHT);
    public static final CapabilityPosition SLOT_1_OUTPUT_FLUID = new CapabilityPosition(4, 11, 1, RelativeBlockFace.UP);
    static CapabilityPosition SLOT_2_OUTPUT_FLUID = new CapabilityPosition(4, 11, 4, RelativeBlockFace.UP);
    private static final int[] OUTPUT_SLOTS_LEFT = (int[])Util.m_137469_((Object)new int[1], slots -> {
        slots[0] = 2;
    });
    private static final int[] OUTPUT_SLOTS_RIGHT = (int[])Util.m_137469_((Object)new int[1], slots -> {
        slots[0] = 4;
    });
    private boolean leftChimneyUsed = false;
    private boolean rightChimneyUsed = false;
    private static final Vec3 SMOKE_POSITION_LEFT = new Vec3(4.5, 12.0, 1.5);
    private static final Vec3 SMOKE_POSITION_RIGHT = new Vec3(4.5, 12.0, 4.5);

    public void tickServer(IMultiblockContext<State> context) {
        boolean wasActive;
        boolean anyActive;
        State state = (State)context.getState();
        IMultiblockLevel level = context.getLevel();
        state.active_left = state.furnace.tickServerLeft(context);
        state.active_right = state.furnace.tickServerRight(context);
        this.outputItems(state);
        if (state.tank.getFluidAmount() > 0) {
            this.drainOutputTank(state, context, state.fluidOutput1);
            this.drainOutputTank(state, context, state.fluidOutput2);
        }
        if ((anyActive = state.active_left || state.active_right) != (wasActive = ((Boolean)level.getBlockState(IGReverberationFurnaceMultiblock.INSTANCE.getMasterFromOriginOffset()).m_61143_((Property)IEProperties.ACTIVE)).booleanValue())) {
            IGRevFurnaceSkins current_skin = (IGRevFurnaceSkins)((Object)level.getBlockState(IGReverberationFurnaceMultiblock.INSTANCE.getMasterFromOriginOffset()).m_61143_(RevFurnacePart.REVERBERATION_FURNACE));
            NonMirrorableWithActiveBlock.setActive((IMultiblockLevel)level, (TemplateMultiblock)IGReverberationFurnaceMultiblock.INSTANCE, (boolean)anyActive);
            RevFurnacePart.setSkin(level, IGReverberationFurnaceMultiblock.INSTANCE, current_skin);
        }
        context.requestMasterBESync();
    }

    private void outputItems(State state) {
        IItemHandler outputHandlerRight;
        IItemHandler outputHandlerLeft = (IItemHandler)state.outputLeft.getNullable();
        if (outputHandlerLeft != null) {
            for (int j : OUTPUT_SLOTS_LEFT) {
                ItemStack nextStack = state.inventory.getStackInSlot(j);
                if (nextStack.m_41619_()) continue;
                ItemStack stack = ItemHandlerHelper.copyStackWithSize((ItemStack)nextStack, (int)1);
                if (!(stack = ItemHandlerHelper.insertItem((IItemHandler)outputHandlerLeft, (ItemStack)stack, (boolean)false)).m_41619_()) continue;
                nextStack.m_41774_(1);
            }
        }
        if ((outputHandlerRight = (IItemHandler)state.outputRight.getNullable()) != null) {
            for (int j : OUTPUT_SLOTS_RIGHT) {
                ItemStack nextStack = state.inventory.getStackInSlot(j);
                if (nextStack.m_41619_()) continue;
                ItemStack stack = ItemHandlerHelper.copyStackWithSize((ItemStack)nextStack, (int)1);
                if (!(stack = ItemHandlerHelper.insertItem((IItemHandler)outputHandlerRight, (ItemStack)stack, (boolean)false)).m_41619_()) continue;
                nextStack.m_41774_(1);
            }
        }
    }

    private void drainOutputTank(State state, IMultiblockContext<State> context, CapabilityReference<IFluidHandler> outputRef) {
        int outSize = Math.min(1000, state.tank.getFluidAmount());
        FluidStack out = Utils.copyFluidStackWithAmount((FluidStack)state.tank.getFluid(), (int)outSize, (boolean)false);
        IFluidHandler output = (IFluidHandler)outputRef.getNullable();
        if (output == null) {
            return;
        }
        int accepted = output.fill(out, IFluidHandler.FluidAction.SIMULATE);
        if (accepted > 0) {
            int drained = output.fill(Utils.copyFluidStackWithAmount((FluidStack)out, (int)Math.min(out.getAmount(), accepted), (boolean)false), IFluidHandler.FluidAction.EXECUTE);
            state.tank.drain(drained, IFluidHandler.FluidAction.EXECUTE);
            context.markMasterDirty();
            context.requestMasterBESync();
        }
    }

    public <T> LazyOptional<T> getCapability(IMultiblockContext<State> ctx, CapabilityPosition position, Capability<T> cap) {
        State state = (State)ctx.getState();
        boolean isMirrored = ctx.getLevel().getOrientation().mirrored();
        if (cap == ForgeCapabilities.ITEM_HANDLER) {
            if (this.SLOT_1_INPUT_POSITION.equals((Object)position)) {
                return isMirrored ? state.invCapRight.cast(ctx) : state.invCapLeft.cast(ctx);
            }
            if (this.SLOT_2_INPUT_POSITION.equals((Object)position)) {
                return isMirrored ? state.invCapLeft.cast(ctx) : state.invCapRight.cast(ctx);
            }
            if (SLOT_1_OUTPUT_POSITION.posInMultiblock().equals((Object)position.posInMultiblock())) {
                return isMirrored ? state.outputHandlerRight.cast(ctx) : state.outputHandlerLeft.cast(ctx);
            }
            if (SLOT_2_OUTPUT_POSITION.posInMultiblock().equals((Object)position.posInMultiblock())) {
                return isMirrored ? state.outputHandlerLeft.cast(ctx) : state.outputHandlerRight.cast(ctx);
            }
        } else if (cap == ForgeCapabilities.FLUID_HANDLER && (SLOT_1_OUTPUT_FLUID.equals((Object)position) || SLOT_2_OUTPUT_FLUID.equals((Object)position))) {
            return state.fluidCap.cast(ctx);
        }
        return LazyOptional.empty();
    }

    public void dropExtraItems(State state, Consumer<ItemStack> drop) {
        MBInventoryUtils.dropItems((IItemHandler)state.inventory, drop);
    }

    public State createInitialState(IInitialMultiblockContext<State> capability) {
        return new State(capability);
    }

    public Function<BlockPos, VoxelShape> shapeGetter(ShapeType shapeType) {
        return RevFurnaceShape.GETTER;
    }

    @Nullable
    public List<Component> getOverlayText(State state, Player player, boolean b) {
        if (Utils.isFluidRelatedItemStack((ItemStack)player.m_21120_(InteractionHand.MAIN_HAND))) {
            return List.of(TextUtils.formatFluidStack((FluidStack)state.tank.getFluid()));
        }
        return List.of();
    }

    private double particleXZSpeed() {
        return ApiUtils.RANDOM.nextDouble(-0.015625, 0.015625);
    }

    public void tickClient(IMultiblockContext<State> context) {
        State state = (State)context.getState();
        boolean isMirrored = context.getLevel().getOrientation().mirrored();
        if (context.getLevel().shouldTickModulo(2)) {
            if (state.active_left & !state.fluidOutput1.isPresent()) {
                this.spawnSmoke(context, isMirrored ? SMOKE_POSITION_RIGHT : SMOKE_POSITION_LEFT);
            }
            if (state.active_right & !state.fluidOutput2.isPresent()) {
                this.spawnSmoke(context, isMirrored ? SMOKE_POSITION_LEFT : SMOKE_POSITION_RIGHT);
            }
        }
    }

    private void spawnSmoke(IMultiblockContext<State> context, Vec3 position) {
        Vec3 absoluteSmokePosition = context.getLevel().toAbsolute(position);
        context.getLevel().getRawLevel().m_7107_((ParticleOptions)ParticleTypes.f_123777_, absoluteSmokePosition.f_82479_, absoluteSmokePosition.f_82480_, absoluteSmokePosition.f_82481_, this.particleXZSpeed(), 0.0625, this.particleXZSpeed());
    }

    public static class State
    implements IGMultiblockState,
    IGRevFurnaceHandler.IRevFurnaceEnvironment<RevFurnaceRecipe> {
        private final SlotwiseItemHandler inventory;
        final IGRevFurnaceHandler<RevFurnaceRecipe> furnace;
        private boolean active_left = false;
        private boolean active_right = false;
        private final Supplier<RevFurnaceRecipe> cachedRecipeLeft;
        private final Supplier<RevFurnaceRecipe> cachedRecipeRight;
        private final FluidTank tank = new FluidTank(24000);
        private final StoredCapability<IItemHandler> invCapLeft;
        private final StoredCapability<IItemHandler> invCapRight;
        private final StoredCapability<IItemHandler> outputHandlerLeft;
        private final StoredCapability<IItemHandler> outputHandlerRight;
        private final CapabilityReference<IItemHandler> outputLeft;
        private final CapabilityReference<IItemHandler> outputRight;
        private final CapabilityReference<IFluidHandler> fluidOutput1;
        private final CapabilityReference<IFluidHandler> fluidOutput2;
        private final StoredCapability<IFluidHandler> fluidCap;

        /*
         * Issues handling annotations - annotations may be inaccurate
         */
        public State(IInitialMultiblockContext<?> ctx) {
            @Nullable Supplier getLevel = ctx.levelSupplier();
            this.inventory = new SlotwiseItemHandler(List.of(new SlotwiseItemHandler.IOConstraint(true, arg_0 -> State.lambda$new$0((Supplier)getLevel, arg_0)), new SlotwiseItemHandler.IOConstraint(true, arg_0 -> State.lambda$new$1((Supplier)getLevel, arg_0)), SlotwiseItemHandler.IOConstraint.OUTPUT, new SlotwiseItemHandler.IOConstraint(true, arg_0 -> State.lambda$new$2((Supplier)getLevel, arg_0)), new SlotwiseItemHandler.IOConstraint(true, arg_0 -> State.lambda$new$3((Supplier)getLevel, arg_0)), SlotwiseItemHandler.IOConstraint.OUTPUT), ctx.getMarkDirtyRunnable());
            this.outputLeft = ctx.getCapabilityAt(ForgeCapabilities.ITEM_HANDLER, SLOT_1_OUTPUT_POSITION);
            this.outputRight = ctx.getCapabilityAt(ForgeCapabilities.ITEM_HANDLER, SLOT_2_OUTPUT_POSITION);
            this.fluidOutput1 = ctx.getCapabilityAt(ForgeCapabilities.FLUID_HANDLER, new MultiblockFace(SLOT_1_OUTPUT_FLUID.side(), SLOT_1_OUTPUT_FLUID.posInMultiblock().m_7494_()));
            this.fluidOutput2 = ctx.getCapabilityAt(ForgeCapabilities.FLUID_HANDLER, new MultiblockFace(SLOT_2_OUTPUT_FLUID.side(), SLOT_2_OUTPUT_FLUID.posInMultiblock().m_7494_()));
            this.outputHandlerLeft = new StoredCapability((Object)new WrappingItemHandler((IItemHandler)this.inventory, false, true, new WrappingItemHandler.IntRange(2, 3)));
            this.outputHandlerRight = new StoredCapability((Object)new WrappingItemHandler((IItemHandler)this.inventory, false, true, new WrappingItemHandler.IntRange(5, 6)));
            this.cachedRecipeLeft = CachedRecipe.cached(RevFurnaceRecipe::findRecipe, (Supplier)getLevel, () -> this.inventory.getStackInSlot(0));
            this.cachedRecipeRight = CachedRecipe.cached(RevFurnaceRecipe::findRecipe, (Supplier)getLevel, () -> this.inventory.getStackInSlot(3));
            this.furnace = new IGRevFurnaceHandler<RevFurnaceRecipe>(1, List.of(new IGRevFurnaceHandler.RevInputSlot<RevFurnaceRecipe>(r -> r.input, 0)), List.of(new IGRevFurnaceHandler.RevOutputSlot<RevFurnaceRecipe>(r -> r.result, 2)), r -> r.time, 4, List.of(new IGRevFurnaceHandler.RevInputSlot<RevFurnaceRecipe>(r -> r.input, 3)), List.of(new IGRevFurnaceHandler.RevOutputSlot<RevFurnaceRecipe>(r -> r.result, 5)), r -> r.time, ctx.getMarkDirtyRunnable());
            this.invCapLeft = new StoredCapability((Object)new WrappingItemHandler((IItemHandler)this.inventory, true, true, new WrappingItemHandler.IntRange(0, 2)));
            this.invCapRight = new StoredCapability((Object)new WrappingItemHandler((IItemHandler)this.inventory, true, true, new WrappingItemHandler.IntRange(3, 5)));
            this.fluidCap = new StoredCapability((Object)new ArrayFluidHandler(new IFluidTank[]{this.tank}, true, false, ctx.getMarkDirtyRunnable()));
        }

        public void addToTank(int amount) {
            if (amount > 0) {
                FluidStack resource = new FluidStack(IGRegistrationHolder.getFluid.apply(BlockCategoryFlags.FLUID.getRegistryKey(ChemicalEnum.SulfurDioxde)), amount);
                this.tank.fill(resource, IFluidHandler.FluidAction.EXECUTE);
            }
        }

        public void writeSaveNBT(CompoundTag nbt) {
            nbt.m_128365_("tank", (Tag)this.tank.writeToNBT(new CompoundTag()));
            nbt.m_128365_("inventory", this.inventory.serializeNBT());
            nbt.m_128365_("furnace", this.furnace.toNBT());
            nbt.m_128379_("active_left", this.active_left);
            nbt.m_128379_("active_right", this.active_right);
        }

        public void readSaveNBT(CompoundTag nbt) {
            this.inventory.deserializeNBT(nbt.m_128469_("inventory"));
            this.furnace.readNBT((Tag)nbt.m_128469_("furnace"));
            this.tank.readFromNBT(nbt.m_128469_("tank"));
            this.active_left = nbt.m_128471_("active_left");
            this.active_right = nbt.m_128471_("active_right");
        }

        public void readSyncNBT(CompoundTag nbt) {
            this.readSaveNBT(nbt);
        }

        public void writeSyncNBT(CompoundTag nbt) {
            this.writeSaveNBT(nbt);
        }

        public boolean isActive(int furnaceIndex) {
            return furnaceIndex == 0 ? this.active_left : this.active_right;
        }

        @Override
        public IItemHandlerModifiable getInventory() {
            return this.inventory;
        }

        @Override
        @Nullable
        public RevFurnaceRecipe getRecipeForInput(boolean isLeft) {
            return isLeft ? this.cachedRecipeLeft.get() : this.cachedRecipeRight.get();
        }

        @Override
        public int getProcessSpeed(IMultiblockLevel level) {
            int i = 1;
            for (BlockPos offset : HEATER_OFFSETS) {
                BlastFurnacePreheaterBlockEntity preheater = this.getPreheater(level, offset);
                if (preheater == null) continue;
                i += preheater.doSpeedup();
            }
            return i;
        }

        @Nullable
        public BlastFurnacePreheaterBlockEntity getPreheater(IMultiblockLevel level, BlockPos pos) {
            BlastFurnacePreheaterBlockEntity heater;
            BlockEntity te = level.getBlockEntity(pos);
            BlastFurnacePreheaterBlockEntity var10000 = te instanceof BlastFurnacePreheaterBlockEntity ? (heater = (BlastFurnacePreheaterBlockEntity)te) : null;
            return var10000;
        }

        public GetterAndSetter<Boolean> preheaterActive(IMultiblockLevel level, int index) {
            return GetterAndSetter.getterOnly(() -> {
                BlastFurnacePreheaterBlockEntity heater = this.getPreheater(level, HEATER_OFFSETS[index]);
                return heater != null && heater.active;
            });
        }

        @Override
        public int getBurnTimeOf(Level level, ItemStack fuel) {
            return BlastFurnaceFuel.getBlastFuelTime((Level)level, (ItemStack)fuel);
        }

        @Override
        public void turnOff(IMultiblockLevel level, boolean isLeft) {
            for (BlockPos offset : HEATER_OFFSETS) {
                BlastFurnacePreheaterBlockEntity preheater = this.getPreheater(level, offset);
                if (preheater == null) continue;
                preheater.turnOff();
            }
            if (isLeft) {
                this.active_left = false;
                return;
            }
            this.active_right = false;
        }

        public ContainerData getStateView() {
            return this.furnace.stateView;
        }

        public FluidTank getTank() {
            return this.tank;
        }

        @Override
        public void invalidate(@NotNull IMultiblockContext<?> ctx) {
            this.outputHandlerRight.get(ctx).invalidate();
            this.outputHandlerLeft.get(ctx).invalidate();
            this.fluidCap.get(ctx).invalidate();
            this.invCapLeft.get(ctx).invalidate();
            this.invCapRight.get(ctx).invalidate();
        }

        private static /* synthetic */ boolean lambda$new$3(Supplier getLevel, ItemStack i) {
            return BlastFurnaceFuel.isValidBlastFuel((Level)((Level)getLevel.get()), (ItemStack)i);
        }

        private static /* synthetic */ boolean lambda$new$2(Supplier getLevel, ItemStack i) {
            return RevFurnaceRecipe.findRecipe((Level)getLevel.get(), i, null) != null;
        }

        private static /* synthetic */ boolean lambda$new$1(Supplier getLevel, ItemStack i) {
            return BlastFurnaceFuel.isValidBlastFuel((Level)((Level)getLevel.get()), (ItemStack)i);
        }

        private static /* synthetic */ boolean lambda$new$0(Supplier getLevel, ItemStack i) {
            return RevFurnaceRecipe.findRecipe((Level)getLevel.get(), i, null) != null;
        }
    }
}

