/*
 * Decompiled with CFR 0.152.
 */
package com.igteam.immersivegeology.common.block.multiblocks.logic;

import blusunrize.immersiveengineering.api.energy.AveragingEnergyStorage;
import blusunrize.immersiveengineering.api.multiblocks.blocks.component.IClientTickableComponent;
import blusunrize.immersiveengineering.api.multiblocks.blocks.component.IServerTickableComponent;
import blusunrize.immersiveengineering.api.multiblocks.blocks.component.RedstoneControl;
import blusunrize.immersiveengineering.api.multiblocks.blocks.env.IInitialMultiblockContext;
import blusunrize.immersiveengineering.api.multiblocks.blocks.env.IMultiblockContext;
import blusunrize.immersiveengineering.api.multiblocks.blocks.util.CapabilityPosition;
import blusunrize.immersiveengineering.api.multiblocks.blocks.util.MBInventoryUtils;
import blusunrize.immersiveengineering.api.multiblocks.blocks.util.MultiblockFace;
import blusunrize.immersiveengineering.api.multiblocks.blocks.util.RelativeBlockFace;
import blusunrize.immersiveengineering.api.multiblocks.blocks.util.ShapeType;
import blusunrize.immersiveengineering.api.multiblocks.blocks.util.StoredCapability;
import blusunrize.immersiveengineering.api.utils.CapabilityReference;
import blusunrize.immersiveengineering.common.blocks.multiblocks.process.MultiblockProcess;
import blusunrize.immersiveengineering.common.blocks.multiblocks.process.MultiblockProcessor;
import blusunrize.immersiveengineering.common.blocks.multiblocks.process.ProcessContext;
import blusunrize.immersiveengineering.common.util.inventory.SlotwiseItemHandler;
import blusunrize.immersiveengineering.common.util.inventory.WrappingItemHandler;
import com.igteam.immersivegeology.common.block.multiblocks.logic.helper.IGMultiblockState;
import com.igteam.immersivegeology.common.block.multiblocks.logic.helper.ISkinnableMultiblockLogic;
import com.igteam.immersivegeology.common.block.multiblocks.logic.helper.RotaryKilnHeatState;
import com.igteam.immersivegeology.common.block.multiblocks.recipe.RotaryKilnRecipe;
import com.igteam.immersivegeology.common.block.multiblocks.recipe.process.RotaryKilnProcess;
import com.igteam.immersivegeology.common.block.multiblocks.shapes.RotaryKilnShape;
import it.unimi.dsi.fastutil.doubles.DoubleArrayList;
import it.unimi.dsi.fastutil.doubles.DoubleList;
import it.unimi.dsi.fastutil.doubles.DoubleListIterator;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.items.IItemHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RotaryKilnLogic
implements ISkinnableMultiblockLogic<State>,
IServerTickableComponent<State>,
IClientTickableComponent<State> {
    public static final BlockPos REDSTONE_IN = new BlockPos(3, 1, 2);
    public static final int ENERGY_CAPACITY = 16000;
    private static final CapabilityPosition ENERGY_LEFT = new CapabilityPosition(5, 2, 0, RelativeBlockFace.UP);
    private static final CapabilityPosition ENERGY_MID = new CapabilityPosition(5, 2, 1, RelativeBlockFace.UP);
    private static final CapabilityPosition ENERGY_RIGHT = new CapabilityPosition(5, 2, 2, RelativeBlockFace.UP);
    private static final MultiblockFace OUTPUT_POS = new MultiblockFace(7, 1, 1, RelativeBlockFace.LEFT);
    private static final MultiblockFace INPUT_POS = new MultiblockFace(0, 2, 1, RelativeBlockFace.UP);
    private static final CapabilityPosition ITEM_OUTPUT_CAP = new CapabilityPosition(7, 1, 1, RelativeBlockFace.LEFT);
    private static final CapabilityPosition ITEM_INPUT_CAP = new CapabilityPosition(0, 2, 1, RelativeBlockFace.UP);
    public static final int NUM_SLOTS = 15;
    public static final int LV_HEAT_CAP = 30;
    public static final int MV_HEAT_CAP = 75;
    public static final int HV_HEAT_CAP = 120;
    public static final int EHV_HEAT_CAP = 165;
    private static final int BASE_LV_ENERGY = 50;
    private static final int BASE_MV_ENERGY = 750;
    private static final int BASE_HV_ENERGY = 3000;
    private static final int BASE_EHV_ENERGY = 12000;
    private int processIndex = 0;
    private static final float PASSIVE_COOL_RATE = 0.05f;
    private static final float BASE_HEAT_RATE = 0.2f;
    int nextPacketIndex = 0;

    public void tickClient(IMultiblockContext<State> iMultiblockContext) {
        State state = (State)iMultiblockContext.getState();
    }

    public void dropExtraItems(State state, Consumer<ItemStack> drop) {
        MBInventoryUtils.dropItems((IItemHandler)state.getInventory(), drop);
    }

    public void tickServer(IMultiblockContext<State> context) {
        RotaryKilnRecipe recipe;
        this.balanceEnergy(context);
        State state = (State)context.getState();
        Level level = context.getLevel().getRawLevel();
        int qSize = state.getProcessorQueue().size();
        if (qSize > 0 && state.rsState.isEnabled(context)) {
            state.tube_rotation += 0.5f;
            state.isActive = true;
            context.requestMasterBESync();
        }
        if (state.isActive && qSize == 0) {
            state.isActive = false;
            context.requestMasterBESync();
        }
        if (state.tube_rotation % 90.0f != 0.0f & !state.isActive) {
            state.tube_rotation += 0.5f;
            context.requestMasterBESync();
        }
        state.processor.tickServer((ProcessContext)state, context.getLevel(), state.rsState.isEnabled(context));
        this.provideHeat(context);
        if (state.processor.getQueueSize() > 7) {
            return;
        }
        ItemStack inputSlot = state.inventory.getStackInSlot(0).m_41777_();
        if (!inputSlot.m_41619_() && (recipe = RotaryKilnRecipe.findRecipe(level, inputSlot)) != null) {
            for (int i = 1; i < 8; ++i) {
                if (!state.inventory.getStackInSlot(i).m_41619_()) continue;
                this.processIndex = i;
                break;
            }
            RotaryKilnProcess process = new RotaryKilnProcess(recipe, this.processIndex);
            int rCount = recipe.itemIn.getCount();
            process.setInputAmounts(new int[]{rCount});
            if (state.processor.addProcessToQueue((MultiblockProcess)process, level, true) && state.inventory.getStackInSlot(this.processIndex).m_41619_()) {
                state.processor.addProcessToQueue((MultiblockProcess)process, level, false);
                state.inventory.setStackInSlot(this.processIndex, inputSlot.m_255036_(rCount));
                inputSlot.m_41774_(rCount);
                state.inventory.setStackInSlot(0, inputSlot);
                context.markMasterDirty();
            }
        }
    }

    public void provideHeat(IMultiblockContext<State> context) {
        State state = (State)context.getState();
        state.heatState = this.determineHeatState(context);
        state.heatState.execute(context);
        if (state.heatLevel < 0.0f) {
            state.heatLevel = 0.0f;
        }
        context.markDirtyAndSync();
    }

    private RotaryKilnHeatState determineHeatState(IMultiblockContext<State> context) {
        State state = (State)context.getState();
        Level level = context.getLevel().getRawLevel();
        boolean isActive = state.rsState.isEnabled(context);
        if (!isActive) {
            return RotaryKilnHeatState.MACHINE_OFF;
        }
        int storedEnergy = state.total_energy.getEnergyStored();
        int avgInput = state.getAveragePower();
        float currentHeat = state.getHeat();
        float target_heat = state.getTargetHeat();
        if (avgInput > 0) {
            int recipeHeatTarget = RotaryKilnLogic.convertAvePowerToHeat(avgInput);
            List<MultiblockProcess<RotaryKilnRecipe, ProcessContext.ProcessContextInMachine<RotaryKilnRecipe>>> queue = state.getProcessorQueue();
            if (queue != null && !queue.isEmpty()) {
                List<RotaryKilnRecipe> recipes = queue.stream().map(p -> (RotaryKilnRecipe)p.getRecipe(level)).toList();
                int recipeHeat = 0;
                for (RotaryKilnRecipe r : recipes) {
                    int h;
                    if (r == null || recipeHeat >= (h = r.getHeatRequired())) continue;
                    recipeHeat = h;
                }
                if (recipeHeatTarget < recipeHeat) {
                    recipeHeatTarget = recipeHeat;
                }
            }
            if ((float)recipeHeatTarget != target_heat) {
                state.targetHeat = recipeHeatTarget;
            }
            if (currentHeat < (float)recipeHeatTarget) {
                return RotaryKilnHeatState.HEATING_UP;
            }
            if (currentHeat > (float)(recipeHeatTarget + 7)) {
                return RotaryKilnHeatState.COOLING_DOWN;
            }
            if (!state.getProcessorQueue().isEmpty()) {
                return RotaryKilnHeatState.RUNNING_RECIPE;
            }
        }
        return RotaryKilnHeatState.MAINTAINING_HEAT;
    }

    private static int convertAvePowerToHeat(int avgInput) {
        if (avgInput > 0 && avgInput < 750) {
            return 30;
        }
        if (avgInput > 750 && avgInput < 3000) {
            return 75;
        }
        if (avgInput > 3000 && avgInput < 12000) {
            return 120;
        }
        if (avgInput > 12000) {
            return 165;
        }
        return 0;
    }

    private static List<RotaryKilnRecipe> getActiveRecipes(State state, Level level) {
        return state.processor.getQueue().stream().map(q -> (RotaryKilnRecipe)q.getRecipe(level)).filter(Objects::nonNull).toList();
    }

    private void balanceEnergy(IMultiblockContext<State> context) {
        State state = (State)context.getState();
        int totalEnergy = state.getEnergy().getEnergyStored();
        int capLV = 16000;
        int capMV = 32000;
        int capHV = 64000;
        int energyLV = Math.min(totalEnergy, capLV);
        int remaining = totalEnergy - energyLV;
        int energyMV = Math.min(remaining, capMV);
        int energyHV = Math.min(remaining -= energyMV, capHV);
        state.energy_lv.setStoredEnergy(energyLV);
        state.energy_mv.setStoredEnergy(energyMV);
        state.energy_hv.setStoredEnergy(energyHV);
        int averageInsertion = state.total_energy.getAverageInsertion();
        if (this.nextPacketIndex >= state.lastEnergyPackets.size()) {
            state.lastEnergyPackets.add((double)Math.max(0, averageInsertion));
        } else {
            state.lastEnergyPackets.set(this.nextPacketIndex, (double)Math.max(0, averageInsertion));
        }
        this.nextPacketIndex = (this.nextPacketIndex + 1) % 20;
    }

    public State createInitialState(IInitialMultiblockContext<State> capability) {
        return new State(capability);
    }

    public <T> LazyOptional<T> getCapability(IMultiblockContext<State> ctx, CapabilityPosition position, Capability<T> cap) {
        State state = (State)ctx.getState();
        if (cap == ForgeCapabilities.ENERGY && (ENERGY_LEFT.equals((Object)position) || ENERGY_MID.equals((Object)position) || ENERGY_RIGHT.equals((Object)position))) {
            return state.energyCap.cast(ctx);
        }
        if (cap == ForgeCapabilities.ITEM_HANDLER) {
            if (ITEM_INPUT_CAP.equals((Object)position)) {
                return state.itemInputCap.cast(ctx);
            }
            if (ITEM_OUTPUT_CAP.equals((Object)position)) {
                return state.outputHandler.cast(ctx);
            }
        }
        return LazyOptional.empty();
    }

    public Function<BlockPos, VoxelShape> shapeGetter(ShapeType shapeType) {
        return RotaryKilnShape.GETTER;
    }

    public static class State
    implements IGMultiblockState,
    ProcessContext.ProcessContextInMachine<RotaryKilnRecipe> {
        public final AveragingEnergyStorage total_energy = new AveragingEnergyStorage(112000);
        public final AveragingEnergyStorage energy_lv = new AveragingEnergyStorage(16000);
        public final AveragingEnergyStorage energy_mv = new AveragingEnergyStorage(32000);
        public final AveragingEnergyStorage energy_hv = new AveragingEnergyStorage(64000);
        public final DoubleList lastEnergyPackets = new DoubleArrayList(20);
        public final RedstoneControl.RSState rsState = RedstoneControl.RSState.enabledByDefault();
        public final SlotwiseItemHandler inventory;
        private final CapabilityReference<IItemHandler> output;
        private final StoredCapability<IItemHandler> outputHandler;
        private final StoredCapability<IItemHandler> itemInputCap;
        private float tube_rotation;
        private boolean isActive;
        private final StoredCapability<IEnergyStorage> energyCap = new StoredCapability((Object)this.total_energy);
        private float heatLevel = 0.0f;
        private float targetHeat = 0.0f;
        private RotaryKilnHeatState heatState;
        private final MultiblockProcessor.InMachineProcessor<RotaryKilnRecipe> processor;
        Runnable markDirty;

        /*
         * Issues handling annotations - annotations may be inaccurate
         */
        public State(IInitialMultiblockContext<State> ctx) {
            Runnable markDirty;
            this.processor = new MultiblockProcessor.InMachineProcessor(7, 0.0f, 7, ctx.getMarkDirtyRunnable(), (arg_0, arg_1) -> RotaryKilnRecipe.RECIPES.getById(arg_0, arg_1));
            this.tube_rotation = 0.0f;
            this.isActive = false;
            this.heatState = RotaryKilnHeatState.MACHINE_OFF;
            @Nullable Supplier levelGetter = ctx.levelSupplier();
            this.markDirty = markDirty = ctx.getMarkDirtyRunnable();
            this.inventory = new SlotwiseItemHandler(List.of(new SlotwiseItemHandler.IOConstraint(true, arg_0 -> State.lambda$new$0((Supplier)levelGetter, arg_0)), new SlotwiseItemHandler.IOConstraint(false, arg_0 -> State.lambda$new$1((Supplier)levelGetter, arg_0)), new SlotwiseItemHandler.IOConstraint(false, arg_0 -> State.lambda$new$2((Supplier)levelGetter, arg_0)), new SlotwiseItemHandler.IOConstraint(false, arg_0 -> State.lambda$new$3((Supplier)levelGetter, arg_0)), new SlotwiseItemHandler.IOConstraint(false, arg_0 -> State.lambda$new$4((Supplier)levelGetter, arg_0)), new SlotwiseItemHandler.IOConstraint(false, arg_0 -> State.lambda$new$5((Supplier)levelGetter, arg_0)), new SlotwiseItemHandler.IOConstraint(false, arg_0 -> State.lambda$new$6((Supplier)levelGetter, arg_0)), new SlotwiseItemHandler.IOConstraint(false, arg_0 -> State.lambda$new$7((Supplier)levelGetter, arg_0)), SlotwiseItemHandler.IOConstraint.OUTPUT, SlotwiseItemHandler.IOConstraint.OUTPUT, SlotwiseItemHandler.IOConstraint.OUTPUT, SlotwiseItemHandler.IOConstraint.OUTPUT, SlotwiseItemHandler.IOConstraint.OUTPUT, SlotwiseItemHandler.IOConstraint.OUTPUT, SlotwiseItemHandler.IOConstraint.OUTPUT), markDirty);
            this.output = ctx.getCapabilityAt(ForgeCapabilities.ITEM_HANDLER, OUTPUT_POS);
            this.outputHandler = new StoredCapability((Object)new WrappingItemHandler((IItemHandler)this.inventory, false, true, new WrappingItemHandler.IntRange(8, 14)));
            this.itemInputCap = new StoredCapability((Object)new WrappingItemHandler((IItemHandler)this.inventory, true, false, new WrappingItemHandler.IntRange(0, 1)));
        }

        public SlotwiseItemHandler getInventory() {
            return this.inventory;
        }

        public int[] getOutputSlots() {
            return new int[]{8, 9, 10, 11, 12, 13, 14};
        }

        public void onProcessFinish(MultiblockProcess<RotaryKilnRecipe, ?> process, Level level) {
            if (process instanceof RotaryKilnProcess) {
                RotaryKilnProcess rotaryKilnProcess = (RotaryKilnProcess)process;
                int index = rotaryKilnProcess.getSlot();
                this.inventory.setStackInSlot(index, ItemStack.f_41583_);
                this.markDirty.run();
            }
        }

        public void writeSaveNBT(CompoundTag nbt) {
            nbt.m_128365_("energy_lv", this.energy_lv.serializeNBT());
            nbt.m_128365_("energy_mv", this.energy_mv.serializeNBT());
            nbt.m_128365_("energy_hv", this.energy_hv.serializeNBT());
            nbt.m_128365_("energy", this.total_energy.serializeNBT());
            nbt.m_128365_("processor", this.processor.toNBT());
            nbt.m_128350_("tube_rotation", this.tube_rotation);
            nbt.m_128365_("inventory", this.inventory.serializeNBT());
            nbt.m_128379_("is_active", this.isActive);
            nbt.m_128350_("target_heat", this.targetHeat);
            nbt.m_128350_("heat", this.heatLevel);
            nbt.m_128405_("heat_state", this.heatState.ordinal());
            CompoundTag data = new CompoundTag();
            int i = 0;
            for (Double d : this.lastEnergyPackets) {
                data.m_128347_("i" + i++, d.doubleValue());
            }
            nbt.m_128365_("energy_input_packets", (Tag)data);
        }

        public void readSaveNBT(CompoundTag nbt) {
            this.energy_lv.deserializeNBT(nbt.m_128423_("energy_lv"));
            this.energy_mv.deserializeNBT(nbt.m_128423_("energy_mv"));
            this.energy_hv.deserializeNBT(nbt.m_128423_("energy_hv"));
            this.total_energy.deserializeNBT(nbt.m_128423_("energy"));
            this.tube_rotation = nbt.m_128457_("tube_rotation");
            this.inventory.deserializeNBT(nbt.m_128469_("inventory"));
            this.processor.fromNBT(nbt.m_128423_("processor"), RotaryKilnProcess::new);
            this.isActive = nbt.m_128471_("is_active");
            this.targetHeat = nbt.m_128457_("target_heat");
            this.heatLevel = nbt.m_128457_("heat");
            this.heatState = RotaryKilnHeatState.values()[nbt.m_128451_("heat_state")];
            CompoundTag data = nbt.m_128469_("energy_input_packets");
            int size = data.m_128440_();
            this.lastEnergyPackets.clear();
            for (int i = 0; i < size; ++i) {
                this.lastEnergyPackets.add(i, data.m_128459_("i" + i));
            }
        }

        public void writeSyncNBT(CompoundTag nbt) {
            this.writeSaveNBT(nbt);
        }

        public void readSyncNBT(CompoundTag nbt) {
            this.readSaveNBT(nbt);
        }

        public float getHeat() {
            return this.heatLevel;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int getAveragePower() {
            if (this.lastEnergyPackets.isEmpty()) {
                return 0;
            }
            double sum = 0.0;
            DoubleList doubleList = this.lastEnergyPackets;
            synchronized (doubleList) {
                DoubleListIterator doubleListIterator = this.lastEnergyPackets.iterator();
                while (doubleListIterator.hasNext()) {
                    double transfer = (Double)doubleListIterator.next();
                    sum += transfer;
                }
            }
            return Math.max(0, (int)Math.round(sum / (double)this.lastEnergyPackets.size()) - 1);
        }

        public AveragingEnergyStorage getEnergy() {
            return this.total_energy;
        }

        public AveragingEnergyStorage getEnergyHV() {
            return this.energy_hv;
        }

        public AveragingEnergyStorage getEnergyMV() {
            return this.energy_mv;
        }

        public AveragingEnergyStorage getEnergyLV() {
            return this.energy_lv;
        }

        public float getRotation() {
            return this.tube_rotation;
        }

        public List<MultiblockProcess<RotaryKilnRecipe, ProcessContext.ProcessContextInMachine<RotaryKilnRecipe>>> getProcessorQueue() {
            return this.processor.getQueue();
        }

        public boolean isActive() {
            return this.isActive;
        }

        public boolean hasRequiredHeat(int recipeHeat) {
            boolean flag;
            int lowerBound = recipeHeat - 7;
            int upperBound = recipeHeat + 7;
            boolean bl = flag = this.heatLevel >= (float)lowerBound && this.heatLevel <= (float)upperBound && this.heatState.equals((Object)RotaryKilnHeatState.RUNNING_RECIPE);
            if (flag) {
                this.heatLevel -= 0.1f;
            }
            return flag;
        }

        public float getTargetHeat() {
            return this.targetHeat;
        }

        public void modifyHeat(float v) {
            boolean invalid;
            float newHeat = this.heatLevel + v;
            boolean bl = invalid = newHeat < 0.0f || newHeat > 170.0f;
            if (!invalid) {
                this.heatLevel = newHeat;
            }
        }

        public void setHeat(float v) {
            this.heatLevel = v;
        }

        @Override
        public void invalidate(@NotNull IMultiblockContext<?> ctx) {
            this.energyCap.get(ctx).invalidate();
            this.outputHandler.get(ctx).invalidate();
            this.itemInputCap.get(ctx).invalidate();
        }

        private static /* synthetic */ boolean lambda$new$7(Supplier levelGetter, ItemStack i) {
            return RotaryKilnRecipe.findRecipe((Level)levelGetter.get(), i) != null;
        }

        private static /* synthetic */ boolean lambda$new$6(Supplier levelGetter, ItemStack i) {
            return RotaryKilnRecipe.findRecipe((Level)levelGetter.get(), i) != null;
        }

        private static /* synthetic */ boolean lambda$new$5(Supplier levelGetter, ItemStack i) {
            return RotaryKilnRecipe.findRecipe((Level)levelGetter.get(), i) != null;
        }

        private static /* synthetic */ boolean lambda$new$4(Supplier levelGetter, ItemStack i) {
            return RotaryKilnRecipe.findRecipe((Level)levelGetter.get(), i) != null;
        }

        private static /* synthetic */ boolean lambda$new$3(Supplier levelGetter, ItemStack i) {
            return RotaryKilnRecipe.findRecipe((Level)levelGetter.get(), i) != null;
        }

        private static /* synthetic */ boolean lambda$new$2(Supplier levelGetter, ItemStack i) {
            return RotaryKilnRecipe.findRecipe((Level)levelGetter.get(), i) != null;
        }

        private static /* synthetic */ boolean lambda$new$1(Supplier levelGetter, ItemStack i) {
            return RotaryKilnRecipe.findRecipe((Level)levelGetter.get(), i) != null;
        }

        private static /* synthetic */ boolean lambda$new$0(Supplier levelGetter, ItemStack i) {
            return RotaryKilnRecipe.findRecipe((Level)levelGetter.get(), i) != null;
        }
    }
}

