/*
 * Decompiled with CFR 0.152.
 */
package com.igteam.immersivegeology.common.block.multiblocks.logic;

import blusunrize.immersiveengineering.api.crafting.IngredientWithSize;
import blusunrize.immersiveengineering.api.crafting.MultiblockRecipe;
import blusunrize.immersiveengineering.api.energy.AveragingEnergyStorage;
import blusunrize.immersiveengineering.api.multiblocks.blocks.component.IClientTickableComponent;
import blusunrize.immersiveengineering.api.multiblocks.blocks.component.IServerTickableComponent;
import blusunrize.immersiveengineering.api.multiblocks.blocks.component.RedstoneControl;
import blusunrize.immersiveengineering.api.multiblocks.blocks.env.IInitialMultiblockContext;
import blusunrize.immersiveengineering.api.multiblocks.blocks.env.IMultiblockContext;
import blusunrize.immersiveengineering.api.multiblocks.blocks.env.IMultiblockLevel;
import blusunrize.immersiveengineering.api.multiblocks.blocks.util.CapabilityPosition;
import blusunrize.immersiveengineering.api.multiblocks.blocks.util.MultiblockFace;
import blusunrize.immersiveengineering.api.multiblocks.blocks.util.RelativeBlockFace;
import blusunrize.immersiveengineering.api.multiblocks.blocks.util.ShapeType;
import blusunrize.immersiveengineering.api.multiblocks.blocks.util.StoredCapability;
import blusunrize.immersiveengineering.api.utils.CapabilityReference;
import blusunrize.immersiveengineering.common.blocks.multiblocks.process.MultiblockProcess;
import blusunrize.immersiveengineering.common.blocks.multiblocks.process.MultiblockProcessInMachine;
import blusunrize.immersiveengineering.common.blocks.multiblocks.process.MultiblockProcessor;
import blusunrize.immersiveengineering.common.blocks.multiblocks.process.ProcessContext;
import blusunrize.immersiveengineering.common.fluids.ArrayFluidHandler;
import blusunrize.immersiveengineering.common.util.Utils;
import blusunrize.immersiveengineering.common.util.inventory.SlotwiseItemHandler;
import blusunrize.immersiveengineering.common.util.inventory.WrappingItemHandler;
import com.igteam.immersivegeology.common.block.multiblocks.logic.helper.BasicChemicalProcessor;
import com.igteam.immersivegeology.common.block.multiblocks.logic.helper.IGMultiblockState;
import com.igteam.immersivegeology.common.block.multiblocks.logic.helper.ISkinnableMultiblockLogic;
import com.igteam.immersivegeology.common.block.multiblocks.recipe.BasicChemicalRecipe;
import com.igteam.immersivegeology.common.block.multiblocks.recipe.ChemicalRepairRecipe;
import com.igteam.immersivegeology.common.block.multiblocks.shapes.SmallChemicalReactorShape;
import com.igteam.immersivegeology.common.network.IGPacketHandler;
import com.igteam.immersivegeology.common.network.msg.MessageSCRFail;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidTank;
import net.minecraftforge.items.IItemHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SmallChemicalReactorLogic
implements ISkinnableMultiblockLogic<State>,
IServerTickableComponent<State>,
IClientTickableComponent<State> {
    public static final BlockPos REDSTONE_IN = new BlockPos(0, 1, 2);
    public static final int ENERGY_CAPACITY = 24000;
    private static final Set<CapabilityPosition> ENERGY_POS;
    private static final MultiblockFace ITEM_OUTPUT;
    private static final MultiblockFace ITEM_INPUT_OUTPUT;
    private static final MultiblockFace FLUID_OUTPUT;
    private static final CapabilityPosition FLUID_OUTPUT_CAP;
    private static final Set<CapabilityPosition> FLUID_INPUT_CAPS;
    private static final Set<BlockPos> FLUID_INPUTS;
    private static final BlockPos ITEM_INPUT;

    public void tickClient(IMultiblockContext<State> iMultiblockContext) {
    }

    public void tickServer(IMultiblockContext<State> ctx) {
        int repairAmount;
        boolean validRepair;
        State state = (State)ctx.getState();
        Level rawLevel = ctx.getLevel().getRawLevel();
        boolean isMirrored = ctx.getLevel().getOrientation().mirrored();
        boolean isEnabled = state.rsState.isEnabled(ctx);
        if (state.damage > 99.0f) {
            return;
        }
        if (state.tanks.output.getFluid().getAmount() > 0) {
            this.drainOutputTank(state, ctx, state.fluidOutput);
        }
        if (state.tanks.output.getSpace() == 0) {
            return;
        }
        if (isEnabled) {
            SmallChemicalReactorLogic.insertRecipeToProcess(state, ctx);
        }
        state.processor.tickServer(state, ctx.getLevel(), state.rsState.isEnabled(ctx));
        ItemStack repairStack = state.inventory.getStackInSlot(2);
        if (!repairStack.m_41619_() && (validRepair = ChemicalRepairRecipe.isValidRepairItem(rawLevel, repairStack)) && state.damage >= (float)(repairAmount = ChemicalRepairRecipe.getRepairAmount(rawLevel, repairStack))) {
            repairStack.m_41774_(1);
            if (repairStack.m_41613_() == 0) {
                repairStack = ItemStack.f_41583_;
            }
            state.inventory.setStackInSlot(2, repairStack);
            state.damage -= (float)repairAmount;
            ctx.requestMasterBESync();
        }
        if (!state.rsState.isEnabled(ctx)) {
            ItemStack stack;
            ItemStack itemStack = state.inventory.getStackInSlot(0);
            if (!itemStack.m_41619_() && state.processor.getQueue().stream().noneMatch(q -> {
                BasicChemicalRecipe rec = (BasicChemicalRecipe)q.getRecipe(ctx.getLevel().getRawLevel());
                if (rec != null) {
                    return rec.itemInput.testIgnoringSize(itemStack);
                }
                return true;
            }) && (stack = Utils.insertStackIntoInventory(state.input_output, (ItemStack)itemStack.m_255036_(1), (boolean)true)).m_41619_()) {
                Utils.insertStackIntoInventory(state.input_output, (ItemStack)itemStack.m_255036_(1), (boolean)false);
                itemStack.m_41774_(1);
                ctx.requestMasterBESync();
            }
            if (state.processor.getQueueSize() > 0) {
                state.clearProcessor();
                ctx.requestMasterBESync();
            }
        }
    }

    private static void insertRecipeToProcess(State state, IMultiblockContext<State> ctx) {
        IMultiblockLevel mbLevel = ctx.getLevel();
        Level level = mbLevel.getRawLevel();
        SmallChemicalReactorTanks fluidTanks = state.tanks;
        BasicChemicalRecipe recipe = state.getRecipeForInputs(level);
        if (recipe != null) {
            boolean hasInputForNewRecipe;
            MultiblockProcessInMachine process = new MultiblockProcessInMachine((MultiblockRecipe)recipe, new int[]{0});
            process.setInputAmounts(new int[]{recipe.itemInput.getCount()});
            int size = (fluidTanks.leftInput().isEmpty() ? 0 : 1) + (fluidTanks.rightInput().isEmpty() ? 0 : 1);
            int[] intArray = new int[size];
            int index = 0;
            if (!fluidTanks.leftInput().isEmpty()) {
                intArray[index++] = 0;
            }
            if (!fluidTanks.rightInput().isEmpty()) {
                intArray[index] = 1;
            }
            ItemStack inputStack = state.inventory.getStackInSlot(0).m_41777_();
            int recipeInputRequirements = 0;
            List processQueue = state.processor.getQueue();
            for (MultiblockProcess p : processQueue) {
                IngredientWithSize input;
                BasicChemicalRecipe checkRecipe = (BasicChemicalRecipe)p.getRecipe(level);
                if (checkRecipe == null || !(input = checkRecipe.itemInput).testIgnoringSize(inputStack)) continue;
                recipeInputRequirements += input.getCount();
            }
            boolean bl = hasInputForNewRecipe = inputStack.m_41613_() >= recipeInputRequirements + recipe.itemInput.getCount();
            if (hasInputForNewRecipe) {
                process.setInputTanks(intArray);
                if (state.processor.addProcessToQueue((MultiblockProcess)process, level, true)) {
                    state.processor.addProcessToQueue((MultiblockProcess)process, level, false);
                    ctx.markMasterDirty();
                }
            }
        } else if (state.processor.getQueueSize() > 0) {
            state.clearProcessor();
            ctx.requestMasterBESync();
        }
    }

    private void drainOutputTank(State state, IMultiblockContext<State> context, CapabilityReference<IFluidHandler> outputRef) {
        int outSize = Math.min(1000, state.tanks.output().getFluidAmount());
        FluidStack out = Utils.copyFluidStackWithAmount((FluidStack)state.tanks.output().getFluid(), (int)outSize, (boolean)false);
        IFluidHandler output = (IFluidHandler)outputRef.getNullable();
        if (output == null) {
            return;
        }
        int accepted = output.fill(out, IFluidHandler.FluidAction.SIMULATE);
        if (accepted > 0) {
            int drained = output.fill(Utils.copyFluidStackWithAmount((FluidStack)out, (int)Math.min(out.getAmount(), accepted), (boolean)false), IFluidHandler.FluidAction.EXECUTE);
            state.tanks.output().drain(drained, IFluidHandler.FluidAction.EXECUTE);
            context.markMasterDirty();
            context.requestMasterBESync();
        }
    }

    public <T> LazyOptional<T> getCapability(IMultiblockContext<State> ctx, CapabilityPosition position, Capability<T> cap) {
        State state = (State)ctx.getState();
        if (cap == ForgeCapabilities.ENERGY && (position.side() == null || ENERGY_POS.contains(position))) {
            return state.energyCap.cast(ctx);
        }
        if (cap == ForgeCapabilities.FLUID_HANDLER) {
            if (FLUID_INPUT_CAPS.contains(position) && position.side() != null) {
                if (position.side().equals((Object)RelativeBlockFace.LEFT)) {
                    return state.inputCapFront.cast(ctx);
                }
                if (position.side().equals((Object)RelativeBlockFace.RIGHT)) {
                    return state.inputCapBack.cast(ctx);
                }
            }
            if (FLUID_OUTPUT_CAP.equals((Object)position)) {
                return state.outputCap.cast(ctx);
            }
        }
        if (cap == ForgeCapabilities.ITEM_HANDLER) {
            if (position.posInMultiblock().equals((Object)ITEM_INPUT)) {
                return state.itemInputCap.cast(ctx);
            }
            if (position.posInMultiblock().equals((Object)ITEM_OUTPUT.posInMultiblock()) && position.side() == ITEM_OUTPUT.face()) {
                return state.outputHandler.cast(ctx);
            }
        }
        return LazyOptional.empty();
    }

    public State createInitialState(IInitialMultiblockContext<State> capability) {
        return new State(capability);
    }

    public Function<BlockPos, VoxelShape> shapeGetter(ShapeType shapeType) {
        return SmallChemicalReactorShape.GETTER;
    }

    static {
        ITEM_INPUT = new BlockPos(2, 0, 0);
        ENERGY_POS = Set.of(new CapabilityPosition(0, 1, 0, RelativeBlockFace.UP));
        FLUID_OUTPUT = new MultiblockFace(3, 0, 0, RelativeBlockFace.LEFT);
        ITEM_OUTPUT = new MultiblockFace(2, 0, 2, RelativeBlockFace.BACK);
        ITEM_INPUT_OUTPUT = new MultiblockFace(2, 0, 2, RelativeBlockFace.BACK);
        FLUID_OUTPUT_CAP = new CapabilityPosition(3, 0, 0, RelativeBlockFace.LEFT);
        FLUID_INPUT_CAPS = Set.of(new CapabilityPosition(3, 0, 2, RelativeBlockFace.LEFT), new CapabilityPosition(0, 0, 1, RelativeBlockFace.RIGHT));
        FLUID_INPUTS = FLUID_INPUT_CAPS.stream().map(CapabilityPosition::posInMultiblock).collect(Collectors.toSet());
    }

    public static class State
    implements IGMultiblockState,
    ProcessContext.ProcessContextInMachine<BasicChemicalRecipe> {
        public final AveragingEnergyStorage energy = new AveragingEnergyStorage(24000);
        public float damage;
        private boolean isInvalidated = false;
        public final RedstoneControl.RSState rsState = RedstoneControl.RSState.enabledByDefault();
        public final SlotwiseItemHandler inventory;
        public final SmallChemicalReactorTanks tanks = new SmallChemicalReactorTanks();
        private final StoredCapability<IFluidHandler> inputCapBack;
        private final StoredCapability<IFluidHandler> inputCapFront;
        private final StoredCapability<IItemHandler> itemInputCap;
        private final StoredCapability<IItemHandler> outputHandler;
        private final StoredCapability<IFluidHandler> outputCap;
        private final StoredCapability<IEnergyStorage> energyCap;
        private final CapabilityReference<IItemHandler> input_output;
        private final CapabilityReference<IFluidHandler> fluidOutput;
        private final BasicChemicalProcessor processor;
        private final MultiblockProcessor.InMachineProcessor<BasicChemicalRecipe> dummy;

        /*
         * Issues handling annotations - annotations may be inaccurate
         */
        public State(IInitialMultiblockContext<State> ctx) {
            @Nullable Supplier getLevel = ctx.levelSupplier();
            Runnable markDirty = ctx.getMarkDirtyRunnable();
            this.damage = 0.0f;
            this.energyCap = new StoredCapability((Object)this.energy);
            this.inventory = new SlotwiseItemHandler(List.of(new SlotwiseItemHandler.IOConstraint(true, arg_0 -> State.lambda$new$0((Supplier)getLevel, arg_0)), SlotwiseItemHandler.IOConstraint.OUTPUT, new SlotwiseItemHandler.IOConstraint(true, arg_0 -> State.lambda$new$1((Supplier)getLevel, arg_0))), ctx.getMarkDirtyRunnable());
            this.input_output = ctx.getCapabilityAt(ForgeCapabilities.ITEM_HANDLER, ITEM_INPUT_OUTPUT);
            this.outputHandler = new StoredCapability((Object)new WrappingItemHandler((IItemHandler)this.inventory, false, true, new WrappingItemHandler.IntRange(1, 2)));
            this.fluidOutput = ctx.getCapabilityAt(ForgeCapabilities.FLUID_HANDLER, new MultiblockFace(FLUID_OUTPUT_CAP.side(), FLUID_OUTPUT_CAP.posInMultiblock().m_122029_()));
            this.processor = new BasicChemicalProcessor(4, 0.0f, 4, ctx.getMarkDirtyRunnable(), (arg_0, arg_1) -> BasicChemicalRecipe.RECIPES.getById(arg_0, arg_1));
            this.inputCapBack = new StoredCapability((Object)new ArrayFluidHandler(true, true, markDirty, new IFluidTank[]{this.tanks.leftInput}));
            this.inputCapFront = new StoredCapability((Object)new ArrayFluidHandler(true, true, markDirty, new IFluidTank[]{this.tanks.rightInput}));
            this.outputCap = new StoredCapability((Object)ArrayFluidHandler.drainOnly((IFluidTank)this.tanks.output, (Runnable)markDirty));
            this.itemInputCap = new StoredCapability((Object)this.inventory);
            this.dummy = new BasicChemicalProcessor(4, 0.0f, 4, ctx.getMarkDirtyRunnable(), (arg_0, arg_1) -> BasicChemicalRecipe.RECIPES.getById(arg_0, arg_1));
        }

        @Nullable
        public BasicChemicalRecipe getRecipeForInputs(Level level) {
            return BasicChemicalRecipe.findRecipe(level, this.tanks.leftInput.getFluid(), this.tanks.rightInput.getFluid(), this.inventory.getStackInSlot(0));
        }

        public boolean additionalCanProcessCheck(MultiblockProcess<BasicChemicalRecipe, ?> process, Level level) {
            return true;
        }

        public void readSaveNBT(CompoundTag nbt) {
            this.energy.deserializeNBT(nbt.m_128423_("energy"));
            this.tanks.readNBT(nbt.m_128469_("tanks"));
            this.inventory.deserializeNBT(nbt.m_128469_("inventory"));
            this.processor.fromNBT(nbt.m_128423_("processor"), MultiblockProcessInMachine::new);
            this.damage = nbt.m_128457_("damage");
            this.isInvalidated = nbt.m_128471_("invalid");
        }

        public void writeSaveNBT(CompoundTag nbt) {
            nbt.m_128365_("energy", this.energy.serializeNBT());
            nbt.m_128365_("tanks", this.tanks.toNBT());
            nbt.m_128365_("processor", this.processor.toNBT());
            nbt.m_128365_("inventory", this.inventory.serializeNBT());
            nbt.m_128350_("damage", this.damage);
            nbt.m_128379_("invalid", this.isInvalidated);
        }

        public void clearProcessor() {
            this.processor.fromNBT(this.dummy.toNBT(), MultiblockProcessInMachine::new);
        }

        public int[] getOutputTanks() {
            return new int[]{2};
        }

        public int[] getOutputSlots() {
            return new int[]{1};
        }

        public IFluidTank[] getInternalTanks() {
            return new FluidTank[]{this.tanks.leftInput, this.tanks.rightInput, this.tanks.output};
        }

        public SlotwiseItemHandler getInventory() {
            return this.inventory;
        }

        public SmallChemicalReactorTanks getChemicalReactorTanks() {
            return this.tanks;
        }

        public AveragingEnergyStorage getEnergy() {
            return this.energy;
        }

        public Supplier<Float> getDamage() {
            return () -> Float.valueOf(this.damage);
        }

        @Override
        public void invalidate(@NotNull IMultiblockContext<?> ctx) {
            if (!this.isInvalidated) {
                Object object = ctx.getState();
                if (object instanceof State) {
                    State state = (State)object;
                    boolean isMirrored = ctx.getLevel().getOrientation().mirrored();
                    if (state.damage > 1.0f) {
                        BlockPos realPos = ctx.getLevel().toAbsolute(new BlockPos(isMirrored ? 2 : 1, 1, 0));
                        IGPacketHandler.sendToServer(new MessageSCRFail(realPos, this.damage));
                    }
                }
                this.isInvalidated = true;
            }
            this.energyCap.get(ctx).invalidate();
            this.inputCapBack.get(ctx).invalidate();
            this.inputCapFront.get(ctx).invalidate();
            this.outputHandler.get(ctx).invalidate();
            this.itemInputCap.get(ctx).invalidate();
            this.outputCap.get(ctx).invalidate();
        }

        private static /* synthetic */ boolean lambda$new$1(Supplier getLevel, ItemStack i) {
            return ChemicalRepairRecipe.isValidRepairItem((Level)getLevel.get(), i);
        }

        private static /* synthetic */ boolean lambda$new$0(Supplier getLevel, ItemStack i) {
            return BasicChemicalRecipe.acceptableCatalyst((Level)getLevel.get(), i);
        }
    }

    public record SmallChemicalReactorTanks(FluidTank leftInput, FluidTank rightInput, FluidTank output) {
        private static final int TANK_BUFFER_CAPACITY = 8000;

        public SmallChemicalReactorTanks() {
            this(new FluidTank(8000), new FluidTank(8000), new FluidTank(8000));
        }

        public Tag toNBT() {
            CompoundTag tag = new CompoundTag();
            tag.m_128365_("leftIn", (Tag)this.leftInput.writeToNBT(new CompoundTag()));
            tag.m_128365_("rightIn", (Tag)this.rightInput.writeToNBT(new CompoundTag()));
            tag.m_128365_("out", (Tag)this.output.writeToNBT(new CompoundTag()));
            return tag;
        }

        public void readNBT(CompoundTag tag) {
            this.leftInput.readFromNBT(tag.m_128469_("leftIn"));
            this.rightInput.readFromNBT(tag.m_128469_("rightIn"));
            this.output.readFromNBT(tag.m_128469_("out"));
        }

        public BlockPos getLeftTankPos(boolean isMirrored) {
            BlockPos pos = new BlockPos(-4, 1, 0);
            if (isMirrored) {
                pos = new BlockPos(3, 1, 0);
            }
            return pos;
        }

        public BlockPos getRightTankPos(boolean isMirrored) {
            BlockPos pos = new BlockPos(3, 1, 1);
            if (isMirrored) {
                pos = new BlockPos(-4, 1, 1);
            }
            return pos;
        }

        public BlockPos getOutputTankPos(boolean isMirrored) {
            BlockPos pos = new BlockPos(-1, 1, 4);
            if (isMirrored) {
                pos = new BlockPos(0, 1, 4);
            }
            return pos;
        }

        public int getCapacity() {
            return 8000;
        }
    }
}

