/*
 * Decompiled with CFR 0.152.
 */
package com.igteam.immersivegeology.common.block.multiblocks.logic;

import blusunrize.immersiveengineering.api.energy.IRotationAcceptor;
import blusunrize.immersiveengineering.api.multiblocks.blocks.component.IClientTickableComponent;
import blusunrize.immersiveengineering.api.multiblocks.blocks.component.IServerTickableComponent;
import blusunrize.immersiveengineering.api.multiblocks.blocks.component.RedstoneControl;
import blusunrize.immersiveengineering.api.multiblocks.blocks.env.IInitialMultiblockContext;
import blusunrize.immersiveengineering.api.multiblocks.blocks.env.IMultiblockContext;
import blusunrize.immersiveengineering.api.multiblocks.blocks.util.CapabilityPosition;
import blusunrize.immersiveengineering.api.multiblocks.blocks.util.RelativeBlockFace;
import blusunrize.immersiveengineering.api.multiblocks.blocks.util.ShapeType;
import blusunrize.immersiveengineering.api.multiblocks.blocks.util.StoredCapability;
import blusunrize.immersiveengineering.api.utils.CapabilityReference;
import blusunrize.immersiveengineering.client.utils.TextUtils;
import blusunrize.immersiveengineering.common.blocks.multiblocks.logic.interfaces.MBOverlayText;
import blusunrize.immersiveengineering.common.fluids.ArrayFluidHandler;
import blusunrize.immersiveengineering.common.util.CachedRecipe;
import blusunrize.immersiveengineering.common.util.Utils;
import com.google.common.collect.ImmutableList;
import com.igteam.immersivegeology.common.block.multiblocks.logic.helper.IGMultiblockState;
import com.igteam.immersivegeology.common.block.multiblocks.logic.helper.ISkinnableMultiblockLogic;
import com.igteam.immersivegeology.common.block.multiblocks.recipe.TurbineFuel;
import com.igteam.immersivegeology.common.block.multiblocks.shapes.SteamTurbineShape;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Function;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidTank;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SteamTurbineLogic
implements ISkinnableMultiblockLogic<State>,
MBOverlayText<State>,
IServerTickableComponent<State>,
IClientTickableComponent<State> {
    public static final BlockPos REDSTONE_IN = new BlockPos(0, 1, 11);
    public static final int STEAM_CAPACITY = 500;
    public static final int WATER_CAPACITY = 250;
    private static final CapabilityPosition FLUID_INPUT = new CapabilityPosition(1, 1, 11, RelativeBlockFace.BACK);
    private static final CapabilityPosition FLUID_OUTPUT_A = new CapabilityPosition(2, 0, 3, RelativeBlockFace.LEFT);
    private static final CapabilityPosition FLUID_OUTPUT_B = new CapabilityPosition(0, 0, 3, RelativeBlockFace.RIGHT);
    private static final CapabilityPosition ROTATION_OUTPUT = new CapabilityPosition(1, 1, 0, RelativeBlockFace.BACK);
    private static final float DEG_PER_FULL_ROTATION = 360.0f;

    public void tickClient(IMultiblockContext<State> context) {
        State state = (State)context.getState();
        state.rotation += state.rotation_speed;
        state.rotation %= 360.0f;
    }

    public void tickServer(IMultiblockContext<State> context) {
        IRotationAcceptor alternator;
        int tank_amount;
        State state = (State)context.getState();
        boolean active = state.active;
        state.rotation_speed = Mth.m_14179_((float)0.01f, (float)state.rotation_speed, (float)state.target_rotation);
        if (active && (tank_amount = state.steam_tank.getFluidAmount()) != state.steam_tank.getFluidAmount()) {
            context.requestMasterBESync();
        }
        if (state.rsState.isEnabled(context) && !state.steam_tank.getFluid().isEmpty() && state.water_tank.getSpace() > 0) {
            TurbineFuel recipe = state.recipeGetter.apply(context.getLevel().getRawLevel(), state.steam_tank.getFluid().getFluid());
            if (recipe != null) {
                int fluidConsumed = recipe.getConsumed();
                int burnTime = recipe.getBurnTime();
                float outputRatio = recipe.getOutputRatio();
                if (state.consumeTick <= 0) {
                    if (state.steam_tank.getFluidAmount() >= fluidConsumed) {
                        state.steam_tank.drain(fluidConsumed, IFluidHandler.FluidAction.EXECUTE);
                        state.consumeTick = burnTime;
                        int waterOutput = (int)((float)fluidConsumed * outputRatio);
                        state.water_tank.fill(new FluidStack((Fluid)Fluids.f_76193_, waterOutput), IFluidHandler.FluidAction.EXECUTE);
                        active = true;
                    } else {
                        active = false;
                    }
                } else {
                    --state.consumeTick;
                    active = true;
                }
            } else {
                active = false;
            }
            state.target_rotation = active ? 64.0f : 0.0f;
        } else if (active) {
            active = false;
            state.target_rotation = 0.0f;
        }
        if (active != state.active) {
            state.active = active;
        }
        if (state.water_tank.getFluid().getAmount() > 0 && context.getLevel().getRawLevel().m_46467_() % 2L == 0L) {
            int amount = state.water_tank.getFluid().getAmount();
            int half = amount / 2;
            int outputLeftAmount = amount == 1 ? 1 : (amount % 2 == 0 ? half : half - 1);
            int outputRightAmount = amount == 1 ? 1 : half;
            this.drainOutputTank(state, outputLeftAmount, state.fluidOutputs.get(0));
            this.drainOutputTank(state, outputRightAmount, state.fluidOutputs.get(1));
        }
        if (state.target_rotation == 0.0f && state.rotation_speed < 0.5f) {
            state.rotation_speed = Math.round(state.rotation);
        }
        if (state.rotation_speed > 0.0f && (alternator = (IRotationAcceptor)state.outputCap.getNullable()) != null) {
            float rotationPerTick = state.rotation_speed / 360.0f;
            alternator.inputRotation((double)rotationPerTick);
        }
        context.requestMasterBESync();
    }

    private void drainOutputTank(State state, int amount, CapabilityReference<IFluidHandler> output_reference) {
        FluidStack out = Utils.copyFluidStackWithAmount((FluidStack)state.water_tank.getFluid(), (int)amount, (boolean)false);
        IFluidHandler output = (IFluidHandler)output_reference.getNullable();
        if (output == null) {
            return;
        }
        int accepted = output.fill(out, IFluidHandler.FluidAction.SIMULATE);
        if (accepted > 0) {
            int drained = output.fill(Utils.copyFluidStackWithAmount((FluidStack)out, (int)Math.min(out.getAmount(), accepted), (boolean)false), IFluidHandler.FluidAction.EXECUTE);
            state.water_tank.drain(drained, IFluidHandler.FluidAction.EXECUTE);
        }
    }

    public State createInitialState(IInitialMultiblockContext<State> capability) {
        return new State(capability);
    }

    @Nullable
    public List<Component> getOverlayText(State state, Player player, boolean b) {
        if (state != null && state.water_tank.getSpace() < 50) {
            return List.of(Component.m_237115_((String)"immersivegeology.steam_turbine.water_warning").m_130940_(ChatFormatting.BOLD).m_130940_(ChatFormatting.RED));
        }
        if (Utils.isFluidRelatedItemStack((ItemStack)player.m_21120_(InteractionHand.MAIN_HAND))) {
            return List.of(TextUtils.formatFluidStack((FluidStack)state.steam_tank.getFluid()), TextUtils.formatFluidStack((FluidStack)state.water_tank.getFluid()));
        }
        return List.of();
    }

    public <T> LazyOptional<T> getCapability(IMultiblockContext<State> ctx, CapabilityPosition position, Capability<T> cap) {
        if (cap != ForgeCapabilities.FLUID_HANDLER || !FLUID_INPUT.equalsOrNullFace(position) && !FLUID_OUTPUT_A.equalsOrNullFace(position) && !FLUID_OUTPUT_B.equalsOrNullFace(position)) {
            return LazyOptional.empty();
        }
        if (position.equals((Object)FLUID_OUTPUT_A) || position.equals((Object)FLUID_OUTPUT_B)) {
            return ((State)ctx.getState()).waterFluidCap.cast(ctx);
        }
        return ((State)ctx.getState()).steamFluidCap.cast(ctx);
    }

    public Function<BlockPos, VoxelShape> shapeGetter(ShapeType shapeType) {
        return SteamTurbineShape.GETTER;
    }

    public static class State
    implements IGMultiblockState {
        private final CapabilityReference<IRotationAcceptor> outputCap;
        public final RedstoneControl.RSState rsState = RedstoneControl.RSState.enabledByDefault();
        public final FluidTank steam_tank = new FluidTank(500);
        public final FluidTank water_tank = new FluidTank(250);
        private boolean active = false;
        private int consumeTick = 0;
        private float rotation = 0.0f;
        private float target_rotation = 0.0f;
        private float rotation_speed = 0.0f;
        private final BiFunction<Level, Fluid, TurbineFuel> recipeGetter = CachedRecipe.cached(TurbineFuel::getRecipeFor);
        private final StoredCapability<IFluidHandler> steamFluidCap;
        private final StoredCapability<IFluidHandler> waterFluidCap;
        private final List<CapabilityReference<IFluidHandler>> fluidOutputs;

        public State(IInitialMultiblockContext<State> ctx) {
            Runnable changedAndSync = () -> {
                ctx.getSyncRunnable().run();
                ctx.getMarkDirtyRunnable().run();
            };
            this.steamFluidCap = new StoredCapability((Object)new ArrayFluidHandler((IFluidTank)this.steam_tank, true, true, changedAndSync));
            this.waterFluidCap = new StoredCapability((Object)new ArrayFluidHandler((IFluidTank)this.water_tank, true, false, changedAndSync));
            ImmutableList.Builder outputs = ImmutableList.builder();
            outputs.add((Object)ctx.getCapabilityAt(ForgeCapabilities.FLUID_HANDLER, FLUID_OUTPUT_A.posInMultiblock().m_122029_(), FLUID_OUTPUT_A.side()));
            outputs.add((Object)ctx.getCapabilityAt(ForgeCapabilities.FLUID_HANDLER, FLUID_OUTPUT_B.posInMultiblock().m_122024_(), FLUID_OUTPUT_B.side()));
            this.outputCap = ctx.getCapabilityAt(IRotationAcceptor.CAPABILITY, ROTATION_OUTPUT.posInMultiblock().m_7918_(0, 0, -1), ROTATION_OUTPUT.side());
            this.fluidOutputs = outputs.build();
        }

        public void readSaveNBT(CompoundTag nbt) {
            this.readSyncNBT(nbt);
            this.active = nbt.m_128471_("active");
            this.consumeTick = nbt.m_128451_("consumeTick");
            this.rotation = nbt.m_128457_("rotation");
        }

        public void writeSaveNBT(CompoundTag nbt) {
            this.writeSyncNBT(nbt);
            nbt.m_128379_("active", this.active);
            nbt.m_128405_("consumeTick", this.consumeTick);
            nbt.m_128350_("rotation", this.rotation);
        }

        public void writeSyncNBT(CompoundTag nbt) {
            nbt.m_128365_("steam_tank", (Tag)this.steam_tank.writeToNBT(new CompoundTag()));
            nbt.m_128365_("water_tank", (Tag)this.water_tank.writeToNBT(new CompoundTag()));
            nbt.m_128379_("active", this.active);
            nbt.m_128350_("target_rotation", this.target_rotation);
            nbt.m_128350_("rotation_speed", this.rotation_speed);
        }

        public void readSyncNBT(CompoundTag nbt) {
            this.steam_tank.readFromNBT(nbt.m_128469_("steam_tank"));
            this.water_tank.readFromNBT(nbt.m_128469_("water_tank"));
            this.active = nbt.m_128471_("active");
            this.target_rotation = nbt.m_128457_("target_rotation");
            this.rotation_speed = nbt.m_128457_("rotation_speed");
        }

        public float getRotation() {
            return this.rotation;
        }

        public float getTargetRotation() {
            return this.target_rotation;
        }

        public float getRotationSpeed() {
            return this.rotation_speed;
        }

        @Override
        public void invalidate(@NotNull IMultiblockContext<?> ctx) {
            this.waterFluidCap.get(ctx).invalidate();
            this.steamFluidCap.get(ctx).invalidate();
        }
    }
}

