/*
 * Decompiled with CFR 0.152.
 */
package com.igteam.immersivegeology.common.block.multiblocks.logic.helper;

import blusunrize.immersiveengineering.api.crafting.IESerializableRecipe;
import blusunrize.immersiveengineering.api.crafting.IngredientWithSize;
import blusunrize.immersiveengineering.api.multiblocks.blocks.env.IMultiblockContext;
import blusunrize.immersiveengineering.api.multiblocks.blocks.env.IMultiblockLevel;
import com.igteam.immersivegeology.common.block.multiblocks.logic.RevFurnaceLogic;
import com.igteam.immersivegeology.common.block.multiblocks.recipe.RevFurnaceRecipe;
import java.util.List;
import java.util.function.Function;
import java.util.function.ToIntFunction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.util.Lazy;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import org.jetbrains.annotations.Nullable;

public class IGFurnaceHandler<R extends IESerializableRecipe> {
    private int process = 0;
    private int processMax = 0;
    private int burnTime = 0;
    private int lastBurnTime = 0;
    public final IGFurnaceStateView stateView = new IGFurnaceStateView();
    private final int fuelSlot;
    private final List<InputSlot<R>> inputs;
    private final List<OutputSlot<R>> outputs;
    private final ToIntFunction<R> getProcessingTime;
    private final Runnable setChanged;

    public IGFurnaceHandler(int fuelSlot, List<InputSlot<R>> inputs, List<OutputSlot<R>> outputs, ToIntFunction<R> getProcessingTime, Runnable setChanged) {
        this.fuelSlot = fuelSlot;
        this.inputs = inputs;
        this.outputs = outputs;
        this.getProcessingTime = getProcessingTime;
        this.setChanged = setChanged;
    }

    public boolean tickServer(IMultiblockContext<? extends IFurnaceEnvironment<R>> ctx, int furnaceIndex) {
        boolean active = false;
        IFurnaceEnvironment env = (IFurnaceEnvironment)ctx.getState();
        if (this.burnTime > 0) {
            R recipe;
            int processSpeed = 1;
            if (this.process > 0) {
                processSpeed = env.getProcessSpeed(ctx.getLevel(), furnaceIndex);
            }
            this.burnTime -= processSpeed;
            if (this.process > 0) {
                if (this.isAnyInputEmpty((IItemHandler)env.getInventory(furnaceIndex))) {
                    this.process = 0;
                    this.processMax = 0;
                } else {
                    recipe = this.getRecipe(env, furnaceIndex);
                    if (recipe != null && this.getProcessTime(recipe) != this.processMax) {
                        this.processMax = 0;
                        this.process = 0;
                    } else {
                        this.process -= processSpeed;
                        processSpeed = 0;
                        active = true;
                    }
                }
                this.setChanged.run();
            }
            if (this.process <= 0) {
                if (this.processMax > 0) {
                    this.doRecipeIO(env, furnaceIndex);
                    this.processMax = 0;
                    this.burnTime -= this.process;
                }
                if ((recipe = this.getRecipe(env, furnaceIndex)) != null) {
                    int time = this.getProcessTime(recipe);
                    this.process = time - processSpeed;
                    this.processMax = time;
                    active = true;
                }
            }
        }
        if (this.burnTime <= 0 && this.getRecipe(env, furnaceIndex) != null) {
            IItemHandlerModifiable inv = env.getInventory(furnaceIndex);
            ItemStack fuel = inv.getStackInSlot(this.fuelSlot);
            int addedBurntime = env.getBurnTimeOf(ctx.getLevel().getRawLevel(), fuel);
            if (addedBurntime > 0) {
                this.lastBurnTime = addedBurntime;
                this.burnTime += this.lastBurnTime;
                if (fuel.hasCraftingRemainingItem() && fuel.m_41613_() == 1) {
                    inv.setStackInSlot(this.fuelSlot, fuel.getCraftingRemainingItem());
                } else {
                    fuel.m_41774_(1);
                }
                this.setChanged.run();
            }
        }
        if (!active) {
            env.turnOff(ctx.getLevel(), furnaceIndex);
        }
        return active;
    }

    public Tag toNBT(int index) {
        CompoundTag result = new CompoundTag();
        result.m_128405_("process" + index, this.process);
        result.m_128405_("processMax" + index, this.processMax);
        result.m_128405_("burnTime" + index, this.burnTime);
        result.m_128405_("lastBurnTime" + index, this.lastBurnTime);
        return result;
    }

    public void readNBT(Tag nbt, int index) {
        if (!(nbt instanceof CompoundTag)) {
            return;
        }
        CompoundTag compound = (CompoundTag)nbt;
        this.process = compound.m_128451_("process" + index);
        this.processMax = compound.m_128451_("processMax" + index);
        this.burnTime = compound.m_128451_("burnTime" + index);
        this.lastBurnTime = compound.m_128451_("lastBurnTime" + index);
    }

    private boolean isAnyInputEmpty(IItemHandler inv) {
        for (InputSlot<R> i : this.inputs) {
            if (!inv.getStackInSlot(i.slotIndex).m_41619_()) continue;
            return true;
        }
        return false;
    }

    @Nullable
    private R getRecipe(IFurnaceEnvironment<R> env, int furnaceIndex) {
        R recipe = env.getRecipeForInput(furnaceIndex);
        if (recipe == null) {
            return null;
        }
        IItemHandlerModifiable inv = env.getInventory(furnaceIndex);
        for (OutputSlot<R> out : this.outputs) {
            ItemStack currentStack = inv.getStackInSlot(out.slotIndex);
            ItemStack outputSlot = out.get(recipe);
            if (currentStack.m_41619_()) continue;
            if (!ItemStack.m_41656_((ItemStack)currentStack, (ItemStack)outputSlot)) {
                return null;
            }
            if (currentStack.m_41613_() + outputSlot.m_41613_() <= inv.getSlotLimit(out.slotIndex)) continue;
            return null;
        }
        return recipe;
    }

    private void doRecipeIO(IFurnaceEnvironment<R> env, int furnaceIndex) {
        R recipe = this.getRecipe(env, furnaceIndex);
        if (recipe == null) {
            return;
        }
        IItemHandlerModifiable inv = env.getInventory(furnaceIndex);
        for (InputSlot<R> inputSlot : this.inputs) {
            int reqSize = this.inputs.stream().map(matchSlot -> matchSlot.get(recipe)).filter(ingr -> ingr.test(inv.getStackInSlot(slot.slotIndex))).mapToInt(IngredientWithSize::getCount).findFirst().orElse(0);
            inv.getStackInSlot(inputSlot.slotIndex).m_41774_(reqSize);
        }
        for (OutputSlot outputSlot : this.outputs) {
            ItemStack result = outputSlot.get(recipe);
            if (result.m_41619_()) continue;
            if (!inv.getStackInSlot(outputSlot.slotIndex).m_41619_()) {
                inv.getStackInSlot(outputSlot.slotIndex).m_41769_(result.m_41613_());
                continue;
            }
            inv.setStackInSlot(outputSlot.slotIndex, result.m_41777_());
        }
        if (recipe instanceof RevFurnaceRecipe) {
            RevFurnaceRecipe revRecipe = (RevFurnaceRecipe)((Object)recipe);
            if (env instanceof RevFurnaceLogic.State) {
                RevFurnaceLogic.State state = (RevFurnaceLogic.State)((Object)env);
                state.addToTank(revRecipe.getWasteAmount());
            }
        }
    }

    private int getProcessTime(R recipe) {
        return this.getProcessingTime.applyAsInt(recipe);
    }

    public class IGFurnaceStateView
    implements ContainerData {
        public static final int LAST_BURN_TIME = 0;
        public static final int BURN_TIME = 1;
        public static final int PROCESS_MAX = 2;
        public static final int CURRENT_PROCESS = 3;
        public static final int NUM_SLOTS = 4;

        public static int getLastBurnTime(ContainerData data) {
            return data.m_6413_(0);
        }

        public static int getBurnTime(ContainerData data) {
            return data.m_6413_(1);
        }

        public static int getMaxProcess(ContainerData data) {
            return data.m_6413_(2);
        }

        public static int getProcess(ContainerData data) {
            return data.m_6413_(3);
        }

        public int m_6413_(int index) {
            switch (index) {
                case 0: {
                    return IGFurnaceHandler.this.lastBurnTime;
                }
                case 1: {
                    return IGFurnaceHandler.this.burnTime;
                }
                case 2: {
                    return IGFurnaceHandler.this.processMax;
                }
                case 3: {
                    return IGFurnaceHandler.this.process;
                }
            }
            throw new IllegalArgumentException("Unknown index " + index);
        }

        public void m_8050_(int index, int value) {
            switch (index) {
                case 0: {
                    IGFurnaceHandler.this.lastBurnTime = value;
                    break;
                }
                case 1: {
                    IGFurnaceHandler.this.burnTime = value;
                    break;
                }
                case 2: {
                    IGFurnaceHandler.this.processMax = value;
                    break;
                }
                case 3: {
                    IGFurnaceHandler.this.process = value;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unknown index " + index);
                }
            }
        }

        public int m_6499_() {
            return 4;
        }
    }

    public static interface IFurnaceEnvironment<R extends IESerializableRecipe> {
        public IItemHandlerModifiable getInventory(int var1);

        @Nullable
        public R getRecipeForInput(int var1);

        public int getBurnTimeOf(Level var1, ItemStack var2);

        default public int getProcessSpeed(IMultiblockLevel level, int furnaceIndex) {
            return 1;
        }

        default public void turnOff(IMultiblockLevel level, int furnaceIndex) {
        }
    }

    public static class InputSlot<R> {
        private final Function<R, IngredientWithSize> getFromRecipe;
        private final int slotIndex;

        public InputSlot(Function<R, IngredientWithSize> getFromRecipe, int slotIndex) {
            this.getFromRecipe = getFromRecipe;
            this.slotIndex = slotIndex;
        }

        public IngredientWithSize get(R recipe) {
            return this.getFromRecipe.apply(recipe);
        }
    }

    public static class OutputSlot<R> {
        private final Function<R, Lazy<ItemStack>> getFromRecipe;
        private final int slotIndex;

        public OutputSlot(Function<R, Lazy<ItemStack>> getFromRecipe, int slotIndex) {
            this.getFromRecipe = getFromRecipe;
            this.slotIndex = slotIndex;
        }

        public ItemStack get(R recipe) {
            return (ItemStack)this.getFromRecipe.apply(recipe).get();
        }
    }
}

