/*
 * Decompiled with CFR 0.152.
 */
package com.igteam.immersivegeology.common.block.multiblocks.recipe;

import blusunrize.immersiveengineering.api.crafting.FluidTagInput;
import blusunrize.immersiveengineering.api.crafting.IERecipeSerializer;
import blusunrize.immersiveengineering.api.crafting.IngredientWithSize;
import blusunrize.immersiveengineering.api.crafting.MultiblockRecipe;
import blusunrize.immersiveengineering.api.crafting.cache.CachedRecipeList;
import com.igteam.immersivegeology.core.lib.IGLib;
import com.igteam.immersivegeology.core.registration.IGRecipeTypes;
import java.util.List;
import java.util.Set;
import net.minecraft.core.NonNullList;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.util.Lazy;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.registries.RegistryObject;

public class BasicChemicalRecipe
extends MultiblockRecipe {
    public static RegistryObject<IERecipeSerializer<BasicChemicalRecipe>> SERIALIZER;
    public static final CachedRecipeList<BasicChemicalRecipe> RECIPES;
    public final ItemStack itemOutput;
    public final FluidStack fluidOutput;
    public final Set<FluidTagInput> fluidIn;
    public final IngredientWithSize itemInput;
    Lazy<Integer> totalProcessEnergy;
    Lazy<Integer> totalProcessTime;
    Lazy<Integer> damage_per_second;

    public <T extends Recipe<?>> BasicChemicalRecipe(ResourceLocation id, IngredientWithSize inputItem, Set<FluidTagInput> fluidInputSet, ItemStack itemOutput, FluidStack fluidOutput, int damage_per_second, int energy, int time) {
        super(LAZY_EMPTY, IGRecipeTypes.BASIC_CHEMICAL_REACTOR, id);
        this.itemOutput = itemOutput;
        this.fluidOutput = fluidOutput;
        this.fluidIn = fluidInputSet;
        this.itemInput = inputItem;
        this.totalProcessEnergy = Lazy.of(() -> energy);
        this.totalProcessTime = Lazy.of(() -> time);
        this.damage_per_second = Lazy.of(() -> damage_per_second);
        this.outputList = Lazy.of(() -> NonNullList.m_122783_((Object)this.itemOutput, (Object[])new ItemStack[0]));
        this.fluidOutputList = List.of(fluidOutput);
        this.fluidInputList = this.fluidIn.stream().toList();
        this.setInputList(List.of(this.itemInput.getBaseIngredient()));
        if (this.fluidIn.isEmpty() || this.fluidIn.size() > 2) {
            IGLib.IG_LOGGER.error("Basic Chemical Recipe {} has either NO or more than 2 Fluid Tag inputs in the set.", (Object)id);
        }
    }

    public static boolean acceptableCatalyst(Level level, ItemStack stack) {
        for (BasicChemicalRecipe recipe : RECIPES.getRecipes(level)) {
            if (!recipe.itemInput.testIgnoringSize(stack)) continue;
            return true;
        }
        return false;
    }

    public boolean shouldCheckItemAvailability() {
        return !this.itemInput.hasNoMatchingItems();
    }

    public NonNullList<ItemStack> getActualItemOutputs() {
        NonNullList list = NonNullList.m_122779_();
        list.add((Object)this.itemOutput);
        return list;
    }

    public List<FluidStack> getActualFluidOutputs() {
        return List.of(this.fluidOutput);
    }

    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)SERIALIZER.get();
    }

    public int getTotalProcessEnergy() {
        return (Integer)this.totalProcessEnergy.get();
    }

    public int getTotalProcessTime() {
        return (Integer)this.totalProcessTime.get();
    }

    public static BasicChemicalRecipe findRecipe(Level level, FluidStack inputA, FluidStack inputB, ItemStack itemInput) {
        List<FluidStack> tankedFluids = List.of(inputA, inputB);
        BasicChemicalRecipe bestMatch = null;
        for (BasicChemicalRecipe recipe : RECIPES.getRecipes(level)) {
            Set<FluidTagInput> recipeFluids;
            boolean allFluidsAvailable;
            if (!recipe.itemInput.test(itemInput) || !(allFluidsAvailable = (recipeFluids = recipe.fluidIn).stream().allMatch(rf -> tankedFluids.stream().anyMatch(rf))) || bestMatch != null && recipeFluids.size() <= bestMatch.fluidIn.size()) continue;
            bestMatch = recipe;
        }
        return bestMatch;
    }

    public int getDamagePerTick() {
        return (Integer)this.damage_per_second.get();
    }

    protected IERecipeSerializer<?> getIESerializer() {
        return (IERecipeSerializer)SERIALIZER.get();
    }

    public int getMultipleProcessTicks() {
        return 1;
    }

    static {
        RECIPES = new CachedRecipeList(IGRecipeTypes.BASIC_CHEMICAL_REACTOR);
    }
}

