/*
 * Decompiled with CFR 0.152.
 */
package com.igteam.immersivegeology.common.block.multiblocks.recipe;

import blusunrize.immersiveengineering.api.crafting.FluidTagInput;
import blusunrize.immersiveengineering.api.crafting.IERecipeSerializer;
import blusunrize.immersiveengineering.api.crafting.MultiblockRecipe;
import blusunrize.immersiveengineering.api.crafting.cache.CachedRecipeList;
import com.igteam.immersivegeology.core.registration.IGRecipeTypes;
import net.minecraft.core.NonNullList;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.util.Lazy;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.registries.RegistryObject;

public class FoundryRecipe
extends MultiblockRecipe {
    public static RegistryObject<IERecipeSerializer<FoundryRecipe>> SERIALIZER;
    public static final CachedRecipeList<FoundryRecipe> RECIPES;
    public final Lazy<ItemStack> itemOutput;
    public final FluidTagInput fluidIn;
    Lazy<Integer> totalProcessEnergy;
    Lazy<Integer> totalProcessTime;
    public final Item mold;

    public <T extends Recipe<?>> FoundryRecipe(ResourceLocation id, FluidTagInput fluidInput, Lazy<ItemStack> output, Item mold, int energy, int time) {
        super(LAZY_EMPTY, IGRecipeTypes.PELLETIZER, id);
        this.itemOutput = output;
        this.fluidIn = fluidInput;
        this.mold = mold;
        this.totalProcessEnergy = Lazy.of(() -> energy);
        this.totalProcessTime = Lazy.of(() -> time);
        this.outputList = Lazy.of(() -> NonNullList.m_122783_((Object)ItemStack.f_41583_, (Object[])new ItemStack[]{(ItemStack)this.itemOutput.get()}));
    }

    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)SERIALIZER.get();
    }

    public int getTotalProcessEnergy() {
        return (Integer)this.totalProcessEnergy.get();
    }

    public int getTotalProcessTime() {
        return (Integer)this.totalProcessTime.get();
    }

    public static FoundryRecipe findRecipe(Level level, FluidStack input) {
        for (FoundryRecipe recipe : RECIPES.getRecipes(level)) {
            if (!recipe.fluidIn.test(input)) continue;
            return recipe;
        }
        return null;
    }

    public ItemStack getDisplayStack(ItemStack input) {
        return new ItemStack((ItemLike)input.m_41720_(), input.m_41613_());
    }

    protected IERecipeSerializer<?> getIESerializer() {
        return (IERecipeSerializer)SERIALIZER.get();
    }

    public int getMultipleProcessTicks() {
        return 1;
    }

    static {
        RECIPES = new CachedRecipeList(IGRecipeTypes.FOUNDRY);
    }
}

