/*
 * Decompiled with CFR 0.152.
 */
package com.igteam.immersivegeology.common.block.multiblocks.recipe;

import blusunrize.immersiveengineering.api.crafting.FluidTagInput;
import blusunrize.immersiveengineering.api.crafting.IERecipeSerializer;
import blusunrize.immersiveengineering.api.crafting.MultiblockRecipe;
import blusunrize.immersiveengineering.api.crafting.cache.CachedRecipeList;
import com.igteam.immersivegeology.core.registration.IGRecipeTypes;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.util.Lazy;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.registries.RegistryObject;

public class GeothermalExchangerRecipe
extends MultiblockRecipe {
    public static RegistryObject<IERecipeSerializer<GeothermalExchangerRecipe>> SERIALIZER;
    public static final CachedRecipeList<GeothermalExchangerRecipe> RECIPES;
    public final Lazy<FluidStack> fluidOutput;
    public final FluidTagInput fluidIn;
    Lazy<Integer> totalProcessEnergy;
    Lazy<Integer> totalProcessTime;

    public <T extends Recipe<?>> GeothermalExchangerRecipe(ResourceLocation id, FluidTagInput fluidInput, Lazy<FluidStack> fluid_output, int energy, int time) {
        super(LAZY_EMPTY, IGRecipeTypes.GEOTHERMAL_EXCHANGER, id);
        this.fluidIn = fluidInput;
        this.totalProcessEnergy = Lazy.of(() -> energy);
        this.totalProcessTime = Lazy.of(() -> time);
        this.fluidOutput = fluid_output;
    }

    public static List<GeothermalExchangerRecipe> findAllValidRecipes(Level level, FluidStack input) {
        ArrayList<GeothermalExchangerRecipe> valid = new ArrayList<GeothermalExchangerRecipe>();
        for (GeothermalExchangerRecipe recipe : RECIPES.getRecipes(level)) {
            if (!recipe.fluidIn.test(input)) continue;
            valid.add(recipe);
        }
        return valid;
    }

    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)SERIALIZER.get();
    }

    public int getTotalProcessEnergy() {
        return (Integer)this.totalProcessEnergy.get();
    }

    public int getTotalProcessTime() {
        return (Integer)this.totalProcessTime.get();
    }

    public static GeothermalExchangerRecipe findRecipe(Level level, FluidStack input) {
        for (GeothermalExchangerRecipe recipe : RECIPES.getRecipes(level)) {
            if (!recipe.fluidIn.test(input)) continue;
            return recipe;
        }
        return null;
    }

    public static GeothermalExchangerRecipe findRecipe(Level level, FluidStack input, @Nullable GeothermalExchangerRecipe hint) {
        if (input.isEmpty()) {
            return null;
        }
        if (hint != null && hint.matches(input)) {
            return hint;
        }
        for (GeothermalExchangerRecipe recipe : RECIPES.getRecipes(level)) {
            if (!recipe.fluidIn.test(input)) continue;
            return recipe;
        }
        return null;
    }

    private boolean matches(FluidStack input) {
        return this.fluidIn.test(input);
    }

    protected IERecipeSerializer<?> getIESerializer() {
        return (IERecipeSerializer)SERIALIZER.get();
    }

    public int getMultipleProcessTicks() {
        return 1;
    }

    public boolean isCooling() {
        return this.fluidIn.getRandomizedExampleStack(0).getFluid().getFluidType().getTemperature() > ((FluidStack)this.fluidOutput.get()).getFluid().getFluidType().getTemperature();
    }

    static {
        RECIPES = new CachedRecipeList(IGRecipeTypes.GEOTHERMAL_EXCHANGER);
    }
}

