/*
 * Decompiled with CFR 0.152.
 */
package com.igteam.immersivegeology.common.block.multiblocks.recipe;

import blusunrize.immersiveengineering.api.crafting.IERecipeSerializer;
import blusunrize.immersiveengineering.api.crafting.MultiblockRecipe;
import blusunrize.immersiveengineering.api.crafting.cache.CachedRecipeList;
import com.igteam.immersivegeology.core.registration.IGRecipeTypes;
import net.minecraft.core.NonNullList;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.util.Lazy;
import net.minecraftforge.registries.RegistryObject;

public class GravitySeparatorRecipe
extends MultiblockRecipe {
    public static RegistryObject<IERecipeSerializer<GravitySeparatorRecipe>> SERIALIZER;
    public static final CachedRecipeList<GravitySeparatorRecipe> RECIPES;
    public final Lazy<ItemStack> itemOutput;
    public final Lazy<ItemStack> itemByproduct;
    public final Ingredient itemIn;
    Lazy<Integer> totalProcessWater;
    Lazy<Integer> totalProcessTime;
    Lazy<Float> byproductChance;

    public <T extends Recipe<?>> GravitySeparatorRecipe(ResourceLocation id, Ingredient itemIn, Lazy<ItemStack> output, Lazy<ItemStack> byproduct, float chance, int water, int time) {
        super(LAZY_EMPTY, IGRecipeTypes.GRAVITYSEPARATOR, id);
        this.itemOutput = output;
        this.itemByproduct = byproduct;
        this.itemIn = itemIn;
        this.byproductChance = Lazy.of(() -> Float.valueOf(chance));
        this.totalProcessWater = Lazy.of(() -> water);
        this.totalProcessTime = Lazy.of(() -> time);
        this.outputList = Lazy.of(() -> NonNullList.m_122783_((Object)ItemStack.f_41583_, (Object[])new ItemStack[]{(ItemStack)this.itemOutput.get()}));
    }

    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)SERIALIZER.get();
    }

    public int getTotalProcessEnergy() {
        return 0;
    }

    public int getTotalProcessTime() {
        return (Integer)this.totalProcessTime.get();
    }

    public static GravitySeparatorRecipe findRecipe(Level level, ItemStack item) {
        for (GravitySeparatorRecipe recipe : RECIPES.getRecipes(level)) {
            if (!recipe.itemIn.test(item)) continue;
            return recipe;
        }
        return null;
    }

    protected IERecipeSerializer<?> getIESerializer() {
        return (IERecipeSerializer)SERIALIZER.get();
    }

    public int getMultipleProcessTicks() {
        return 1;
    }

    public int getTotalProcessWater() {
        return (Integer)this.totalProcessWater.get();
    }

    public float getChance() {
        return ((Float)this.byproductChance.get()).floatValue();
    }

    static {
        RECIPES = new CachedRecipeList(IGRecipeTypes.GRAVITYSEPARATOR);
    }
}

