/*
 * Decompiled with CFR 0.152.
 */
package com.igteam.immersivegeology.common.block.multiblocks.recipe;

import blusunrize.immersiveengineering.api.crafting.IERecipeSerializer;
import blusunrize.immersiveengineering.api.crafting.MultiblockRecipe;
import blusunrize.immersiveengineering.api.crafting.StackWithChance;
import blusunrize.immersiveengineering.api.crafting.cache.CachedRecipeList;
import com.igteam.immersivegeology.core.registration.IGRecipeTypes;
import java.util.List;
import net.minecraft.core.NonNullList;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.util.Lazy;
import net.minecraftforge.registries.RegistryObject;

public class IndustrialSluiceRecipe
extends MultiblockRecipe {
    public static RegistryObject<IERecipeSerializer<IndustrialSluiceRecipe>> SERIALIZER;
    public static final CachedRecipeList<IndustrialSluiceRecipe> RECIPES;
    public final Lazy<ItemStack> itemOutput;
    public final Ingredient itemIn;
    Lazy<Integer> totalProcessWater;
    Lazy<Integer> totalProcessTime;
    Lazy<Integer> totalProcessEnergy;
    Lazy<NonNullList<StackWithChance>> byproducts;

    public <T extends Recipe<?>> IndustrialSluiceRecipe(ResourceLocation id, Ingredient itemIn, Lazy<ItemStack> output, NonNullList<StackWithChance> byproducts, int water, int time, int energy) {
        super(LAZY_EMPTY, IGRecipeTypes.SLUICE, id);
        this.itemOutput = output;
        this.itemIn = itemIn;
        this.byproducts = Lazy.of(() -> byproducts);
        this.totalProcessWater = Lazy.of(() -> water);
        this.totalProcessTime = Lazy.of(() -> time);
        this.totalProcessEnergy = Lazy.of(() -> energy);
        NonNullList outputs = NonNullList.m_182647_((int)(byproducts.size() + 1));
        List<ItemStack> stacks = byproducts.stream().map(s -> (ItemStack)s.stack().get()).toList();
        outputs.add((Object)((ItemStack)output.get()));
        outputs.addAll(stacks);
        this.outputList = Lazy.of(() -> outputs);
    }

    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)SERIALIZER.get();
    }

    public int getTotalProcessEnergy() {
        return 0;
    }

    public int getTotalProcessTime() {
        return (Integer)this.totalProcessTime.get();
    }

    public static IndustrialSluiceRecipe findRecipe(Level level, ItemStack item) {
        for (IndustrialSluiceRecipe recipe : RECIPES.getRecipes(level)) {
            if (!recipe.itemIn.test(item)) continue;
            return recipe;
        }
        return null;
    }

    protected IERecipeSerializer<?> getIESerializer() {
        return (IERecipeSerializer)SERIALIZER.get();
    }

    public int getMultipleProcessTicks() {
        return 1;
    }

    public NonNullList<StackWithChance> getByproducts() {
        return (NonNullList)this.byproducts.get();
    }

    public int getTotalProcessWater() {
        return (Integer)this.totalProcessWater.get();
    }

    static {
        RECIPES = new CachedRecipeList(IGRecipeTypes.SLUICE);
    }
}

