/*
 * Decompiled with CFR 0.152.
 */
package com.igteam.immersivegeology.common.block.multiblocks.recipe;

import blusunrize.immersiveengineering.api.crafting.IERecipeSerializer;
import blusunrize.immersiveengineering.api.crafting.IngredientWithSize;
import blusunrize.immersiveengineering.api.crafting.MultiblockRecipe;
import blusunrize.immersiveengineering.api.crafting.cache.CachedRecipeList;
import com.igteam.immersivegeology.core.registration.IGRecipeTypes;
import net.minecraft.core.NonNullList;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.util.Lazy;
import net.minecraftforge.registries.RegistryObject;
import org.jetbrains.annotations.NotNull;

public class RotaryKilnRecipe
extends MultiblockRecipe {
    public static RegistryObject<IERecipeSerializer<RotaryKilnRecipe>> SERIALIZER;
    public static final CachedRecipeList<RotaryKilnRecipe> RECIPES;
    public final Lazy<ItemStack> itemOutput;
    public final IngredientWithSize itemIn;
    Lazy<Integer> totalProcessEnergy;
    Lazy<Integer> heatRequired;
    Lazy<Integer> totalProcessTime;

    public <T extends Recipe<?>> RotaryKilnRecipe(ResourceLocation id, IngredientWithSize input, Lazy<ItemStack> output, int time, int heat) {
        super(LAZY_EMPTY, IGRecipeTypes.ROTARYKILN, id);
        this.itemOutput = output;
        this.itemIn = input;
        this.totalProcessEnergy = Lazy.of(() -> time);
        this.heatRequired = Lazy.of(() -> heat);
        this.totalProcessTime = Lazy.of(() -> time);
        this.outputList = Lazy.of(() -> NonNullList.m_122783_((Object)ItemStack.f_41583_, (Object[])new ItemStack[]{(ItemStack)this.itemOutput.get()}));
    }

    @NotNull
    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)SERIALIZER.get();
    }

    public int getTotalProcessEnergy() {
        return (Integer)this.totalProcessEnergy.get();
    }

    public int getHeatRequired() {
        return (Integer)this.heatRequired.get();
    }

    public int getTotalProcessTime() {
        return (Integer)this.totalProcessTime.get();
    }

    public static RotaryKilnRecipe findRecipe(Level level, ItemStack input) {
        for (RotaryKilnRecipe recipe : RECIPES.getRecipes(level)) {
            if (!recipe.itemIn.testIgnoringSize(input)) continue;
            return recipe;
        }
        return null;
    }

    protected IERecipeSerializer<?> getIESerializer() {
        return (IERecipeSerializer)SERIALIZER.get();
    }

    public int getMultipleProcessTicks() {
        return 1;
    }

    static {
        RECIPES = new CachedRecipeList(IGRecipeTypes.ROTARYKILN);
    }
}

