/*
 * Decompiled with CFR 0.152.
 */
package com.igteam.immersivegeology.common.block.multiblocks.recipe.builder;

import blusunrize.immersiveengineering.api.crafting.IERecipeSerializer;
import blusunrize.immersiveengineering.api.crafting.builders.IEFinishedRecipe;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.igteam.immersivegeology.common.block.multiblocks.recipe.GeothermalBiomeRecipe;
import java.util.Arrays;
import java.util.Collection;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.biome.Biome;

public class GeothermalBiomeRecipeBuilder
extends IEFinishedRecipe<GeothermalBiomeRecipeBuilder> {
    private GeothermalBiomeRecipeBuilder() {
        super((IERecipeSerializer)GeothermalBiomeRecipe.SERIALIZER.get());
    }

    public GeothermalBiomeRecipeBuilder setHeat(int min_heat, int max_heat) {
        this.addWriter(json -> json.addProperty("min_heat", (Number)min_heat));
        this.addWriter(json -> json.addProperty("max_heat", (Number)max_heat));
        return this;
    }

    public static GeothermalBiomeRecipeBuilder fromBiome(ResourceKey<Biome> biome, int min_heat, int max_heat) {
        GeothermalBiomeRecipeBuilder builder = new GeothermalBiomeRecipeBuilder();
        ResourceLocation biomeId = biome.m_135782_();
        builder.addWriter(json -> json.addProperty("biome", biomeId.toString()));
        return builder.setHeat(min_heat, max_heat);
    }

    @SafeVarargs
    public static GeothermalBiomeRecipeBuilder fromTags(int min_heat, int max_heat, TagKey<Biome> ... tags) {
        return GeothermalBiomeRecipeBuilder.fromTags(Arrays.asList(tags), min_heat, max_heat);
    }

    public static GeothermalBiomeRecipeBuilder fromTags(Collection<TagKey<Biome>> tags, int min_heat, int max_heat) {
        GeothermalBiomeRecipeBuilder builder = new GeothermalBiomeRecipeBuilder();
        JsonArray array = new JsonArray();
        for (TagKey<Biome> tag : tags) {
            array.add(tag.f_203868_().toString());
        }
        builder.addWriter(json -> json.add("biome_tags", (JsonElement)array));
        return builder.setHeat(min_heat, max_heat);
    }
}

