/*
 * Decompiled with CFR 0.152.
 */
package com.igteam.immersivegeology.common.block.multiblocks.recipe.builder;

import blusunrize.immersiveengineering.api.crafting.IERecipeSerializer;
import blusunrize.immersiveengineering.api.crafting.IngredientWithSize;
import blusunrize.immersiveengineering.api.crafting.StackWithChance;
import blusunrize.immersiveengineering.api.crafting.builders.IEFinishedRecipe;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.igteam.immersivegeology.common.block.multiblocks.recipe.IndustrialSluiceRecipe;
import net.minecraft.core.NonNullList;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.common.crafting.conditions.ICondition;

public class IndustrialSluiceRecipeBuilder
extends IEFinishedRecipe<IndustrialSluiceRecipeBuilder> {
    protected IndustrialSluiceRecipeBuilder() {
        super((IERecipeSerializer)IndustrialSluiceRecipe.SERIALIZER.get());
    }

    public static IndustrialSluiceRecipeBuilder builder(Item result) {
        return (IndustrialSluiceRecipeBuilder)new IndustrialSluiceRecipeBuilder().addResult((ItemLike)result);
    }

    public static IndustrialSluiceRecipeBuilder builder(ItemStack result) {
        return (IndustrialSluiceRecipeBuilder)new IndustrialSluiceRecipeBuilder().addResult(result);
    }

    public static IndustrialSluiceRecipeBuilder builder(TagKey<Item> result) {
        return (IndustrialSluiceRecipeBuilder)new IndustrialSluiceRecipeBuilder().addResult(Ingredient.m_204132_(result));
    }

    public IndustrialSluiceRecipeBuilder addInput(Ingredient ingredient) {
        return (IndustrialSluiceRecipeBuilder)this.addIngredient(this.generateSafeInputKey(), ingredient);
    }

    public IndustrialSluiceRecipeBuilder addInput(TagKey<Item> item) {
        return (IndustrialSluiceRecipeBuilder)this.addIngredient(this.generateSafeInputKey(), Ingredient.m_204132_(item));
    }

    public IndustrialSluiceRecipeBuilder setWater(int water) {
        return (IndustrialSluiceRecipeBuilder)this.addWriter(jsonObject -> jsonObject.addProperty("water", (Number)water));
    }

    public IndustrialSluiceRecipeBuilder setByproducts(NonNullList<StackWithChance> byproducts) {
        return (IndustrialSluiceRecipeBuilder)this.addWriter(obj -> IndustrialSluiceRecipeBuilder.writeByproductsToJson(obj, byproducts));
    }

    private static void writeByproductsToJson(JsonObject obj, NonNullList<StackWithChance> byproducts) {
        obj.addProperty("amount_of_byproducts", (Number)byproducts.size());
        JsonArray jsonArray = new JsonArray();
        for (StackWithChance byproduct : byproducts) {
            ItemStack stack = (ItemStack)byproduct.stack().get();
            float chance = byproduct.chance();
            JsonObject itemObject = IEFinishedRecipe.serializeStackWithChance((IngredientWithSize)IngredientWithSize.of((ItemStack)stack), (float)chance, (ICondition[])new ICondition[0]);
            jsonArray.add((JsonElement)itemObject);
        }
        obj.add("byproducts", (JsonElement)jsonArray);
    }

    public IndustrialSluiceRecipeBuilder setByproduct(Item byproduct) {
        return (IndustrialSluiceRecipeBuilder)this.addItem("byproduct", new ItemStack((ItemLike)byproduct));
    }

    public IndustrialSluiceRecipeBuilder setChances(NonNullList<Float> chances) {
        return (IndustrialSluiceRecipeBuilder)this.addWriter(jsonObject -> {
            for (Float byproduct : chances) {
                jsonObject.addProperty("chance_" + chances.indexOf((Object)byproduct), (Number)byproduct);
            }
        });
    }
}

