/*
 * Decompiled with CFR 0.152.
 */
package com.igteam.immersivegeology.common.block.multiblocks.recipe.serializer;

import blusunrize.immersiveengineering.api.crafting.IERecipeSerializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.igteam.immersivegeology.common.block.multiblocks.recipe.GravitySeparatorRecipe;
import com.igteam.immersivegeology.core.registration.IGMultiblockProvider;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraftforge.common.crafting.conditions.ICondition;
import net.minecraftforge.common.util.Lazy;
import org.jetbrains.annotations.Nullable;

public class GravitySeparatorRecipeSerializer
extends IERecipeSerializer<GravitySeparatorRecipe> {
    public ItemStack getIcon() {
        return IGMultiblockProvider.GRAVITY_SEPARATOR.iconStack();
    }

    public GravitySeparatorRecipe readFromJson(ResourceLocation resourceLocation, JsonObject json, ICondition.IContext iContext) {
        Lazy output = GravitySeparatorRecipeSerializer.readOutput((JsonElement)json.get("result"));
        Lazy byproduct = GravitySeparatorRecipeSerializer.readOutput((JsonElement)json.get("byproduct"));
        float chance = GsonHelper.m_13915_((JsonObject)json, (String)"byproduct_chance");
        Ingredient input = Ingredient.m_43917_((JsonElement)GsonHelper.m_13930_((JsonObject)json, (String)"input"));
        int time = GsonHelper.m_13927_((JsonObject)json, (String)"time");
        int water = GsonHelper.m_13927_((JsonObject)json, (String)"water");
        return new GravitySeparatorRecipe(resourceLocation, input, (Lazy<ItemStack>)output, (Lazy<ItemStack>)byproduct, chance, water, time);
    }

    @Nullable
    public GravitySeparatorRecipe fromNetwork(ResourceLocation resourceLocation, FriendlyByteBuf buffer) {
        Lazy output = GravitySeparatorRecipeSerializer.readLazyStack((FriendlyByteBuf)buffer);
        Lazy byproduct = GravitySeparatorRecipeSerializer.readLazyStack((FriendlyByteBuf)buffer);
        float chance = buffer.readFloat();
        Ingredient input = Ingredient.m_43940_((FriendlyByteBuf)buffer);
        int time = buffer.readInt();
        int water = buffer.readInt();
        return new GravitySeparatorRecipe(resourceLocation, input, (Lazy<ItemStack>)output, (Lazy<ItemStack>)byproduct, chance, water, time);
    }

    public void toNetwork(FriendlyByteBuf buffer, GravitySeparatorRecipe recipe) {
        GravitySeparatorRecipeSerializer.writeLazyStack((FriendlyByteBuf)buffer, recipe.itemOutput);
        GravitySeparatorRecipeSerializer.writeLazyStack((FriendlyByteBuf)buffer, recipe.itemByproduct);
        buffer.writeFloat(recipe.getChance());
        recipe.itemIn.m_43923_(buffer);
        buffer.writeInt(recipe.getTotalProcessTime());
        buffer.writeInt(recipe.getTotalProcessWater());
    }
}

