/*
 * Decompiled with CFR 0.152.
 */
package com.igteam.immersivegeology.common.block.multiblocks.recipe.serializer;

import blusunrize.immersiveengineering.api.crafting.IERecipeSerializer;
import blusunrize.immersiveengineering.api.crafting.StackWithChance;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.igteam.immersivegeology.common.block.multiblocks.recipe.IndustrialSluiceRecipe;
import net.minecraft.core.NonNullList;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.common.crafting.conditions.ICondition;
import net.minecraftforge.common.util.Lazy;
import org.jetbrains.annotations.Nullable;

public class IndustrialSluiceRecipeSerializer
extends IERecipeSerializer<IndustrialSluiceRecipe> {
    public ItemStack getIcon() {
        return new ItemStack((ItemLike)Items.f_42410_);
    }

    public IndustrialSluiceRecipe readFromJson(ResourceLocation resourceLocation, JsonObject json, ICondition.IContext iContext) {
        Ingredient input = Ingredient.m_43917_((JsonElement)GsonHelper.m_13930_((JsonObject)json, (String)"input"));
        Lazy primary = IndustrialSluiceRecipeSerializer.readOutput((JsonElement)json.get("result"));
        NonNullList<StackWithChance> byproducts = this.readByproductsFromJson(json);
        int time = GsonHelper.m_13927_((JsonObject)json, (String)"time");
        int water = GsonHelper.m_13927_((JsonObject)json, (String)"water");
        int energy = GsonHelper.m_13927_((JsonObject)json, (String)"energy");
        return new IndustrialSluiceRecipe(resourceLocation, input, (Lazy<ItemStack>)primary, byproducts, water, time, energy);
    }

    private NonNullList<StackWithChance> readByproductsFromJson(JsonObject obj) {
        int amount_of_byproducts = GsonHelper.m_13927_((JsonObject)obj, (String)"amount_of_byproducts");
        NonNullList list = NonNullList.m_182647_((int)amount_of_byproducts);
        JsonArray jsonArray = GsonHelper.m_13933_((JsonObject)obj, (String)"byproducts");
        for (int index = 0; index < amount_of_byproducts; ++index) {
            JsonObject byproductObject = jsonArray.get(index).getAsJsonObject();
            list.add((Object)IndustrialSluiceRecipeSerializer.readConditionalStackWithChance((JsonElement)byproductObject, (ICondition.IContext)ICondition.IContext.EMPTY));
        }
        return list;
    }

    @Nullable
    public IndustrialSluiceRecipe fromNetwork(ResourceLocation resourceLocation, FriendlyByteBuf buffer) {
        Lazy primary = IndustrialSluiceRecipeSerializer.readLazyStack((FriendlyByteBuf)buffer);
        NonNullList<StackWithChance> byproducts = this.readByproducts(buffer);
        Ingredient input = Ingredient.m_43940_((FriendlyByteBuf)buffer);
        int time = buffer.readInt();
        int water = buffer.readInt();
        int energy = buffer.readInt();
        return new IndustrialSluiceRecipe(resourceLocation, input, (Lazy<ItemStack>)primary, byproducts, water, time, energy);
    }

    private NonNullList<StackWithChance> readByproducts(FriendlyByteBuf buffer) {
        int size = buffer.readInt();
        NonNullList item_list = NonNullList.m_182647_((int)size);
        for (int index = 0; index < size; ++index) {
            item_list.add((Object)StackWithChance.read((FriendlyByteBuf)buffer));
        }
        return item_list;
    }

    private void writeByproducts(FriendlyByteBuf buffer, IndustrialSluiceRecipe recipe) {
        NonNullList<StackWithChance> byproducts = recipe.getByproducts();
        int size = byproducts.size();
        buffer.writeInt(size);
        for (int index = 0; index < size; ++index) {
            ((StackWithChance)byproducts.get(index)).write(buffer);
        }
    }

    public void toNetwork(FriendlyByteBuf buffer, IndustrialSluiceRecipe recipe) {
        IndustrialSluiceRecipeSerializer.writeLazyStack((FriendlyByteBuf)buffer, recipe.itemOutput);
        this.writeByproducts(buffer, recipe);
        recipe.itemIn.m_43923_(buffer);
        buffer.writeInt(recipe.getTotalProcessTime());
        buffer.writeInt(recipe.getTotalProcessWater());
        buffer.writeInt(recipe.getTotalProcessEnergy());
    }
}

