/*
 * Decompiled with CFR 0.152.
 */
package com.igteam.immersivegeology.common.block.multiblocks.recipe.serializer;

import blusunrize.immersiveengineering.api.crafting.IERecipeSerializer;
import blusunrize.immersiveengineering.api.crafting.IngredientWithSize;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.igteam.immersivegeology.common.block.multiblocks.recipe.RevFurnaceRecipe;
import com.igteam.immersivegeology.core.registration.IGMultiblockProvider;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraftforge.common.crafting.conditions.ICondition;
import net.minecraftforge.common.util.Lazy;
import org.jetbrains.annotations.Nullable;

public class RevFurnaceRecipeSerializer
extends IERecipeSerializer<RevFurnaceRecipe> {
    public ItemStack getIcon() {
        return IGMultiblockProvider.REVERBERATION_FURNACE.iconStack();
    }

    public RevFurnaceRecipe readFromJson(ResourceLocation resourceLocation, JsonObject json, ICondition.IContext iContext) {
        Lazy output = RevFurnaceRecipeSerializer.readOutput((JsonElement)json.get("result"));
        Ingredient input = Ingredient.m_43917_((JsonElement)GsonHelper.m_13930_((JsonObject)json, (String)"input"));
        int waste_amount = GsonHelper.m_13927_((JsonObject)json, (String)"waste");
        int time = GsonHelper.m_13927_((JsonObject)json, (String)"time");
        return new RevFurnaceRecipe(resourceLocation, new IngredientWithSize(input), (Lazy<ItemStack>)output, waste_amount, time);
    }

    @Nullable
    public RevFurnaceRecipe fromNetwork(ResourceLocation resourceLocation, FriendlyByteBuf buffer) {
        Lazy output = RevFurnaceRecipeSerializer.readLazyStack((FriendlyByteBuf)buffer);
        IngredientWithSize input = IngredientWithSize.read((FriendlyByteBuf)buffer);
        int waste = buffer.readInt();
        int time = buffer.readInt();
        return new RevFurnaceRecipe(resourceLocation, input, (Lazy<ItemStack>)output, waste, time);
    }

    public void toNetwork(FriendlyByteBuf buffer, RevFurnaceRecipe recipe) {
        RevFurnaceRecipeSerializer.writeLazyStack((FriendlyByteBuf)buffer, recipe.result);
        recipe.input.write(buffer);
        buffer.writeInt(recipe.getWasteAmount());
        buffer.writeInt(recipe.getTotalProcessTime());
    }
}

