/*
 * Decompiled with CFR 0.152.
 */
package com.igteam.immersivegeology.common.block.multiblocks.recipe.serializer;

import blusunrize.immersiveengineering.api.crafting.IERecipeSerializer;
import blusunrize.immersiveengineering.common.network.PacketUtils;
import com.google.gson.JsonObject;
import com.igteam.immersivegeology.common.block.multiblocks.recipe.TurbineFuel;
import com.igteam.immersivegeology.core.registration.IGMultiblockProvider;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.common.crafting.conditions.ICondition;
import net.minecraftforge.registries.ForgeRegistries;

public class TurbineFuelSerializer
extends IERecipeSerializer<TurbineFuel> {
    public ItemStack getIcon() {
        return IGMultiblockProvider.STEAM_TURBINE.iconStack();
    }

    public TurbineFuel readFromJson(ResourceLocation recipeId, JsonObject json, ICondition.IContext context) {
        ResourceLocation tagName = new ResourceLocation(json.get("fluidTag").getAsString());
        TagKey tag = TagKey.m_203882_((ResourceKey)Registries.f_256808_, (ResourceLocation)tagName);
        int amount = json.get("consume_amount").getAsInt();
        int burn_time = json.get("burnTime").getAsInt();
        float outputRatio = json.get("outputRatio").getAsFloat();
        return new TurbineFuel(recipeId, (TagKey<Fluid>)tag, outputRatio, amount, burn_time);
    }

    @Nullable
    public TurbineFuel fromNetwork(@Nonnull ResourceLocation recipeId, @Nonnull FriendlyByteBuf buffer) {
        List fluids = PacketUtils.readList((FriendlyByteBuf)buffer, buf -> (Fluid)buf.readRegistryIdUnsafe(ForgeRegistries.FLUIDS));
        int consume_amount = buffer.readInt();
        int burnTime = buffer.readInt();
        float outputRatio = buffer.readFloat();
        return new TurbineFuel(recipeId, fluids, outputRatio, consume_amount, burnTime);
    }

    public void toNetwork(@Nonnull FriendlyByteBuf buffer, @Nonnull TurbineFuel recipe) {
        PacketUtils.writeList((FriendlyByteBuf)buffer, recipe.getFluids(), (f, buf) -> buf.writeRegistryIdUnsafe(ForgeRegistries.FLUIDS, f));
        buffer.writeInt(recipe.getConsumed());
        buffer.writeInt(recipe.getBurnTime());
        buffer.writeFloat(recipe.getOutputRatio());
    }
}

