/*
 * Decompiled with CFR 0.152.
 */
package com.igteam.immersivegeology.common.block.ore;

import com.igteam.immersivegeology.client.menu.ItemSubGroup;
import com.igteam.immersivegeology.common.block.IGGenericBlock;
import com.igteam.immersivegeology.common.block.helper.IGBlockType;
import com.igteam.immersivegeology.common.block.ore.IGEvaporateMineralBlock;
import com.igteam.immersivegeology.core.material.helper.flags.BlockCategoryFlags;
import com.igteam.immersivegeology.core.material.helper.flags.IFlagType;
import com.igteam.immersivegeology.core.material.helper.flags.ItemCategoryFlags;
import com.igteam.immersivegeology.core.material.helper.material.MaterialInterface;
import com.igteam.immersivegeology.core.material.helper.material.MaterialTexture;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.ForgeHooks;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class IGCrystalBlock
extends IGGenericBlock
implements IGBlockType {
    public static final IntegerProperty AGE = BlockStateProperties.f_61406_;
    protected final Map<MaterialTexture, MaterialInterface<?>> materialMap = new HashMap();
    protected final BlockCategoryFlags category;
    VoxelShape AGE_0 = Shapes.m_83048_((double)0.1875, (double)0.0, (double)0.1875, (double)0.8125, (double)0.3125, (double)0.8125);
    VoxelShape AGE_1 = Shapes.m_83048_((double)0.1875, (double)0.0, (double)0.1875, (double)0.8125, (double)0.375, (double)0.8125);
    VoxelShape AGE_2 = Shapes.m_83048_((double)0.125, (double)0.0, (double)0.125, (double)0.875, (double)0.625, (double)0.875);

    public IGCrystalBlock(BlockCategoryFlags flag, MaterialInterface<?> material) {
        super(flag, material, BlockBehaviour.Properties.m_284310_().m_60977_().m_60918_(SoundType.f_154655_).m_60910_().m_60913_(1.5f, 1.0f).m_60988_());
        this.m_49959_((BlockState)this.m_49966_().m_61124_((Property)AGE, (Comparable)Integer.valueOf(0)));
        this.materialMap.put(MaterialTexture.base, material);
        this.category = flag;
    }

    public int getMaxAge() {
        return 2;
    }

    public BlockState getStateForAge(int pAge) {
        return (BlockState)this.m_49966_().m_61124_((Property)this.getAgeProperty(), (Comparable)Integer.valueOf(pAge));
    }

    @Nullable
    public PushReaction getPistonPushReaction(BlockState state) {
        return PushReaction.DESTROY;
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        int age = (Integer)state.m_61143_((Property)AGE);
        return age == 0 ? this.AGE_0 : (age == 1 ? this.AGE_1 : this.AGE_2);
    }

    public void m_213898_(BlockState pState, ServerLevel pLevel, BlockPos pPos, RandomSource pRandom) {
        if (pLevel.isAreaLoaded(pPos, 1)) {
            float f;
            int i = this.getAge(pState);
            int stageIncrement = 1;
            if (pLevel.m_46471_() && pLevel.m_45527_(pPos.m_7494_())) {
                if (i > 0) {
                    stageIncrement = -1;
                }
                if (i == 0) {
                    stageIncrement = 0;
                }
            }
            if ((i < this.getMaxAge() || stageIncrement < 0) && ForgeHooks.onCropsGrowPre((Level)pLevel, (BlockPos)pPos, (BlockState)pState, (pRandom.m_188503_((int)(25.0f / (f = 1.0f)) + 1) == 0 ? 1 : 0) != 0)) {
                pLevel.m_7731_(pPos, this.getStateForAge(i + stageIncrement), 2);
                ForgeHooks.onCropsGrowPost((Level)pLevel, (BlockPos)pPos, (BlockState)pState);
            }
        }
    }

    public void m_6861_(BlockState state, Level level, BlockPos pos, Block neighborBlock, BlockPos neighborPos, boolean moved) {
        super.m_6861_(state, level, pos, neighborBlock, neighborPos, moved);
        for (Direction direction : Direction.values()) {
            BlockPos adjacentPos = pos.m_121945_(direction);
            BlockState adjacentState = level.m_8055_(adjacentPos);
            if (!direction.equals((Object)Direction.DOWN) || !adjacentState.m_60795_()) continue;
            level.m_46961_(pos, false);
        }
    }

    public boolean isFlammable(BlockState state, BlockGetter level, BlockPos pos, Direction direction) {
        return false;
    }

    public int getAge(BlockState state) {
        return (Integer)state.m_61143_((Property)this.getAgeProperty());
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{AGE});
    }

    protected boolean mayPlaceOn(BlockState state, BlockGetter level, BlockPos pos) {
        return state.m_60734_() instanceof IGEvaporateMineralBlock;
    }

    public boolean m_7898_(BlockState state, LevelReader level, BlockPos pos) {
        return this.mayPlaceOn(level.m_8055_(pos), (BlockGetter)level, pos.m_7495_());
    }

    @Override
    public IFlagType<?> getFlag() {
        return this.category;
    }

    @Override
    public ItemSubGroup getGroup() {
        return this.category.getSubGroup();
    }

    @Override
    public int getColor(int index, BlockState state) {
        return this.materialMap.get((Object)MaterialTexture.values()[index > 0 ? 1 : 0]).getColor(this.category, 0);
    }

    @Override
    @NotNull
    public Collection<MaterialInterface<?>> getMaterials() {
        return this.materialMap.values();
    }

    @Override
    public MaterialInterface<?> getMaterial(MaterialTexture t) {
        return this.materialMap.get((Object)t);
    }

    @Override
    public Block getIGBlock() {
        return this;
    }

    @Override
    public Map<MaterialTexture, MaterialInterface<?>> getMaterialMap() {
        return this.materialMap;
    }

    public IntegerProperty getAgeProperty() {
        return AGE;
    }

    public List<ItemStack> m_49635_(BlockState state, LootParams.Builder builder) {
        if (((Integer)state.m_61143_((Property)this.getAgeProperty())).intValue() == this.getMaxAge()) {
            return super.m_49635_(state, builder);
        }
        return List.of();
    }

    public ItemLike getItemDrop() {
        return this.getMaterial(MaterialTexture.base).getItem(ItemCategoryFlags.CRYSTAL);
    }
}

