/*
 * Decompiled with CFR 0.152.
 */
package com.igteam.immersivegeology.common.block.ore;

import blusunrize.immersiveengineering.common.register.IEItems;
import com.igteam.immersivegeology.common.block.IGGenericBlock;
import com.igteam.immersivegeology.common.block.helper.IOreBlock;
import com.igteam.immersivegeology.common.block.helper.OreRichness;
import com.igteam.immersivegeology.core.material.data.enums.MineralEnum;
import com.igteam.immersivegeology.core.material.data.types.MaterialStone;
import com.igteam.immersivegeology.core.material.helper.flags.BlockCategoryFlags;
import com.igteam.immersivegeology.core.material.helper.flags.IFlagType;
import com.igteam.immersivegeology.core.material.helper.flags.ItemCategoryFlags;
import com.igteam.immersivegeology.core.material.helper.flags.ModFlags;
import com.igteam.immersivegeology.core.material.helper.material.MaterialInterface;
import com.igteam.immersivegeology.core.material.helper.material.MaterialTexture;
import com.igteam.immersivegeology.core.material.helper.material.StoneFormation;
import com.mojang.datafixers.util.Pair;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.client.extensions.common.IClientBlockExtensions;
import org.jetbrains.annotations.NotNull;

public class IGOreBlock
extends IGGenericBlock
implements IOreBlock {
    protected final OreRichness richness;

    public IGOreBlock(BlockCategoryFlags flag, MaterialInterface<?> baseMaterial, MaterialInterface<?> oreMaterial, OreRichness richness) {
        super(flag, baseMaterial);
        this.materialMap.put(MaterialTexture.overlay, oreMaterial);
        this.richness = richness;
    }

    @Override
    public int getColor(int index, BlockState state) {
        if (index > 0) {
            return ((MaterialInterface)this.materialMap.get((Object)MaterialTexture.values()[1])).getColor(this.category, 0);
        }
        return ((MaterialInterface)this.materialMap.get((Object)MaterialTexture.values()[0])).getColor(this.category, 0);
    }

    public void initializeClient(Consumer<IClientBlockExtensions> consumer) {
        super.initializeClient(consumer);
    }

    public boolean m_6724_(BlockState state) {
        return this.materialMap.values().stream().anyMatch(MaterialInterface::canTarnish);
    }

    @Override
    public BlockState getIGDefaultBlockState() {
        return this.m_49966_();
    }

    @Override
    public String getIGDescriptionId() {
        return this.m_7705_();
    }

    @Override
    public Item asIGItem() {
        return this.m_5456_();
    }

    @Override
    @NotNull
    public Block asIGBlock() {
        return this.m_7374_();
    }

    @Override
    public OreRichness getOreRichness() {
        return this.richness;
    }

    @Override
    public StoneFormation getStoneFormation() {
        Object t = ((MaterialInterface)this.materialMap.get((Object)MaterialTexture.base)).instance();
        if (t instanceof MaterialStone) {
            MaterialStone stone = (MaterialStone)t;
            return stone.getStoneFormation();
        }
        return null;
    }

    @Override
    public ModFlags getModFlag() {
        ModFlags flag = ModFlags.MINECRAFT;
        Object t = ((MaterialInterface)this.materialMap.get((Object)MaterialTexture.base)).instance();
        if (t instanceof MaterialStone) {
            MaterialStone stone = (MaterialStone)t;
            Set<IFlagType<?>> flags = stone.getFlags();
            for (IFlagType<?> unknown_flag : flags) {
                Object obj = unknown_flag.getValue();
                if (!(obj instanceof ModFlags)) continue;
                ModFlags modFlag = (ModFlags)obj;
                if (!Arrays.asList(ModFlags.values()).contains(modFlag)) continue;
                flag = modFlag;
            }
        }
        return flag;
    }

    @Override
    public ItemStack getItemDrop() {
        MaterialInterface<ItemCategoryFlags> ore_mat = this.getMaterial(MaterialTexture.overlay);
        if (ore_mat.hasFlag(ItemCategoryFlags.POOR_ORE) && ore_mat.hasFlag(ItemCategoryFlags.RICH_ORE)) {
            return ore_mat.getStack(this.getOreRichness().toCategory());
        }
        return ore_mat.getStack(ItemCategoryFlags.NORMAL_ORE, 1 + this.getOreRichness().ordinal());
    }

    @Override
    public List<Pair<ItemStack, Float>> getExtraDrops() {
        MaterialInterface<?> ore_mat = this.getMaterial(MaterialTexture.overlay);
        if (ore_mat.equals(MineralEnum.Bituminous)) {
            return List.of(Pair.of((Object)new ItemStack((ItemLike)IEItems.Ingredients.DUST_SULFUR), (Object)Float.valueOf(0.075f)));
        }
        return List.of();
    }
}

