/*
 * Decompiled with CFR 0.152.
 */
package com.igteam.immersivegeology.common.block.ore;

import com.igteam.immersivegeology.common.block.IGGenericBlock;
import com.igteam.immersivegeology.common.block.helper.IOreBlock;
import com.igteam.immersivegeology.common.block.helper.MineralWeathering;
import com.igteam.immersivegeology.common.block.helper.OreRichness;
import com.igteam.immersivegeology.core.material.data.types.MaterialStone;
import com.igteam.immersivegeology.core.material.helper.flags.BlockCategoryFlags;
import com.igteam.immersivegeology.core.material.helper.flags.IFlagType;
import com.igteam.immersivegeology.core.material.helper.flags.ModFlags;
import com.igteam.immersivegeology.core.material.helper.material.MaterialInterface;
import com.igteam.immersivegeology.core.material.helper.material.MaterialTexture;
import com.igteam.immersivegeology.core.material.helper.material.StoneFormation;
import com.mojang.datafixers.util.Pair;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.client.extensions.common.IClientBlockExtensions;
import org.jetbrains.annotations.NotNull;

public class IGWeatheringOreBlock
extends IGGenericBlock
implements IOreBlock {
    protected final OreRichness richness;
    public static final EnumProperty<MineralWeathering> OXIDATION_UP = EnumProperty.m_61587_((String)"oxidation_up", MineralWeathering.class);
    public static final EnumProperty<MineralWeathering> OXIDATION_DOWN = EnumProperty.m_61587_((String)"oxidation_down", MineralWeathering.class);
    public static final EnumProperty<MineralWeathering> OXIDATION_EAST = EnumProperty.m_61587_((String)"oxidation_east", MineralWeathering.class);
    public static final EnumProperty<MineralWeathering> OXIDATION_WEST = EnumProperty.m_61587_((String)"oxidation_west", MineralWeathering.class);
    public static final EnumProperty<MineralWeathering> OXIDATION_NORTH = EnumProperty.m_61587_((String)"oxidation_north", MineralWeathering.class);
    public static final EnumProperty<MineralWeathering> OXIDATION_SOUTH = EnumProperty.m_61587_((String)"oxidation_south", MineralWeathering.class);
    public static List<EnumProperty<MineralWeathering>> OXIDATION_PROPERTIES = List.of(OXIDATION_DOWN, OXIDATION_UP, OXIDATION_NORTH, OXIDATION_SOUTH, OXIDATION_WEST, OXIDATION_EAST);
    private static final Direction[] DIRECTIONS = Direction.values();

    public IGWeatheringOreBlock(BlockCategoryFlags flag, MaterialInterface<?> baseMaterial, MaterialInterface<?> oreMaterial) {
        this(flag, baseMaterial, oreMaterial, OreRichness.POOR);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_(OXIDATION_UP, (Comparable)((Object)MineralWeathering.PRISTINE))).m_61124_(OXIDATION_DOWN, (Comparable)((Object)MineralWeathering.PRISTINE))).m_61124_(OXIDATION_EAST, (Comparable)((Object)MineralWeathering.PRISTINE))).m_61124_(OXIDATION_WEST, (Comparable)((Object)MineralWeathering.PRISTINE))).m_61124_(OXIDATION_NORTH, (Comparable)((Object)MineralWeathering.PRISTINE))).m_61124_(OXIDATION_SOUTH, (Comparable)((Object)MineralWeathering.PRISTINE)));
    }

    public IGWeatheringOreBlock(BlockCategoryFlags flag, MaterialInterface<?> baseMaterial, MaterialInterface<?> oreMaterial, OreRichness richness) {
        super(flag, baseMaterial);
        this.materialMap.put(MaterialTexture.overlay, oreMaterial);
        this.richness = richness;
    }

    @Override
    public int getColor(int index, BlockState state) {
        if (index > 0) {
            MineralWeathering mineralWeathering = (MineralWeathering)((Object)state.m_61143_((Property)OXIDATION_PROPERTIES.get(index - 1)));
            return ((MaterialInterface)this.materialMap.get((Object)MaterialTexture.values()[index > 0 ? 1 : 0])).getColor(this.category, mineralWeathering.ordinal());
        }
        return ((MaterialInterface)this.materialMap.get((Object)MaterialTexture.values()[0])).getColor(this.category, 0);
    }

    public void initializeClient(Consumer<IClientBlockExtensions> consumer) {
        super.initializeClient(consumer);
    }

    public boolean m_6724_(BlockState state) {
        return this.materialMap.values().stream().anyMatch(MaterialInterface::canTarnish);
    }

    public void m_213898_(BlockState state, ServerLevel level, BlockPos pos, RandomSource rnd) {
        if (!level.f_46443_) {
            for (int i = 0; i < DIRECTIONS.length; ++i) {
                Direction direction = DIRECTIONS[i];
                EnumProperty<MineralWeathering> oxidationProperty = OXIDATION_PROPERTIES.get(i);
                BlockPos adjacentPos = pos.m_121955_(direction.m_122436_());
                this.handleOxidation(state, level, pos, rnd, oxidationProperty, adjacentPos);
            }
        }
    }

    private void handleOxidation(BlockState state, ServerLevel level, BlockPos pos, RandomSource rnd, EnumProperty<MineralWeathering> oxidationProperty, BlockPos adjacentPos) {
        if (level.m_8055_(adjacentPos).m_60795_()) {
            MineralWeathering next;
            MineralWeathering current = (MineralWeathering)((Object)state.m_61143_(oxidationProperty));
            if (current.equals((Object)(next = this.nextWeatherStage(current)))) {
                return;
            }
            if ((double)rnd.m_188501_() < 0.2) {
                level.m_7731_(pos, (BlockState)state.m_61124_(oxidationProperty, (Comparable)((Object)next)), 2);
            }
        }
    }

    private MineralWeathering nextWeatherStage(MineralWeathering currentStage) {
        MineralWeathering[] values;
        int ord = currentStage.ordinal();
        if (ord + 1 >= (values = MineralWeathering.values()).length) {
            return currentStage;
        }
        return values[ord + 1];
    }

    @Override
    public OreRichness getOreRichness() {
        return this.richness;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{OXIDATION_DOWN, OXIDATION_UP, OXIDATION_EAST, OXIDATION_WEST, OXIDATION_NORTH, OXIDATION_SOUTH});
    }

    @Override
    public StoneFormation getStoneFormation() {
        Object t = ((MaterialInterface)this.materialMap.get((Object)MaterialTexture.base)).instance();
        if (t instanceof MaterialStone) {
            MaterialStone stone = (MaterialStone)t;
            return stone.getStoneFormation();
        }
        return null;
    }

    @Override
    public ModFlags getModFlag() {
        ModFlags flag = ModFlags.MINECRAFT;
        Object t = ((MaterialInterface)this.materialMap.get((Object)MaterialTexture.base)).instance();
        if (t instanceof MaterialStone) {
            MaterialStone stone = (MaterialStone)t;
            Set<IFlagType<?>> flags = stone.getFlags();
            for (IFlagType<?> unknown_flag : flags) {
                Object obj = unknown_flag.getValue();
                if (!(obj instanceof ModFlags)) continue;
                ModFlags modFlag = (ModFlags)obj;
                if (!Arrays.asList(ModFlags.values()).contains(modFlag)) continue;
                flag = modFlag;
            }
        }
        return flag;
    }

    @Override
    public ItemStack getItemDrop() {
        return this.getMaterial(MaterialTexture.overlay).getStack(this.getOreRichness().toCategory());
    }

    @Override
    public List<Pair<ItemStack, Float>> getExtraDrops() {
        return List.of();
    }

    @Override
    public BlockState getIGDefaultBlockState() {
        return this.m_49966_();
    }

    @Override
    public String getIGDescriptionId() {
        return this.m_7705_();
    }

    @Override
    public Item asIGItem() {
        return this.m_5456_();
    }

    @Override
    @NotNull
    public Block asIGBlock() {
        return this.m_7374_();
    }
}

