/*
 * Decompiled with CFR 0.152.
 */
package com.igteam.immersivegeology.common.block.structural;

import blusunrize.immersiveengineering.common.blocks.generic.ScaffoldingBlock;
import blusunrize.immersiveengineering.common.blocks.metal.FluidPipeBlockEntity;
import blusunrize.immersiveengineering.common.blocks.metal.MetalScaffoldingType;
import blusunrize.immersiveengineering.common.register.IEBlocks;
import com.igteam.immersivegeology.client.menu.ItemSubGroup;
import com.igteam.immersivegeology.common.block.entity.cable.IGEnergyPipeEntity;
import com.igteam.immersivegeology.common.block.helper.IGBlockType;
import com.igteam.immersivegeology.core.material.helper.flags.BlockCategoryFlags;
import com.igteam.immersivegeology.core.material.helper.flags.IFlagType;
import com.igteam.immersivegeology.core.material.helper.material.MaterialInterface;
import com.igteam.immersivegeology.core.material.helper.material.MaterialTexture;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;

public class IGScaffoldingBlock
extends ScaffoldingBlock
implements IGBlockType {
    protected final Map<MaterialTexture, MaterialInterface<?>> materialMap = new HashMap();
    protected final BlockCategoryFlags category;
    protected final MetalScaffoldingType type;

    public IGScaffoldingBlock(MetalScaffoldingType type, MaterialInterface<?> material) {
        super(((BlockBehaviour.Properties)IEBlocks.METAL_PROPERTIES_NO_OCCLUSION.get()).m_155956_(1200.0f));
        this.materialMap.put(MaterialTexture.base, material);
        this.category = BlockCategoryFlags.SCAFFOLDING;
        this.type = type;
        FluidPipeBlockEntity.validPipeCovers.add(input -> input == this);
        FluidPipeBlockEntity.climbablePipeCovers.add(input -> input == this);
        IGEnergyPipeEntity.validPipeCovers.add(input -> input == this);
        IGEnergyPipeEntity.climbablePipeCovers.add(input -> input == this);
    }

    @Override
    public IFlagType<?> getFlag() {
        return this.category;
    }

    @Override
    public ItemSubGroup getGroup() {
        return this.category.getSubGroup();
    }

    @Override
    public int getColor(int index, BlockState state) {
        return this.materialMap.get((Object)MaterialTexture.values()[index > 0 ? 1 : 0]).getColor(this.category, 0);
    }

    @Override
    @NotNull
    public Collection<MaterialInterface<?>> getMaterials() {
        return this.materialMap.values();
    }

    @Override
    public MaterialInterface<?> getMaterial(MaterialTexture t) {
        return this.materialMap.get((Object)t);
    }

    @Override
    public Block getIGBlock() {
        return this;
    }

    public MetalScaffoldingType getScaffoldingType() {
        return this.type;
    }

    @Override
    public Map<MaterialTexture, MaterialInterface<?>> getMaterialMap() {
        return this.materialMap;
    }
}

