/*
 * Decompiled with CFR 0.152.
 */
package com.igteam.immersivegeology.common.commands;

import com.igteam.immersivegeology.common.event.IGCommonForgeEvents;
import com.igteam.immersivegeology.common.event.VeinScanTask;
import com.igteam.immersivegeology.core.lib.IGLib;
import com.igteam.immersivegeology.core.material.data.enums.MetalEnum;
import com.igteam.immersivegeology.core.material.data.enums.MineralEnum;
import com.igteam.immersivegeology.core.material.helper.flags.BlockCategoryFlags;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.Arrays;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentUtils;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Mth;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.chunk.LevelChunkSection;
import net.minecraftforge.server.command.EnumArgument;
import org.slf4j.Logger;

public class IGFindMineralVeinCommand {
    private static final Logger LOGGER = IGLib.getNewLogger();

    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"locate").requires(source -> source.m_6761_(2))).then(Commands.m_82127_((String)"mineral").then(Commands.m_82129_((String)"type", (ArgumentType)EnumArgument.enumArgument(MineralEnum.class)).then(Commands.m_82129_((String)"radius", (ArgumentType)IntegerArgumentType.integer((int)0, (int)32)).executes(context -> {
            MineralEnum mineral = (MineralEnum)context.getArgument("type", MineralEnum.class);
            int radius = IntegerArgumentType.getInteger((CommandContext)context, (String)"radius");
            IGFindMineralVeinCommand.findMineralVienAsync((CommandSourceStack)context.getSource(), mineral, radius);
            return 1;
        })))));
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"locate").requires(source -> source.m_6761_(2))).then(Commands.m_82127_((String)"metal").then(Commands.m_82129_((String)"type", (ArgumentType)StringArgumentType.word()).suggests((ctx, builder) -> {
            for (MetalEnum metal : MetalEnum.values()) {
                if (!metal.hasFlag(BlockCategoryFlags.ORE_BLOCK)) continue;
                builder.suggest(metal.name().toLowerCase());
            }
            return builder.buildFuture();
        }).then(Commands.m_82129_((String)"radius", (ArgumentType)IntegerArgumentType.integer((int)0, (int)32)).executes(context -> {
            String typeName = StringArgumentType.getString((CommandContext)context, (String)"type");
            MetalEnum metal = Arrays.stream(MetalEnum.values()).filter(m -> m.name().equalsIgnoreCase(typeName) && m.hasFlag(BlockCategoryFlags.ORE_BLOCK)).findFirst().orElseThrow(() -> new IllegalArgumentException("Invalid native metal: " + typeName));
            int radius = IntegerArgumentType.getInteger((CommandContext)context, (String)"radius");
            IGFindMineralVeinCommand.findMetalVienAsync((CommandSourceStack)context.getSource(), metal, radius);
            return 1;
        })))));
    }

    public static void findMineralVienAsync(CommandSourceStack source, MineralEnum type, int radius) {
        source.m_288197_(() -> Component.m_237113_((String)"Locating Mineral Vein..."), false);
        source.m_81377_().m_18707_(() -> {
            if (source.m_230896_() == null) {
                source.m_81352_((Component)Component.m_237113_((String)"Command must be run by a player"));
            }
            IGCommonForgeEvents.activeVeinScans.add(new VeinScanTask(source, source.m_81372_(), type, radius));
        });
    }

    public static void findMetalVienAsync(CommandSourceStack source, MetalEnum type, int radius) {
        source.m_288197_(() -> Component.m_237113_((String)"Locating Native Metal Vein..."), false);
        source.m_81377_().m_18707_(() -> {
            if (source.m_230896_() == null) {
                source.m_81352_((Component)Component.m_237113_((String)"Command must be run by a player"));
            }
            IGCommonForgeEvents.activeVeinScans.add(new VeinScanTask(source, source.m_81372_(), type, radius));
        });
    }

    public static boolean findMineralVien(CommandSourceStack source, ServerLevel level, MineralEnum type, int radius) throws CommandSyntaxException {
        ServerPlayer player = source.m_81375_();
        ChunkPos playerPos = player.m_146902_();
        int minBuildHeight = level.m_141937_();
        int maxBuildHeight = level.m_151558_();
        int sectionMin = level.m_151564_(minBuildHeight);
        int sectionMax = level.m_151564_(maxBuildHeight);
        TagKey<Block> materialTag = type.getBlockMaterialTag();
        for (int x = -radius; x <= radius; ++x) {
            for (int z = -radius; z <= radius; ++z) {
                ChunkPos currentChunk = new ChunkPos(playerPos.f_45578_ + x, playerPos.f_45579_ + z);
                LevelChunk chunk = level.m_6325_(currentChunk.f_45578_, currentChunk.f_45579_);
                for (int sectionIndex = sectionMin; sectionIndex < sectionMax; ++sectionIndex) {
                    LevelChunkSection section = chunk.m_183278_(sectionIndex);
                    if (section.m_188008_() || !section.m_63002_(b -> b.m_204336_(materialTag))) continue;
                    BlockPos orePosition = chunk.m_7697_().m_45615_();
                    int distance = Mth.m_14143_((float)Mth.m_14116_((float)((float)source.m_81371_().m_82531_((double)orePosition.m_123341_(), (double)orePosition.m_123342_(), (double)orePosition.m_123343_()))));
                    MutableComponent coordinates = ComponentUtils.m_130748_((Component)Component.m_237110_((String)"chat.coordinates", (Object[])new Object[]{orePosition.m_123341_(), orePosition.m_123342_(), orePosition.m_123343_()})).m_130938_(style -> style.m_131140_(ChatFormatting.GREEN).m_131142_(new ClickEvent(ClickEvent.Action.SUGGEST_COMMAND, "/tp @s " + orePosition.m_123341_() + " ~ " + orePosition.m_123343_())).m_131144_(new HoverEvent(HoverEvent.Action.f_130831_, (Object)Component.m_237115_((String)"chat.coordinates.tooltip"))));
                    source.m_288197_(() -> IGFindMineralVeinCommand.lambda$findMineralVien$13(type, (Component)coordinates, distance), false);
                    return true;
                }
            }
        }
        source.m_81352_((Component)Component.m_237113_((String)("No " + type.name() + " ore vein found within " + radius + " chunk radius.")));
        return false;
    }

    private static /* synthetic */ Component lambda$findMineralVien$13(MineralEnum type, Component coordinates, int distance) {
        return Component.m_237110_((String)"command.immersivegeology.veinlocate", (Object[])new Object[]{type.name(), coordinates, distance});
    }
}

