/*
 * Decompiled with CFR 0.152.
 */
package com.igteam.immersivegeology.common.fluid;

import com.igteam.immersivegeology.client.menu.ItemSubGroup;
import com.igteam.immersivegeology.common.block.helper.IGBlockType;
import com.igteam.immersivegeology.common.fluid.IGFluidType;
import com.igteam.immersivegeology.core.material.helper.flags.BlockCategoryFlags;
import com.igteam.immersivegeology.core.material.helper.flags.IFlagType;
import com.igteam.immersivegeology.core.material.helper.flags.ItemCategoryFlags;
import com.igteam.immersivegeology.core.material.helper.flags.MaterialFlags;
import com.igteam.immersivegeology.core.material.helper.material.MaterialInterface;
import com.igteam.immersivegeology.core.material.helper.material.MaterialTexture;
import com.igteam.immersivegeology.core.registration.IGRegistrationHolder;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.BlockSource;
import net.minecraft.core.Direction;
import net.minecraft.core.dispenser.DefaultDispenseItemBehavior;
import net.minecraft.core.dispenser.DispenseItemBehavior;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.DispenserBlock;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FlowingFluid;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.fluids.FluidType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class IGFluid
extends FlowingFluid
implements IGBlockType {
    protected final Map<MaterialTexture, MaterialInterface<?>> materialMap = new HashMap();
    protected final BlockCategoryFlags category;
    protected final ItemCategoryFlags bucket_type;
    protected final Supplier<FluidType> type;
    private FluidType cached;
    public static final DispenseItemBehavior BUCKET_DISPENSE_BEHAVIOR = new DefaultDispenseItemBehavior(){
        private final DefaultDispenseItemBehavior defaultBehavior = new DefaultDispenseItemBehavior();

        public ItemStack m_7498_(BlockSource source, ItemStack stack) {
            BucketItem bucketitem = (BucketItem)stack.m_41720_();
            BlockPos blockpos = source.m_7961_().m_121945_((Direction)source.m_6414_().m_61143_((Property)DispenserBlock.f_52659_));
            ServerLevel world = source.m_7727_();
            if (bucketitem.m_142073_((Player)null, (Level)world, blockpos, (BlockHitResult)null)) {
                bucketitem.m_142131_((Player)null, (Level)world, stack, blockpos);
                return new ItemStack((ItemLike)Items.f_42446_);
            }
            return this.defaultBehavior.m_6115_(source, stack);
        }
    };

    public IGFluid(BlockCategoryFlags flag, ItemCategoryFlags bucket_type, MaterialInterface<?> material, MaterialInterface<?> overlay) {
        this.materialMap.put(MaterialTexture.base, material);
        if (overlay != null) {
            this.materialMap.put(MaterialTexture.overlay, overlay);
        }
        this.category = flag;
        this.bucket_type = bucket_type;
        this.type = () -> new IGFluidType(this, material, overlay, this.category);
    }

    @Override
    public IFlagType<?> getFlag() {
        return this.category;
    }

    @Override
    public ItemSubGroup getGroup() {
        return this.category.getSubGroup();
    }

    @Override
    public int getColor(int index, BlockState state) {
        return this.materialMap.get((Object)MaterialTexture.values()[index]).getColor(this.category, 0);
    }

    @Override
    public MaterialInterface<?> getMaterial(MaterialTexture t) {
        return this.materialMap.get((Object)t);
    }

    @NotNull
    public FluidType getFluidType() {
        if (this.cached == null) {
            this.cached = this.type.get();
        }
        return this.cached;
    }

    @Override
    @NotNull
    public Collection<MaterialInterface<?>> getMaterials() {
        return this.materialMap.values();
    }

    @Override
    public Block getIGBlock() {
        IFlagType<?> flag = this.getFlag();
        String key = this.materialMap.size() > 1 ? flag.getRegistryKey(this.getMaterial(MaterialTexture.base), this.getMaterial(MaterialTexture.overlay)) : flag.getRegistryKey(this.getMaterial(MaterialTexture.base));
        return IGRegistrationHolder.getBlock.apply(key + "_block");
    }

    @Override
    public Map<MaterialTexture, MaterialInterface<?>> getMaterialMap() {
        return this.materialMap;
    }

    public Fluid m_5615_() {
        IFlagType<?> flag = this.getFlag();
        String key = this.materialMap.size() > 1 ? flag.getRegistryKey(this.getMaterial(MaterialTexture.base), this.getMaterial(MaterialTexture.overlay)) : flag.getRegistryKey(this.getMaterial(MaterialTexture.base));
        return IGRegistrationHolder.getFluid.apply(key + "_flowing");
    }

    @NotNull
    public Fluid m_5613_() {
        IFlagType<?> flag = this.getFlag();
        String key = this.materialMap.size() > 1 ? flag.getRegistryKey(this.getMaterial(MaterialTexture.base), this.getMaterial(MaterialTexture.overlay)) : flag.getRegistryKey(this.getMaterial(MaterialTexture.base));
        return IGRegistrationHolder.getFluid.apply(key);
    }

    protected void m_213811_(Level pLevel, BlockPos pPos, FluidState pState, RandomSource pRandom) {
        super.m_213811_(pLevel, pPos, pState, pRandom);
    }

    protected void m_213812_(Level pLevel, BlockPos pPos, FluidState pState, RandomSource pRandom) {
        super.m_213812_(pLevel, pPos, pState, pRandom);
    }

    @Nullable
    protected ParticleOptions m_7792_() {
        return this.getMaterial(MaterialTexture.base).hasFlag(MaterialFlags.IS_MOLTEN_METAL) ? ParticleTypes.f_123800_ : ParticleTypes.f_123803_;
    }

    private void fizz(LevelAccessor pLevel, BlockPos pPos) {
        pLevel.m_46796_(1501, pPos, 0);
    }

    protected void m_7456_(LevelAccessor level, BlockPos blockPos, BlockState blockState) {
        this.fizz(level, blockPos);
    }

    public boolean canConvertToSource(FluidState state, Level level, BlockPos pos) {
        return false;
    }

    protected boolean m_6760_(Level level) {
        return false;
    }

    protected boolean m_6685_() {
        return true;
    }

    protected float m_6752_() {
        return 100.0f;
    }

    public Optional<SoundEvent> m_142520_() {
        return this.getMaterial(MaterialTexture.base).hasFlag(MaterialFlags.IS_MOLTEN_METAL) ? Optional.of(SoundEvents.f_11780_) : Optional.of(SoundEvents.f_11778_);
    }

    public Item m_6859_() {
        String key = this.materialMap.size() > 1 ? this.bucket_type.getRegistryKey(this.getMaterial(MaterialTexture.base), this.getMaterial(MaterialTexture.overlay)) : this.bucket_type.getRegistryKey(this.getMaterial(MaterialTexture.base), this.category);
        return IGRegistrationHolder.getItem.apply(key);
    }

    public int m_6719_(LevelReader pLevel) {
        int slopeFind;
        MaterialInterface<MaterialFlags> base = this.getMaterial(MaterialTexture.base);
        int n = slopeFind = base.hasFlag(MaterialFlags.IS_MOLTEN_METAL) ? 4 : 8;
        if (pLevel.m_6042_().f_63857_()) {
            slopeFind /= 2;
        }
        return slopeFind;
    }

    public int m_6713_(LevelReader pLevel) {
        return pLevel.m_6042_().f_63857_() ? 1 : 2;
    }

    @NotNull
    public BlockState m_5804_(@NotNull FluidState pState) {
        IFlagType<?> flag = this.getFlag();
        String key = this.materialMap.size() > 1 ? flag.getRegistryKey(this.getMaterial(MaterialTexture.base), this.getMaterial(MaterialTexture.overlay)) : flag.getRegistryKey(this.getMaterial(MaterialTexture.base));
        return (BlockState)IGRegistrationHolder.getBlock.apply(key + "_block").m_49966_().m_61124_((Property)LiquidBlock.f_54688_, (Comparable)Integer.valueOf(IGFluid.m_76092_((FluidState)pState)));
    }

    protected boolean m_5486_(FluidState fluidState, BlockGetter blockReader, BlockPos pos, Fluid fluidIn, Direction direction) {
        return direction == Direction.DOWN && !this.m_6212_(fluidIn);
    }

    public boolean m_6212_(@Nonnull Fluid fluidIn) {
        IFlagType<?> flag = this.getFlag();
        String key = this.materialMap.size() > 1 ? flag.getRegistryKey(this.getMaterial(MaterialTexture.base), this.getMaterial(MaterialTexture.overlay)) : flag.getRegistryKey(this.getMaterial(MaterialTexture.base));
        return fluidIn == IGRegistrationHolder.getFluid.apply(key) || fluidIn == IGRegistrationHolder.getFluid.apply(key + "_flowing");
    }

    public int m_6718_(LevelReader level) {
        int delay;
        MaterialInterface<MaterialFlags> base = this.getMaterial(MaterialTexture.base);
        int n = delay = base.hasFlag(MaterialFlags.IS_MOLTEN_METAL) ? 10 : 5;
        if (level.m_6042_().f_63857_()) {
            delay /= 2;
        }
        return delay;
    }

    public void m_6292_(Level level, BlockPos pos, FluidState state) {
        super.m_6292_(level, pos, state);
        this.getMaterial(MaterialTexture.base).fluidTick(level, pos, state);
    }

    protected void m_6364_(LevelAccessor level, BlockPos pos, BlockState state, Direction direction, FluidState fluidState) {
        if (this.getMaterial(MaterialTexture.base).fluidSpreadEvent(level, pos, state, direction, fluidState)) {
            return;
        }
        super.m_6364_(level, pos, state, direction, fluidState);
    }

    public static class Flowing
    extends IGFluid {
        public Flowing(MaterialInterface<?> material, @Nullable MaterialInterface<?> extra, BlockCategoryFlags flag, ItemCategoryFlags bucket_type) {
            super(flag, bucket_type, material, extra);
        }

        protected void m_7180_(StateDefinition.Builder<Fluid, FluidState> pBuilder) {
            super.m_7180_(pBuilder);
            pBuilder.m_61104_(new Property[]{f_75948_});
        }

        public int m_7430_(FluidState state) {
            return (Integer)state.m_61143_((Property)f_75948_);
        }

        public boolean m_7444_(@NotNull FluidState state) {
            return false;
        }
    }

    public static class Source
    extends IGFluid {
        public Source(MaterialInterface<?> material, @Nullable MaterialInterface<?> extra, BlockCategoryFlags flag, ItemCategoryFlags bucket_type) {
            super(flag, bucket_type, material, extra);
        }

        public int m_7430_(FluidState pState) {
            return 8;
        }

        public boolean m_7444_(FluidState pState) {
            return true;
        }
    }
}

