/*
 * Decompiled with CFR 0.152.
 */
package com.igteam.immersivegeology.common.fluid;

import com.igteam.immersivegeology.core.material.data.enums.ChemicalEnum;
import com.igteam.immersivegeology.core.material.helper.material.MaterialInterface;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateHolder;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FlowingFluid;
import net.minecraft.world.level.material.FluidState;
import org.jetbrains.annotations.NotNull;

public class IGFluidBlock
extends LiquidBlock {
    private final MaterialInterface<?> material;

    public IGFluidBlock(Supplier<? extends FlowingFluid> fluid, MaterialInterface<?> material, BlockBehaviour.Properties pProperties) {
        super(fluid, pProperties);
        this.material = material;
    }

    @NotNull
    public MutableComponent m_49954_() {
        return Component.m_237110_((String)this.m_7705_(), (Object[])new Object[]{I18n.m_118938_((String)("material.immersivegeology." + this.material.getName()), (Object[])new Object[0])});
    }

    @Nonnull
    public FluidState m_5888_(@Nonnull BlockState state) {
        FluidState baseState = super.m_5888_(state);
        for (Property prop : baseState.m_61147_()) {
            if (!state.m_61138_(prop)) continue;
            baseState = IGFluidBlock.withCopiedValue(prop, baseState, state);
        }
        return baseState;
    }

    public void m_7892_(BlockState state, Level level, BlockPos pos, Entity entity) {
        super.m_7892_(state, level, pos, entity);
        this.material.entityInside(state, level, pos, entity);
    }

    public static <T extends StateHolder<?, T>, S extends Comparable<S>> T withCopiedValue(Property<S> prop, T oldState, StateHolder<?, ?> copyFrom) {
        return (T)((StateHolder)oldState.m_61124_(prop, copyFrom.m_61143_(prop)));
    }

    public boolean isTranslucent() {
        return this.material instanceof ChemicalEnum;
    }
}

